/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.util;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectResultUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectResultUtil.class);

    public static synchronized void collectError(DevNode devNode, String description, String errorMsg) {
        if (!CollectResultUtil.isYingLong()) {
            return;
        }
        log.info("update dev {} , description {} msg {}", new Object[]{devNode.getIp(), description, errorMsg});
        ICollectInfo collectInfo = CollectResultUtil.getOrNewCollectInfo(devNode);
        ExecuteResult detail = new ExecuteResult();
        detail.setDevNode(devNode);
        detail.setDetail(errorMsg);
        detail.setDescription(description);
        detail.setResult(false);
        detail.setProgress(100);
        detail.setSingleProgress(100);
        detail.setNowStatus(CollectStatus.COLLECT_FAILED);
        collectInfo.addExecuteResult(detail);
    }

    public static boolean isYingLong() {
        return "yinglong".equalsIgnoreCase(System.getProperty("framework.scene"));
    }

    @NonNull
    private static synchronized ICollectInfo getOrNewCollectInfo(DevNode devNode) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo == null) {
            collectInfo = new CollectInfo(devNode);
            CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        }
        return collectInfo;
    }
}

