/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.implement;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainLayout;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;

public class NodeObserver
implements INodeObserver {
    private InfoCollectMainLayout infoCollectMainLayout;
    private InfoCollectMainDialog infoCollectMainDialog;

    public NodeObserver(InfoCollectMainLayout infoCollectMainLayout, InfoCollectMainDialog infoCollectMainDialog) {
        this.infoCollectMainLayout = infoCollectMainLayout;
        this.infoCollectMainDialog = infoCollectMainDialog;
    }

    public void fireNodeAdd(DevNode dev) {
        if (null == dev) {
            return;
        }
        CollectDeviceService.initDefaultSelectNode(dev);
        if (!InfoCollectUtil.isComputeStorageDevLoginThroughFcv(dev)) {
            this.addDeviceData(dev);
            return;
        }
        InfoCollectUtil.getComputeStorageDevs(dev).forEach(this::addDeviceData);
    }

    private void addDeviceData(DevNode dev) {
        TableRow<DevNode, String> row = this.infoCollectMainDialog.constructDeviceTableRow(dev);
        List oldRows = this.infoCollectMainLayout.getDeviceTableModel().getAllRows();
        this.infoCollectMainLayout.getDeviceTableModel().removeAll();
        RowSorter rowSorter = this.infoCollectMainLayout.getDeviceTable().getRowSorter();
        if (null != rowSorter) {
            rowSorter.setSortKeys(new ArrayList());
        }
        this.infoCollectMainLayout.getDeviceTableModel().addRow(new TableRow[]{row});
        oldRows.remove(row);
        this.infoCollectMainLayout.getDeviceTableModel().addRows(oldRows);
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }
}

