/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.maintainer;

import com.huawei.ism.tool.infocollect.maintainer.CommonMethod;
import com.huawei.ism.tool.infocollect.maintainer.NexDecompressPackageImpl;
import com.huawei.ism.tool.infocollect.service.DealFileInCopressPackage;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class CollectManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectManagement.class);
    private DevNode devNode;

    public CollectManagement(DevNode devNode) {
        this.devNode = devNode;
    }

    public String deCompressAndCompressFile(String downLoadFileName) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        return nexComps.deCompressAndCompressPackage(downLoadFileName);
    }

    public String deCompressAndCompressFile(String downLoadFileName, String[] pwds) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        return nexComps.deCompressAndCompressPackage(downLoadFileName, pwds);
    }

    public String deCompressFile(String downLoadFileName) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        return nexComps.deCompressingPackage(downLoadFileName);
    }

    public String compressFile(String collectPath) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        return nexComps.compressingPackage(collectPath);
    }

    public String deCompressAndCompressFileIsCloudService(String downLoadFileName) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        try {
            return nexComps.deCompressAndCompressPackage(downLoadFileName);
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deCompressAndCompressFile(String localPath, String downLoadFileName) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            LOGGER.info("localPath:{}", (Object)localPath);
            LOGGER.info("downLoadFileName:{}", (Object)downLoadFileName);
            try {
                String localFileName = localPath + File.separator + downLoadFileName;
                this.deCompressZipFile(localPath, localFileName);
                String resultDir = localPath + File.separator + downLoadFileName.split("\\.")[0];
                LOGGER.info("resultDir:{}", (Object)resultDir);
                this.deCompressConfigAndMessageFiles(resultDir, "Config", "Messages", "Event");
                this.createProductFile(resultDir + File.separator + "version");
                String aimFileName = CommonMethod.link7zFileName(localPath, this.devNode.getIp().replaceAll(":", "_"));
                FileAssistant.compressFile7z((String)aimFileName, (String[])new String[]{resultDir});
                this.delTmpFile(resultDir, localFileName);
                File aimFile = new File(aimFileName);
                LOGGER.info("FileName:{}", (Object)aimFileName);
                if (aimFile.exists()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return aimFile.getName();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            catch (ToolException e) {
                LOGGER.error("deCompressAndCompressFile error");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            catch (RuntimeException e) {
                LOGGER.error("There are some Exception in this process!");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
        }
    }

    private void deCompressZipFile(String path, String zipFileName) throws ToolException {
        try {
            if (!this.isTarGzFile(zipFileName)) {
                FileAssistant.deCopmressTotalZipFile((String)path, (String)zipFileName);
            } else {
                FileAssistant.deCompressTarGzFile((String)path, (String)zipFileName);
            }
        }
        catch (Exception e) {
            LOGGER.error("DeCompress zip file : path: !" + path + " zipFile: " + zipFileName + " error" + e);
            throw new ToolException("deCompressZipFile error", (Throwable)e);
        }
        LOGGER.info("DeCompress zip file : path: ! {} zipFile: {} finish.", (Object)path, (Object)zipFileName);
    }

    private boolean isTarGzFile(String fileName) {
        return fileName.endsWith(".tar.gz");
    }

    private void deCompressConfigAndMessageFiles(String collecPath, String ... includePaths) {
        ArrayList includes = new ArrayList(includePaths.length);
        Collections.addAll(includes, includePaths);
        File dataCollect = new File(collecPath);
        if (dataCollect.exists() && null != dataCollect.listFiles() && Objects.requireNonNull(dataCollect.listFiles()).length > 0) {
            for (File f : Objects.requireNonNull(dataCollect.listFiles())) {
                try {
                    FileAssistant.deCompressFiles((String)f.getCanonicalPath(), includes);
                }
                catch (IOException e) {
                    LOGGER.error("get file path error.", (Throwable)e);
                }
            }
        }
    }

    private void createProductFile(String filePath) {
        if (null == filePath) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    LOGGER.error("Can not create file: " + FilesUtil.getCanonicalPath((File)file));
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.info("create file error, file not found. file path is {}", (Object)filePath);
            }
            catch (IOException e) {
                LOGGER.error("create file error: " + FilesUtil.getCanonicalPath((File)file), (Throwable)e);
            }
        }
        String[] models = this.devNode.getDeviceType().toString().split("\\s");
        String ver = "";
        ver = models.length > 1 ? models[1] : models[0];
        String productStr = ver + this.devNode.getProductVersion();
        StreamUtils.writeInfo2File((byte[])productStr.getBytes(StandardCharsets.UTF_8), (String)filePath);
    }

    protected void delTmpFile(String sourceDir, String downLoadFileName) {
        FileAssistant.delDirAndFile((String)sourceDir);
        FileAssistant.delFile((String)downLoadFileName);
        LOGGER.info("Delete temp file finish!");
    }

    public String deCompressLogFiles(String downLoadFileName) {
        return "";
    }

    public synchronized Boolean addFileToZip(String zipFilePath, String addFile) {
        NexDecompressPackageImpl nex = new NexDecompressPackageImpl(this.devNode);
        return nex.addFileToPackage(zipFilePath, addFile);
    }

    public String compressFile(String z7ResultFile, String ... collectPath) {
        return this.compressFile(z7ResultFile, false, collectPath);
    }

    public String compressFile(String z7ResultFile, boolean anonymize, String ... collectPath) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        if (anonymize) {
            for (String subCollectPath : collectPath) {
                DealFileInCopressPackage.anonymizeCompressInFolder(subCollectPath, "Config.txt", "config", "config.tgz", "config.tar.gz", "config.tar.bz2", "clicmd.txt");
            }
        }
        String result = nexComps.compressingPackage(z7ResultFile, collectPath);
        return result;
    }

    public String deCompressAndCompressFiles(String downLoadFileName, String filesPath) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        String result = nexComps.deCompressAndCompressPackages(downLoadFileName, filesPath);
        return result;
    }

    public String deCompressAndCompressFiles(String downLoadFileName, String filesPath, boolean anonymize) {
        NexDecompressPackageImpl nexComps = new NexDecompressPackageImpl(this.devNode);
        String result = nexComps.deCompressAndCompressPackages(downLoadFileName, filesPath, anonymize);
        return result;
    }
}

