/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.maintainer;

import com.huawei.ism.tool.base.ui.file.FileTypeUtils;
import com.huawei.ism.tool.infocollect.maintainer.CommonMethod;
import com.huawei.ism.tool.infocollect.maintainer.ComponentDefine;
import com.huawei.ism.tool.infocollect.service.DealFileInCopressPackage;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class NexDecompressPackageImpl {
    private static final Logger RUNLOG = LoggerFactory.getLogger(NexDecompressPackageImpl.class);
    private static final int EXECUTE_COMPRESS_SUCCESS = 1;
    private DevNode devNode = null;

    public NexDecompressPackageImpl(DevNode devNode) {
        this.devNode = devNode;
    }

    public String deCompressAndCompressPackage(String packagePath) {
        return this.excuteDeCompressAndCompressPackage(packagePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String excuteDeCompressAndCompressPackage(String packagePath, String[] pwds) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            String targetPath = originalFile.getParent();
            String datacollectFilePath = targetPath + File.separator + "DataCollect";
            File dataCollectFile = new File(datacollectFilePath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdirs()) {
                RUNLOG.error("Create dir error.file path: " + datacollectFilePath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            FileAssistant.deCopmressTotalZipFile((String)datacollectFilePath, (String)packagePath);
            this.deCompressAllFiles(dataCollectFile, pwds);
            this.createProductFile(datacollectFilePath + File.separator + "version");
            String z7ResultFile = this.build7zFileName(targetPath);
            FileAssistant.compressFile7z((String)z7ResultFile, (String[])new String[]{datacollectFilePath});
            if (!FileAssistant.delDirWithOsCmd((String)datacollectFilePath)) {
                RUNLOG.error("Delete dir error.Dir path : " + datacollectFilePath);
            }
            if (!FileAssistant.delFile((String)packagePath)) {
                RUNLOG.error("Delete original file error.Dir path : " + packagePath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            File z7Result = new File(z7ResultFile);
            if (z7Result.exists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return "";
        }
    }

    private String excuteDeCompressAndCompressPackage(String packagePath, String additionalFilePath, String[] pwds) {
        return this.excuteDeCompressAndCompressPackage(packagePath, additionalFilePath, pwds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String excuteDeCompressAndCompressPackage(String packagePath, String additionalFilePath, String[] pwds, boolean anonymize) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return "";
            }
            String targetPath = originalFile.getParent();
            String datacollectFilePath = targetPath + File.separator + "DataCollect";
            File dataCollectFile = new File(datacollectFilePath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdirs()) {
                RUNLOG.error("Create dir error.file path: " + datacollectFilePath);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return "";
            }
            FileAssistant.deCopmressTotalZipFile((String)datacollectFilePath, (String)packagePath);
            this.deCompressAllFiles(dataCollectFile, pwds);
            if (anonymize) {
                DealFileInCopressPackage.anonymizeCompressInFolder(datacollectFilePath, "Config.txt", "config", "config.tgz", "config.tar.gz", "config.tar.bz2", "clicmd.txt");
            }
            this.createProductFile(datacollectFilePath + File.separator + "version");
            String z7ResultFile = this.build7zFileName(targetPath);
            FileAssistant.compressFile7z((String)z7ResultFile, (String[])new String[]{datacollectFilePath, additionalFilePath});
            if (!FileAssistant.delDirWithOsCmd((String)datacollectFilePath)) {
                RUNLOG.error("Delete dir error.Dir path : " + datacollectFilePath);
            }
            if (!FileAssistant.delFile((String)packagePath)) {
                RUNLOG.error("Delete original file error.Dir path : " + packagePath);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return "";
            }
            File z7Result = new File(z7ResultFile);
            if (z7Result.exists()) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deCompressingPackage(String packagePath) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
            String z7ResultFile = this.build7zFileName(originalFile.getParent());
            String collectPath = z7ResultFile.substring(0, z7ResultFile.lastIndexOf("."));
            File dataCollectFile = new File(collectPath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdirs()) {
                RUNLOG.error("Create dir error.file path: " + collectPath);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
            FileAssistant.deCopmressTotalZipFile((String)collectPath, (String)packagePath);
            this.deCompressAllFiles(dataCollectFile, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return collectPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressingPackage(String collectPath) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File z7Result;
            File file = new File(collectPath);
            if (!file.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
            String z7ResultFile = collectPath + ".7z";
            FileAssistant.compressFile7z((String)z7ResultFile, (String[])new String[]{collectPath});
            if (!FileAssistant.delDirWithOsCmd((String)collectPath)) {
                RUNLOG.error("Delete dir error.Dir path : " + collectPath);
            }
            if ((z7Result = new File(z7ResultFile)).exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "";
        }
    }

    private void deCompressAllFiles(File dataCollectFile, String[] pwds) {
        if (!dataCollectFile.exists()) {
            RUNLOG.error("file is not exist!");
            return;
        }
        File[] listFiles = dataCollectFile.listFiles();
        if (null == listFiles) {
            RUNLOG.error("file in " + FilesUtil.getCanonicalPath((File)dataCollectFile) + " is null!");
            return;
        }
        for (File file : listFiles) {
            String pathT = FilesUtil.getCanonicalPath((File)file);
            if (!pathT.endsWith(".bz2")) continue;
            FileAssistant.deCompressTarbz2File((String)file.getParent(), (String)pathT);
            if (FileAssistant.delFile((String)FilesUtil.getCanonicalPath((File)file))) continue;
            RUNLOG.error("Delete zip file error.Dir path : " + file.getName());
        }
        for (File file : listFiles) {
            this.decompressZipWithPassword(file, pwds);
            this.decompressZipWithPassword(file, pwds);
        }
    }

    private void createProductFile(String filePath) {
        if (null == filePath) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    RUNLOG.error("Can not create file: " + FilesUtil.getCanonicalPath((File)file));
                }
            }
            catch (IOException e) {
                RUNLOG.error("", (Throwable)e);
            }
        }
        String ver = this.devNode.getDeviceType().toString().replaceAll(" ", "");
        StreamUtils.writeInfo2File((byte[])ver.getBytes(StandardCharsets.UTF_8), (String)filePath);
    }

    private void decompressZipWithPassword(File path, String[] pwds) {
        if (!path.isDirectory()) {
            return;
        }
        File[] listFiles = path.listFiles();
        if (null == listFiles) {
            RUNLOG.info("file in {} is null!", (Object)FilesUtil.getCanonicalPath((File)path));
            return;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            if (fileName.endsWith("zip")) {
                this.executeDecompress(pwds, file);
                continue;
            }
            if (!fileName.endsWith("bz2")) continue;
            FileAssistant.deCompressTarbz2FileWithName((String)file.getParent(), (String)FilesUtil.getCanonicalPath((File)file));
            if (FileAssistant.delFile((String)FilesUtil.getCanonicalPath((File)file))) continue;
            RUNLOG.error("Delete zip file error.Dir path : " + file.getName());
        }
    }

    private void executeDecompress(String[] pwds, File file) {
        boolean judgePwds;
        int ret = 0;
        File decompressTmp = new File(file.getParentFile(), file.getName() + "_tmp");
        String decompressTmppath = "";
        try {
            decompressTmppath = decompressTmp.getCanonicalPath();
        }
        catch (Exception e) {
            RUNLOG.info("get path failed path : {}", (Object)FilesUtil.getCanonicalPath((File)decompressTmp));
            return;
        }
        if (!decompressTmp.mkdirs()) {
            RUNLOG.info("Create decompressTmp error.");
        }
        boolean bl = judgePwds = null != pwds && pwds.length > 0;
        if (judgePwds) {
            for (String pwd : pwds) {
                ret = FileAssistant.deCopmressZipFileWithPassword((String)decompressTmppath, (String)FilesUtil.getCanonicalPath((File)file), (String)pwd, (String[])new String[]{"*.bz2"});
                RUNLOG.info("Decompress {} from zip file {} with 7z result: {}", new Object[]{file, file.getParent(), ret});
                if (1 != ret) continue;
                RUNLOG.info("Decompress {} from zip file {} with 7z result: {}", new Object[]{file, file.getParent(), ret});
                break;
            }
            if (1 != ret) {
                ret = FileAssistant.deCopmressZipFileWithPassword((String)decompressTmppath, (String)FilesUtil.getCanonicalPath((File)file), (String)"", (String[])new String[]{"*.bz2"});
            }
        } else {
            ret = FileAssistant.deCopmressZipFileWithPassword((String)decompressTmppath, (String)FilesUtil.getCanonicalPath((File)file), (String)"", (String[])new String[]{"*.bz2"});
        }
        if (1 == ret) {
            FileUtils.copyDir((String)decompressTmppath, (String)file.getParent());
            FileAssistant.delFile((String)FilesUtil.getCanonicalPath((File)file));
            RUNLOG.error("Delete bz2 file error.Dir path : " + FilesUtil.getCanonicalPath((File)file));
        }
        FileUtils.deleteAllInFolder((String)decompressTmppath);
        if (!decompressTmp.delete()) {
            RUNLOG.error("Delete file error" + decompressTmppath);
        }
    }

    private String build7zFileName(String prefix) {
        return CommonMethod.link7zFileName(prefix, this.devNode.getIp().replaceAll(":", "_"));
    }

    public String deCompressAndCompressPackage(String downLoadFileName, String[] pwds) {
        return this.excuteDeCompressAndCompressPackage(downLoadFileName, pwds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Boolean addFileToPackage(String zipFilePath, String addFile) {
        String args = " a -t7z ";
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(zipFilePath);
            String fileCode = FileTypeUtils.getFileCode((FileInputStream)inputStream);
            if (fileCode != null && !fileCode.toLowerCase(Locale.ENGLISH).contains("377abcaf271c")) {
                args = " a -tzip ";
            }
        }
        catch (FileNotFoundException e) {
            RUNLOG.error("file {} not exist !", (Object)new File(zipFilePath).getName());
            Boolean bl = false;
            FileUtils.close((Closeable[])new Closeable[]{inputStream});
            return bl;
        }
        catch (Exception e2) {
            RUNLOG.error("something is error ! path = " + zipFilePath, (Throwable)e2);
            Boolean bl = false;
            {
                catch (Throwable throwable) {
                    FileUtils.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            FileUtils.close((Closeable[])new Closeable[]{inputStream});
            return bl;
        }
        FileUtils.close((Closeable[])new Closeable[]{inputStream});
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(args).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(" ").append(ComponentDefine.getMarks()).append(addFile).append(ComponentDefine.getMarks());
        return FileAssistant.executeCmd((String)cmd.toString(), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressingPackage(String z7ResultFile, String ... collectPaths) {
        String actual7zResultFile = z7ResultFile + ".7z";
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            FileAssistant.compressFile7z((String)actual7zResultFile, (String[])collectPaths);
            for (String collectPath : collectPaths) {
                if (FileAssistant.delDirWithOsCmd((String)collectPath)) continue;
                RUNLOG.error("Delete dir error.Dir path : " + collectPath);
            }
            File z7Result = new File(actual7zResultFile);
            if (z7Result.exists()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return "";
        }
    }

    public String deCompressAndCompressPackages(String packagePath, String additionalFilePath) {
        return this.excuteDeCompressAndCompressPackage(packagePath, additionalFilePath, null);
    }

    public String deCompressAndCompressPackages(String packagePath, String additionalFilePath, boolean anonymize) {
        return this.excuteDeCompressAndCompressPackage(packagePath, additionalFilePath, null, anonymize);
    }
}

