/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.maintainer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStreamClearCall
implements Callable<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStreamClearCall.class);
    private static final int SLEEP_300 = 300;
    private Process process;
    private boolean isWaitfor;
    private StringBuffer buff = new StringBuffer();

    public ProcessStreamClearCall(Process process) {
        this(process, false);
    }

    public ProcessStreamClearCall(Process process, boolean isWaitfor) {
        this.process = process;
        this.isWaitfor = isWaitfor;
    }

    @Override
    public String call() {
        try {
            this.refleshOutput(this.process.getInputStream());
            this.buff.append(System.lineSeparator()).append("stdout over---------------------------------------------------").append(System.lineSeparator());
            this.refleshOutput(this.process.getErrorStream());
            this.buff.append(System.lineSeparator()).append("stderr over---------------------------------------------------").append(System.lineSeparator());
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            LOGGER.error("Read ins error :", (Throwable)e);
        }
        if (!this.isWaitfor) {
            return this.buff.toString();
        }
        while (true) {
            try {
                Thread.sleep(300L);
                this.process.exitValue();
            }
            catch (InterruptedException ee) {
                LOGGER.info("this process thread has been interrupted", (Throwable)ee);
            }
            catch (RuntimeException e) {
                this.logException(e);
                continue;
            }
            break;
        }
        return this.buff.toString();
    }

    private void logException(RuntimeException exception) {
        try {
            LOGGER.info("exception", (Throwable)exception);
            LOGGER.info("the process is not over");
            this.refleshOutput(this.process.getInputStream());
            this.refleshOutput(this.process.getErrorStream());
            LOGGER.info("input buff!!!:{}", (Object)this.buff);
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.error("the second output error", (Throwable)ex);
        }
    }

    private void refleshOutput(InputStream is) throws InterruptedException, IOException {
        if (is == null) {
            return;
        }
        while (true) {
            Thread.sleep(300L);
            int len = is.available();
            if (len <= 0) break;
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            this.buff.append(new String(bs, 0, bSize, StandardCharsets.UTF_8));
        }
    }
}

