/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.context;

import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCollectCache {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectCache.class);
    private final Map<String, List<String>> selectedDisk = new HashMap<String, List<String>>();
    private final ConcurrentHashMap<DevNode, Integer> totalDiskNumMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<DevNode, String> failedEngineMap = new ConcurrentHashMap();
    private final Map<String, String> collectResultFile = new HashMap<String, String>();

    public static InfoCollectCache getInstance() {
        return InfoCollectCacheHolder.INSTANCE;
    }

    public void saveSelectedDisk(String deviceId, List<String> selectedDiskId) {
        if (selectedDiskId == null) {
            log.info("device {} selected disk is null");
            return;
        }
        this.selectedDisk.put(deviceId, selectedDiskId);
    }

    public List<String> querySelectedDisk(String deviceId) {
        if (this.selectedDisk.containsKey(deviceId)) {
            return new ArrayList<String>((Collection)this.selectedDisk.get(deviceId));
        }
        return new ArrayList<String>();
    }

    public void removeSelectDisk(String deviceId) {
        log.info("remove {} selected disk", (Object)deviceId);
        this.selectedDisk.remove(deviceId);
        this.failedEngineMap.keySet().removeIf(devNode -> deviceId.equals(devNode.getDeviceSerialNumber()));
    }

    public void addDiskNum(DevNode devNode, Integer number) {
        this.totalDiskNumMap.put(devNode, number);
    }

    public Integer queryDiskNum(DevNode devNode) {
        return this.totalDiskNumMap.get(devNode);
    }

    public void addFailEngine(DevNode devNode, String engine) {
        this.failedEngineMap.put(devNode, engine);
    }

    public String queryFailEngine(DevNode devNode) {
        return this.failedEngineMap.get(devNode);
    }

    public void saveCollectResultFile(String devId, String resultPath) {
        File file = new File(resultPath);
        if (!file.exists() || file.isDirectory()) {
            log.warn("{} collect path {} is not illegal", (Object)devId, (Object)resultPath);
            return;
        }
        this.collectResultFile.put(devId, resultPath);
    }

    public String queryCollectResultFile(String devId) {
        return this.collectResultFile.get(devId);
    }

    private InfoCollectCache() {
    }

    private static class InfoCollectCacheHolder {
        private static final InfoCollectCache INSTANCE = new InfoCollectCache();

        private InfoCollectCacheHolder() {
        }
    }
}

