/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCollectLock {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectLock.class);
    private static final int LOCK_TIME_OUT = 0x6DDD00;
    private final Map<String, CollectLock> deviceIdToLock = new HashMap<String, CollectLock>();
    private final Map<String, Long> deviceIdToLockId = new HashMap<String, Long>();

    public static InfoCollectLock getInstance() {
        return InfoCollectLockHolder.INSTANCE;
    }

    public synchronized boolean tryLock(String deviceId) {
        CollectLock collectLock = this.deviceIdToLock.get(deviceId);
        if (collectLock == null) {
            return this.createAndLock(deviceId);
        }
        long stamp = collectLock.getLock().tryWriteLock();
        if (stamp != 0L) {
            log.info("{} get lock success", (Object)deviceId);
            collectLock.setLockStartTime(System.currentTimeMillis());
            this.deviceIdToLockId.put(deviceId, stamp);
            return true;
        }
        log.info("{} get lock fail", (Object)deviceId);
        return this.unlockAndLock(deviceId, collectLock);
    }

    private boolean unlockAndLock(String deviceId, CollectLock collectLock) {
        if (!this.isTimeout(collectLock.getLockStartTime())) {
            return false;
        }
        StampedLock lock = collectLock.getLock();
        log.warn("{} lock is time out", (Object)deviceId);
        lock.unlockWrite(this.deviceIdToLockId.get(deviceId));
        long stamp = lock.tryWriteLock();
        if (stamp != 0L) {
            this.deviceIdToLockId.put(deviceId, stamp);
            collectLock.setLockStartTime(System.currentTimeMillis());
        }
        log.info("{} unlock and get lock {}", (Object)deviceId, (Object)(stamp != 0L ? 1 : 0));
        return stamp != 0L;
    }

    private boolean isTimeout(long startTime) {
        return System.currentTimeMillis() - startTime > 0x6DDD00L;
    }

    private boolean createAndLock(String deviceId) {
        CollectLock collectLock = new CollectLock();
        collectLock.setLockStartTime(System.currentTimeMillis());
        this.deviceIdToLock.put(deviceId, collectLock);
        log.info("{} get lock success", (Object)deviceId);
        long stamp = collectLock.getLock().writeLock();
        this.deviceIdToLockId.put(deviceId, stamp);
        return true;
    }

    public void unLock(String deviceId) {
        CollectLock collectLock = this.deviceIdToLock.get(deviceId);
        if (collectLock == null) {
            log.warn("{} lock is not exits", (Object)deviceId);
            return;
        }
        log.info("{} unlock", (Object)deviceId);
        collectLock.getLock().unlockWrite(this.deviceIdToLockId.get(deviceId));
    }

    public void destroyLock(String deviceId) {
        log.info("destroy {} collect lock", (Object)deviceId);
        this.deviceIdToLock.remove(deviceId);
    }

    private InfoCollectLock() {
    }

    private static class CollectLock {
        private final StampedLock lock = new StampedLock();
        private long lockStartTime;

        private CollectLock() {
        }

        public StampedLock getLock() {
            return this.lock;
        }

        public long getLockStartTime() {
            return this.lockStartTime;
        }

        public void setLockStartTime(long lockStartTime) {
            this.lockStartTime = lockStartTime;
        }
    }

    private static class InfoCollectLockHolder {
        private static final InfoCollectLock INSTANCE = new InfoCollectLock();

        private InfoCollectLockHolder() {
        }
    }
}

