/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.device.domain.service;

import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.rest.device.domain.entity.SupportDevice;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportDeviceService {
    private static final Logger log = LoggerFactory.getLogger(SupportDeviceService.class);
    private static final String KEY_WHITE_LIST = "whitelist";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}";
    private static final String VER_REGEX_POINT = "[\\d]{1,4}\\.[\\d]{1,4}\\.[a-zA-Z0-9]{1,14}(\\.[a-zA-Z0-9]{1,8})?(\\.[a-zA-Z0-9]{4})?";

    public List<SupportDevice> querySupportDevice() {
        log.info("start query support device");
        BizPackageService bizPackageService = new BizPackageService();
        Map<String, List<String>> supportTypeToVer = this.getModelTypes(bizPackageService.getSupportProductsWitchVersion());
        Map<String, List<String>> excludeTypeToVer = this.getModelTypes(bizPackageService.getExcludeProductsWitchVersion());
        Set<SupportVersionConf> whiteTypeVersions = bizPackageService.getSupportVersionConfs();
        ArrayList<String> supportType = new ArrayList<String>(supportTypeToVer.keySet());
        return Stream.concat(supportType.stream().filter(deviceType -> !"--".equals(deviceType)).map(deviceType -> this.buildSupportDevice((String)deviceType, supportTypeToVer, excludeTypeToVer, whiteTypeVersions)).sorted(Comparator.comparing(SupportDevice::getDeviceType)), this.getExtendSupportDevice().stream()).collect(Collectors.toList());
    }

    private SupportDevice buildSupportDevice(String deviceType, Map<String, List<String>> supportTypeToVersion, Map<String, List<String>> excludeTypeToVersion, Set<SupportVersionConf> whiteTypeVersions) {
        List<String> supportVer = this.sortVersions(supportTypeToVersion.get(deviceType));
        List<String> excludeVer = this.sortVersions(excludeTypeToVersion.get(deviceType));
        return this.createSupportDevice(deviceType, supportVer, excludeVer, whiteTypeVersions);
    }

    private SupportDevice createSupportDevice(String deviceType, List<String> supportVer, List<String> excludeVer, Set<SupportVersionConf> whiteTypeVersions) {
        String curType = deviceType;
        if ("Red Hat,SUSE".contains(deviceType)) {
            curType = "T3000-" + deviceType;
        }
        Map<String, List<String>> detailedVers = this.constructDetailVers(curType, supportVer, excludeVer, whiteTypeVersions);
        if (supportVer.isEmpty()) {
            ArrayList<String> allVer = new ArrayList<String>();
            allVer.add("ALL");
            detailedVers.put(KEY_WHITE_LIST, allVer);
            return new SupportDevice(curType, allVer, detailedVers);
        }
        return new SupportDevice(curType, supportVer, detailedVers);
    }

    private List<SupportDevice> getExtendSupportDevice() {
        ArrayList<SupportDevice> supportDevices = new ArrayList<SupportDevice>();
        Map<String, String> versionMap = BizPackageService.loadExtendSysconf();
        if (versionMap == null || versionMap.isEmpty()) {
            return supportDevices;
        }
        for (String name : versionMap.keySet()) {
            String ver = versionMap.get(name);
            HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
            ArrayList<String> versions = new ArrayList<String>();
            versions.add(ver);
            verionMap.put(KEY_WHITE_LIST, versions);
            SupportDevice supportDevice = new SupportDevice(name, Collections.singletonList(ver), verionMap);
            supportDevices.add(supportDevice);
        }
        return supportDevices;
    }

    private List<String> sortVersions(List<String> vers) {
        if (!CollectionUtils.isEmpty(vers)) {
            vers.sort((first, second) -> Collator.getInstance().compare((String)first, (String)second));
            return vers;
        }
        return new ArrayList<String>();
    }

    private Map<String, List<String>> constructDetailVers(String deviceType, List<String> supportVer, List<String> excludeVer, Set<SupportVersionConf> whiteTypeVersion) {
        HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
        List<String> whiteVersions = this.getWhiteVersions(deviceType, supportVer, whiteTypeVersion);
        verionMap.put(KEY_WHITE_LIST, this.sortVersions(whiteVersions));
        if (excludeVer != null && !excludeVer.isEmpty()) {
            ArrayList<String> blacklist = new ArrayList<String>(excludeVer);
            verionMap.put("blacklist", this.sortVersions(blacklist));
        }
        return verionMap;
    }

    private List<String> getWhiteVersions(String deviceType, List<String> supportVer, Set<SupportVersionConf> whiteTypeVersion) {
        boolean isEngEnv = ApplicationContext.getInstance().isEnglishEnv();
        return Stream.concat(whiteTypeVersion.stream().filter(versionConf -> deviceType.equals(versionConf.getModel())).map(versionConf -> isEngEnv ? versionConf.getDescEn() : versionConf.getDescZh()).map(versionStr -> versionStr.split(",")).flatMap(Arrays::stream), supportVer.stream()).collect(Collectors.toList());
    }

    private Map<String, List<String>> getModelTypes(Set<String> deviceTypeAndVersions) {
        HashMap<String, List<String>> deviceTypeToVersion = new HashMap<String, List<String>>();
        for (String detail : deviceTypeAndVersions) {
            String version = this.splitGetVersion(detail);
            String deviceType = detail.replace(version, "").trim();
            deviceTypeToVersion.computeIfAbsent(deviceType, key -> new ArrayList()).add(version);
        }
        return deviceTypeToVersion;
    }

    private String splitGetVersion(String ver) {
        String matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX, (int)0);
        String version = "";
        if (!StringUtils.isNULLStr((String)matchStr)) {
            return ver.substring(ver.indexOf(matchStr)).trim();
        }
        matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX_POINT, (int)0);
        if (!StringUtils.isNULLStr((String)matchStr)) {
            return ver.substring(ver.indexOf(matchStr)).trim();
        }
        String[] types = ver.split(" ");
        if (types.length > 1) {
            version = types[types.length - 1].trim();
        }
        return version;
    }
}

