/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.factory;

import com.huawei.ism.tool.infocollect.rest.item.domain.service.ISecondConfirm;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.impl.DefaultSecondConfirmService;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.impl.DiskRunLogSecondConfirm;
import java.util.Arrays;

public enum SecondConfirmFactory {
    DISK_RUNNING_LOG("normal_disklog"){

        @Override
        public ISecondConfirm createSecondConfirmService() {
            return new DiskRunLogSecondConfirm();
        }
    }
    ,
    DEFAULT(""){

        @Override
        public ISecondConfirm createSecondConfirmService() {
            return new DefaultSecondConfirmService();
        }
    };

    private final String needConfirmItemId;

    public static SecondConfirmFactory get(String itemId) {
        return Arrays.stream(SecondConfirmFactory.values()).filter(cur -> cur.needConfirmItemId.equals(itemId)).findFirst().orElse(DEFAULT);
    }

    public abstract ISecondConfirm createSecondConfirmService();

    public String getNeedConfirmItemId() {
        return this.needConfirmItemId;
    }

    private SecondConfirmFactory(String needConfirmItemId) {
        this.needConfirmItemId = needConfirmItemId;
    }
}

