/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.service;

import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectErrorCode;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.SecondConfirmResult;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.factory.CollectItemSettingFactory;
import com.huawei.ism.tool.infocollect.rest.item.domain.factory.SecondConfirmFactory;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.support.DeviceDownLoadTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectItemService {
    private static final Logger log = LoggerFactory.getLogger(CollectItemService.class);
    private final BizPackageService bizPackageService = new BizPackageService();

    public StorageItemSetting queryCollectItem(DevNode devNode, CollectItemQuery param) throws InfoCollectException {
        this.initCollectItems(devNode);
        CollectConf collectConf = this.bizPackageService.getCollectConf(devNode);
        if (collectConf == null) {
            throw new InfoCollectException(InfoCollectErrorCode.DEVICE_NOT_SUPPORT);
        }
        return CollectItemSettingFactory.getSettingService(devNode).queryItemSetting(devNode, param);
    }

    public Object querySecondConfirmData(DevNode devNode, String itemId) throws InfoCollectException {
        return SecondConfirmFactory.get(itemId).createSecondConfirmService().querySecondConfirmData(devNode);
    }

    public void saveSecondConfirmItem(DevNode devNode, SecondConfirmResult param) throws InfoCollectException {
        SecondConfirmFactory.get(param.getItemId()).createSecondConfirmService().saveSecondConfirmResult(devNode, param);
    }

    public void saveCollectItemSetting(DevNode devNode, CollectItemSaveSetting setting) throws InfoCollectException {
        CollectItemSettingFactory.getSettingService(devNode).saveItemSetting(devNode, setting);
    }

    private void initCollectItems(DevNode devNode) throws InfoCollectException {
        IntegrateCollectInfo collectInfo;
        log.info("{} start init collect items", (Object)devNode.getDeviceSerialNumber());
        if (devNode.isDsStorage()) {
            DeviceDownLoadTask deviceDownLoadTask = new DeviceDownLoadTask(null, devNode);
            Boolean downloadStatus = deviceDownLoadTask.call();
            log.info("download {} collect item status: {}", (Object)devNode.getDeviceSerialNumber(), (Object)downloadStatus);
        }
        if ((collectInfo = InfoCollectService.getInstance().constructIntegrateInfo(devNode)) == null) {
            log.error("{} construct collect info fail", (Object)devNode.getDeviceSerialNumber());
            throw new InfoCollectException(InfoCollectErrorCode.DEVICE_NOT_SUPPORT);
        }
    }
}

