/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.service.impl;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectModuleResponse;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectNode;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.DstorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.FlashStorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.ICollectItemSetting;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectItemSetting
implements ICollectItemSetting {
    private static final Logger log = LoggerFactory.getLogger(AbstractCollectItemSetting.class);

    @Override
    public StorageItemSetting queryItemSetting(DevNode devNode, CollectItemQuery param) throws InfoCollectException {
        log.info("start query {} item setting, scene: {}", (Object)devNode.getDeviceSerialNumber(), (Object)param.getScene());
        this.initScene(devNode, param);
        List<CollectModuleResponse> needModule = this.queryAllModuleByParam(devNode, param);
        List<String> selectedItemIds = this.querySelectedItemIds(devNode, param);
        this.selectItems(needModule, selectedItemIds);
        StorageItemSetting setting = this.createStorageItemSetting(devNode, param, needModule);
        this.beforeReturnQuerySettingResult(devNode, setting);
        return setting;
    }

    private StorageItemSetting createStorageItemSetting(DevNode devNode, CollectItemQuery param, List<CollectModuleResponse> needModule) throws InfoCollectException {
        if (devNode.isDsStorage()) {
            return ((DstorageItemSetting.DstorageItemSettingBuilder)((DstorageItemSetting.DstorageItemSettingBuilder)((DstorageItemSetting.DstorageItemSettingBuilder)((DstorageItemSetting.DstorageItemSettingBuilder)DstorageItemSetting.builder().scene(param.getScene())).supportScene(this.querySupportScene(devNode))).nodes(this.queryNeedNodes(devNode, param))).modules(needModule)).build();
        }
        return ((FlashStorageItemSetting.FlashStorageItemSettingBuilder)((FlashStorageItemSetting.FlashStorageItemSettingBuilder)((FlashStorageItemSetting.FlashStorageItemSettingBuilder)((FlashStorageItemSetting.FlashStorageItemSettingBuilder)FlashStorageItemSetting.builder().scene(param.getScene())).supportScene(this.querySupportScene(devNode))).nodes(this.queryNeedNodes(devNode, param))).modules(needModule)).build();
    }

    @Override
    public void saveItemSetting(DevNode devNode, CollectItemSaveSetting setting) throws InfoCollectException {
        log.info("{} start save item save, scene: {}", (Object)devNode.getDeviceSerialNumber(), (Object)setting.getSelectedScene());
        this.verifySetting(devNode, setting);
        ICollectInfo collectInfo = this.buildCollectInfo(devNode, setting);
        CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        this.afterSaveItemSetting(devNode, collectInfo, setting);
    }

    protected void verifySetting(DevNode devNode, CollectItemSaveSetting setting) throws InfoCollectException {
        if (CollectionUtil.isEmpty(setting.getSelectedItemIds())) {
            throw new InfoCollectException("infocollect.remind.onecollectitematleast");
        }
        if (CollectionUtils.isEmpty(setting.getSelectedNodeIds())) {
            throw new InfoCollectException("collect_node_is_empty");
        }
    }

    protected abstract ICollectInfo buildCollectInfo(DevNode var1, CollectItemSaveSetting var2) throws InfoCollectException;

    protected abstract void initScene(DevNode var1, CollectItemQuery var2);

    protected abstract List<CollectModuleResponse> queryAllModuleByParam(DevNode var1, CollectItemQuery var2);

    protected abstract List<String> querySelectedItemIds(DevNode var1, CollectItemQuery var2);

    protected abstract List<ModeType> querySupportScene(DevNode var1);

    protected abstract List<CollectNode> queryNeedNodes(DevNode var1, CollectItemQuery var2) throws InfoCollectException;

    private void selectItems(List<CollectModuleResponse> modules, List<String> selectedItemIds) {
        modules.stream().map(CollectModuleResponse::getItems).flatMap(Collection::stream).filter(item -> selectedItemIds.contains(item.getId())).forEach(item -> item.setSelected(true));
    }

    protected void beforeReturnQuerySettingResult(DevNode devNode, StorageItemSetting setting) {
    }

    protected void afterSaveItemSetting(DevNode devNode, ICollectInfo collectInfo, CollectItemSaveSetting setting) {
    }
}

