/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.service.impl;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.DiskInfo;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.DiskRunLogResult;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.SecondConfirm;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.SecondConfirmResult;
import com.huawei.ism.tool.infocollect.rest.item.domain.mapper.DiskInfoMapper;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.ISecondConfirm;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.ui.setup.QryDiskPythonCallable;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskRunLogSecondConfirm
implements ISecondConfirm {
    private static final Logger log = LoggerFactory.getLogger(DiskRunLogSecondConfirm.class);

    @Override
    public SecondConfirm querySecondConfirm(DevNode devNode) {
        if (this.needShowSecondConfirm(devNode)) {
            return SecondConfirm.builder().need(true).tip(ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0])).content(ResourceUtil.getString((String)"inform.disklog.risk.check.sign")).build();
        }
        return SecondConfirm.builder().build();
    }

    private boolean needShowSecondConfirm(DevNode devNode) {
        return !this.isSelectedDisks(CollectDataContext.getInstance().getDiskTotalNumMap().get(devNode), CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode));
    }

    private boolean isSelectedDisks(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        if (InfoCollectUtil.isDiskTreeMapEmptyOrNull(diskInt, diskTreeMap)) {
            log.info("The disk tree map is empty or null.");
            return false;
        }
        return true;
    }

    @Override
    public Object querySecondConfirmData(DevNode devNode) throws InfoCollectException {
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        Integer diskInt = CollectDataContext.getInstance().getDiskTotalNumMap().get(devNode);
        if (InfoCollectUtil.isDiskTreeMapEmptyOrNull(diskInt, diskTreeMap)) {
            diskTreeMap = this.queryDiskInfo(devNode);
            diskInt = InfoCollectCache.getInstance().queryDiskNum(devNode);
            this.isQueryDisksInfoFailed(diskInt, diskTreeMap);
            CollectDataContext.getInstance().getGlobalConDiskHashMap().put(devNode, diskTreeMap);
            if (diskInt != null) {
                CollectDataContext.getInstance().getDiskTotalNumMap().put(devNode, diskInt);
            }
        }
        this.isAllEngineSuccess(devNode);
        return diskTreeMap.values().stream().map(DiskInfoMapper.INSTANCE::toDiskInfo).peek(diskInfo -> this.selectedDisk(devNode, (DiskInfo)diskInfo)).collect(Collectors.toList());
    }

    private void selectedDisk(DevNode devNode, DiskInfo diskInfo) {
        List<String> selectedDiskIds = InfoCollectCache.getInstance().querySelectedDisk(devNode.getDeviceSerialNumber());
        if (selectedDiskIds.contains(diskInfo.getDiskId())) {
            diskInfo.setSelected(true);
        }
    }

    private TreeMap<DiskLocation, Disk> queryDiskInfo(DevNode devNode) {
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(new CollectInfo(devNode), false);
        command.process();
        QryDiskPythonCallable qryDiskPythonCallable = new QryDiskPythonCallable(null, devNode, command.getCollectEnv());
        Object result = qryDiskPythonCallable.call();
        return result == null ? new TreeMap() : result;
    }

    private void isQueryDisksInfoFailed(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) throws InfoCollectException {
        if (diskInt != null && diskInt == -1) {
            throw new InfoCollectException("need.dbg.pwd");
        }
        if (diskInt != null && diskInt == -2) {
            throw new InfoCollectException("no.disk.due.to.too.much.sensitive.disk");
        }
        if (VerifyUtil.isEmpty(diskTreeMap)) {
            throw new InfoCollectException("call.python.qry.disks.failed");
        }
    }

    private void isAllEngineSuccess(DevNode devNode) throws InfoCollectException {
        String failedEngines = InfoCollectCache.getInstance().queryFailEngine(devNode);
        if (StringUtils.isNULLStr((String)failedEngines)) {
            log.info("All engines success.");
            return;
        }
        throw new InfoCollectException("disk.qry.high.end.engine.failed", failedEngines);
    }

    @Override
    public void saveSecondConfirmResult(DevNode devNode, SecondConfirmResult param) throws InfoCollectException {
        List<String> selectedDiskIds = new ArrayList<String>();
        if (param instanceof DiskRunLogResult) {
            DiskRunLogResult selectedDisk = (DiskRunLogResult)param;
            selectedDiskIds = selectedDisk.getSelectedDiskIds();
        }
        InfoCollectCache.getInstance().saveSelectedDisk(devNode.getDeviceSerialNumber(), selectedDiskIds);
    }
}

