/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.service.impl;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.ItemConditionTag;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SettingParserInfo;
import com.huawei.ism.tool.infocollect.rest.entity.CollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.DstorageCollectParam;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectModuleResponse;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectNode;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.DstorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.DstorageSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.mapper.CollectModuleMapper;
import com.huawei.ism.tool.infocollect.rest.item.domain.mapper.CollectNodeMapper;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.impl.AbstractCollectItemSetting;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.util.DStoragePackageUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.common.util.DistributeRestUriUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCollectItemService
extends AbstractCollectItemSetting {
    private static final Logger log = LoggerFactory.getLogger(DistributedCollectItemService.class);
    private static final String PRODUCT_SERIES_URI = "/config/public-rundata.json";
    private static final String BOMCODES_KEY = "bomCodes";
    private static final String PRODUCT_SERIES_KEY = "productSeries";
    private static final String DATA_KEY = "data";
    private static final String BOMCODE_KEY = "bomCode";
    private static final List<String> FILE_SERVES = Arrays.asList("LFSFSSTDCAPSATA01", "LFSFSSTDCAPSAS01", "LFSFSSTDCAPSSD01", "LFSFSAVCAPSATA01", "LFSFSAVCAPSAS01", "LFSFSAVCAPSSD01");
    private final BizPackageService bizPackageService = new BizPackageService();

    @Override
    protected List<CollectModuleResponse> queryAllModuleByParam(DevNode devNode, CollectItemQuery param) {
        return this.queryOriginModule(devNode, param).stream().filter(module -> !"antivirus_log".equals(module.getModuleId()) || this.needCollectAntiVirusLog(devNode)).filter(module -> this.checkItemTag(devNode, (CollectModule)module)).map(CollectModuleMapper.INSTANCE::collectModuleToResponse).collect(Collectors.toList());
    }

    private List<CollectModule> queryOriginModule(DevNode devNode, CollectItemQuery param) {
        CollectConf collectConf = this.bizPackageService.getCollectConf(devNode);
        List<CollectModule> needModules = param.getScene() == ModeType.D_STORAGE_BY_FAULT ? collectConf.getSimpleCollectModules() : collectConf.getDefaultModules();
        return needModules;
    }

    @Override
    protected List<String> querySelectedItemIds(DevNode devNode, CollectItemQuery param) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        CollectConfInfo mainConfInfo = collectInfo.getCollectConfInfo();
        ArrayList<CollectItem> selectedItems = new ArrayList<CollectItem>();
        selectedItems.addAll(mainConfInfo.getSimpleCollectSelectItems());
        selectedItems.addAll(mainConfInfo.getDefaultSelectItems());
        return selectedItems.stream().map(CollectItem::getId).distinct().collect(Collectors.toList());
    }

    @Override
    protected List<ModeType> querySupportScene(DevNode devNode) {
        ArrayList<ModeType> supportScene = new ArrayList<ModeType>();
        supportScene.add(ModeType.D_STORAGE_BY_COMPONENT);
        if (DStoragePackageUtil.isSupportReduceCollect(devNode)) {
            supportScene.add(0, ModeType.D_STORAGE_BY_FAULT);
        }
        return supportScene;
    }

    @Override
    protected List<CollectNode> queryNeedNodes(DevNode devNode, CollectItemQuery param) {
        return devNode.getClusterNodes().stream().map(CollectNodeMapper.INSTANCE::toDStorageCollectNode).collect(Collectors.toList());
    }

    private boolean checkItemTag(DevNode devNode, CollectModule module) {
        return module.getItems().stream().anyMatch(item -> !ItemConditionTag.checkItemTag(item.getItemConditionTag(), devNode));
    }

    @Override
    protected void initScene(DevNode devNode, CollectItemQuery param) {
        if (param.getScene() != null) {
            return;
        }
        if (DStoragePackageUtil.isSupportReduceCollect(devNode)) {
            param.setScene(ModeType.D_STORAGE_BY_FAULT);
        } else {
            param.setScene(ModeType.D_STORAGE_BY_COMPONENT);
        }
    }

    private boolean needCollectAntiVirusLog(DevNode devNode) {
        try {
            String envInfo = this.queryEnvInfo(devNode);
            if (!"pacific".equalsIgnoreCase(envInfo)) {
                return false;
            }
            return this.isFileMode(devNode);
        }
        catch (ToolException e) {
            log.error("collect envinfo and servesinfo error", (Throwable)e);
            return false;
        }
    }

    private String queryEnvInfo(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo envInfoResponse = conn.execGet(DistributedCollectItemService.getProductSeriesUri(devNode));
        Optional<String> envInfo = Optional.ofNullable(envInfoResponse.getContent()).map(JSONObject::new).map(envJson -> envJson.get(PRODUCT_SERIES_KEY).toString());
        if (!envInfo.isPresent()) {
            return "NoSuccess";
        }
        return envInfo.get();
    }

    private boolean isFileMode(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo licensesResponse = conn.execGet(DistributeRestUriUtil.getActiveLicensesUri((DevNode)devNode));
        return Optional.ofNullable(licensesResponse.getContent()).map(JSONObject::new).map(contentJson -> contentJson.getJSONObject(DATA_KEY)).filter(data -> data.keySet().contains(BOMCODES_KEY)).map(data -> data.getJSONArray(BOMCODES_KEY)).map(this::isBomCodesContainFileMode).orElse(false);
    }

    private boolean isBomCodesContainFileMode(JSONArray bomCodes) {
        for (int i = 0; i < bomCodes.length(); ++i) {
            JSONObject bomCode;
            if (!(bomCodes.get(i) instanceof JSONObject) || !(bomCode = (JSONObject)bomCodes.get(i)).has(BOMCODE_KEY) || !FILE_SERVES.contains(bomCode.get(BOMCODE_KEY).toString())) continue;
            return true;
        }
        return false;
    }

    public static String getProductSeriesUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead((DevNode)devNode).append(PRODUCT_SERIES_URI).toString();
    }

    @Override
    protected ICollectInfo buildCollectInfo(DevNode devNode, CollectItemSaveSetting setting) {
        devNode.getClusterNodes().forEach(node -> node.setSelected(setting.getSelectedNodeIds().contains(String.valueOf(node.getId()))));
        DstorageSaveSetting dsSetting = new DstorageSaveSetting();
        if (setting instanceof DstorageSaveSetting) {
            dsSetting = (DstorageSaveSetting)setting;
        }
        CollectParam param = ((DstorageCollectParam.DstorageCollectParamBuilder)((CollectParam.CollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)DstorageCollectParam.builder().selectedScene(setting.getSelectedScene())).selectedItems(this.getSelectedItems(devNode, setting))).duration(this.getDuration(dsSetting))).settingConfInfo(this.getSettingConfInfo(devNode, dsSetting))).devNode(devNode)).build();
        CollectInfoBuilder collectInfoBuilder = new CollectInfoBuilder(param);
        return collectInfoBuilder.buildDStorageCollect();
    }

    @NotNull
    private SettingConfInfo getSettingConfInfo(DevNode devNode, DstorageSaveSetting dsSetting) {
        SettingConfInfo settingConf = this.getOriginSettingConf(devNode);
        Map<String, Object> settingInfo = settingConf.getSettingInfo();
        SimpleDateFormat locFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        settingInfo.put("startTime", locFormat.format(dsSetting.getStartTime()));
        settingInfo.put("endTime", locFormat.format(dsSetting.getEndTime()));
        return settingConf;
    }

    private SettingConfInfo getOriginSettingConf(DevNode devNode) {
        CollectDataContext context = CollectDataContext.getInstance();
        Map<DevNode, CollectInfo> collectInfo = context.getCollectInfo(devNode).getCollectInfoes();
        SettingConfInfo settingConfInfo = collectInfo.get(devNode).getSettingConfInfo();
        if (settingConfInfo == null) {
            return this.bizPackageService.getSettingConf(devNode);
        }
        return settingConfInfo;
    }

    private CollectDuration getDuration(DstorageSaveSetting dsSetting) {
        CollectDuration duration = new CollectDuration();
        duration.setStartDate(dsSetting.getStartTime());
        duration.setEndDate(dsSetting.getEndTime());
        return duration;
    }

    private List<CollectItem> getSelectedItems(DevNode devNode, CollectItemSaveSetting setting) {
        return this.queryOriginModule(devNode, new CollectItemQuery(setting.getSelectedScene())).stream().map(CollectModule::getItems).flatMap(Collection::stream).filter(item -> setting.getSelectedItemIds().contains(item.getId())).collect(Collectors.toList());
    }

    @Override
    protected void beforeReturnQuerySettingResult(DevNode devNode, StorageItemSetting setting) {
        SettingConfInfo settingConf;
        StorageItemSetting dsSetting = ((DstorageItemSetting.DstorageItemSettingBuilder)((DstorageItemSetting.DstorageItemSettingBuilder)DstorageItemSetting.builder().startTime("")).endTime("")).build();
        if (setting instanceof DstorageItemSetting) {
            dsSetting = (DstorageItemSetting)setting;
        }
        if ((settingConf = this.getOriginSettingConf(devNode)) == null) {
            return;
        }
        StorageItemSetting finalDsSetting = dsSetting;
        settingConf.getParserList().stream().filter(info -> "date".equals(info.getType())).forEach(arg_0 -> DistributedCollectItemService.lambda$beforeReturnQuerySettingResult$10(settingConf, (DstorageItemSetting)finalDsSetting, arg_0));
    }

    private static /* synthetic */ void lambda$beforeReturnQuerySettingResult$10(SettingConfInfo settingConf, DstorageItemSetting finalDsSetting, SettingParserInfo info) {
        String time = "";
        Object timeObject = settingConf.getSettingInfo().get(info.getKey());
        if (timeObject instanceof String) {
            time = (String)timeObject;
        }
        if ("startTime".equals(info.getKey())) {
            finalDsSetting.setStartTime(time);
        } else {
            finalDsSetting.setEndTime(time);
        }
    }
}

