/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.item.domain.service.impl;

import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SettingParserInfo;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.entity.CollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.FlashCollectParam;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectErrorCode;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemResponse;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectModuleResponse;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectNode;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.FlashCollectNode;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.FlashStorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.factory.SecondConfirmFactory;
import com.huawei.ism.tool.infocollect.rest.item.domain.mapper.CollectModuleMapper;
import com.huawei.ism.tool.infocollect.rest.item.domain.mapper.CollectNodeMapper;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.impl.AbstractCollectItemSetting;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashCollectItemService
extends AbstractCollectItemSetting {
    private static final Logger log = LoggerFactory.getLogger(FlashCollectItemService.class);
    private final BizPackageService bizPackageService = new BizPackageService();

    private boolean filterNeedNodeByType(CollectItemQuery param, FlashCollectNode node) {
        if (param.getScene() == ModeType.CUSTOM_COLLECT) {
            return StringUtils.equalsIgnoreCase((CharSequence)"controller", (CharSequence)node.getType());
        }
        return true;
    }

    @Override
    protected void initScene(DevNode devNode, CollectItemQuery param) {
        log.info("{} init scene, param: {}", (Object)param.getScene());
        if (InfoCollectUtil.isSupportCollectedByScene(devNode)) {
            this.queryScene(devNode, param);
        } else {
            log.info("{} not support collect by scene, set support custom_collect", (Object)devNode.getDeviceSerialNumber());
            param.setScene(ModeType.CUSTOM_COLLECT);
        }
    }

    private void queryScene(DevNode devNode, CollectItemQuery param) {
        CollectConfInfo collectConfInfo = CollectDataContext.getInstance().getCollectInfo(devNode).getCollectConfInfo();
        if (param.getScene() != null) {
            return;
        }
        if (collectConfInfo.isDepthCollect()) {
            param.setScene(ModeType.DEPTH_COLLECT);
        } else if (collectConfInfo.isQuicklyCollect()) {
            param.setScene(ModeType.QUICKLY_COLLECT);
        } else if (collectConfInfo.isCustomCollect()) {
            param.setScene(ModeType.CUSTOM_COLLECT);
        } else {
            param.setScene(ModeType.QUICKLY_COLLECT);
        }
    }

    @Override
    protected List<CollectModuleResponse> queryAllModuleByParam(DevNode devNode, CollectItemQuery param) {
        if (InfoCollectUtil.isSupportCollectedByScene(devNode)) {
            return this.bizPackageService.getCollectConf(devNode).getSpecifiedModules(param.getScene()).stream().map(CollectModuleMapper.INSTANCE::collectModuleToResponse).collect(Collectors.toList());
        }
        return this.bizPackageService.getCollectConf(devNode).getModules().stream().map(CollectModuleMapper.INSTANCE::collectModuleToResponse).collect(Collectors.toList());
    }

    @Override
    protected List<String> querySelectedItemIds(DevNode devNode, CollectItemQuery param) {
        CollectConfInfo mainConfInfo = CollectDataContext.getInstance().getCollectInfo(devNode).getCollectConfInfo();
        List<CollectItem> selectedItems = this.queryAllSelectItem(devNode, param.getScene(), mainConfInfo);
        return selectedItems.stream().map(CollectItem::getId).collect(Collectors.toList());
    }

    private List<CollectItem> queryAllSelectItem(DevNode devNode, ModeType scene, CollectConfInfo mainConfInfo) {
        if (InfoCollectUtil.isSupportCollectedByScene(devNode)) {
            return this.querySelectItemByScene(scene, mainConfInfo);
        }
        return mainConfInfo.getSelectItems();
    }

    private List<CollectItem> querySelectItemByScene(ModeType scene, CollectConfInfo mainConfInfo) {
        if (scene == ModeType.SIMPLE_COLLECT) {
            return mainConfInfo.getSimpleCollectSelectItems();
        }
        if (scene == ModeType.DEPTH_COLLECT) {
            return mainConfInfo.getDepthCollectSelectItems();
        }
        return mainConfInfo.getCustomCollectSelectItems();
    }

    @Override
    protected List<ModeType> querySupportScene(DevNode devNode) {
        if (InfoCollectUtil.isSupportCollectedByScene(devNode)) {
            return Arrays.asList(ModeType.QUICKLY_COLLECT, ModeType.DEPTH_COLLECT, ModeType.CUSTOM_COLLECT);
        }
        return Collections.singletonList(ModeType.CUSTOM_COLLECT);
    }

    @Override
    protected List<CollectNode> queryNeedNodes(DevNode devNode, CollectItemQuery param) throws InfoCollectException {
        if (InfoCollectUtil.isSupportCollectedByScene(devNode) || InfoCollectUtil.isNewOceanStor9000(devNode)) {
            SettingConfInfo settingConf = this.bizPackageService.getSettingConf(devNode);
            if (settingConf == null) {
                throw new InfoCollectException(InfoCollectErrorCode.QUERY_DEVICE_INFO_ERROR);
            }
            List<String> selectedNodeIds = this.querySelectedNodeIds(devNode);
            return ((List)settingConf.getParserList().stream().filter(setting -> StringUtils.equals((CharSequence)ResourceUtil.getString((String)"node.list"), (CharSequence)setting.getTitle())).map(SettingParserInfo::getNodesList).findFirst().orElse(new ArrayList())).stream().map(CollectNodeMapper.INSTANCE::toFlashCollectNode).filter(node -> this.filterNeedNodeByType(param, (FlashCollectNode)node)).peek(node -> this.selectedNode((FlashCollectNode)node, selectedNodeIds, param.getScene())).collect(Collectors.toList());
        }
        return new ArrayList<CollectNode>();
    }

    private List<String> querySelectedNodeIds(DevNode devNode) {
        CollectConfInfo collectConfInfo = CollectDataContext.getInstance().getCollectInfo(devNode).getCollectConfInfo();
        return ListUtils.union(collectConfInfo.getSelectedControllerNodeIds(), collectConfInfo.getSelectedExpansionModuleIds());
    }

    private void selectedNode(FlashCollectNode node, List<String> selectedNodes, ModeType scene) {
        if (selectedNodes.contains(node.getId())) {
            node.setSelected(true);
            return;
        }
        if (scene == ModeType.SIMPLE_COLLECT) {
            if (node.getType().equals(ResourceUtil.getString((String)"collect.node.type.controllers"))) {
                node.setSelected(true);
            }
            return;
        }
        if (selectedNodes.isEmpty()) {
            node.setSelected(true);
        }
    }

    @Override
    protected void beforeReturnQuerySettingResult(DevNode devNode, StorageItemSetting setting) {
        ICollectInfo collectInfo;
        setting.getModules().stream().map(CollectModuleResponse::getItems).flatMap(Collection::stream).forEach(item -> this.setItemSecondConfirm(devNode, (CollectItemResponse)item));
        StorageItemSetting flashSetting = FlashStorageItemSetting.builder().build();
        if (setting instanceof FlashStorageItemSetting) {
            flashSetting = (FlashStorageItemSetting)setting;
        }
        if ((collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode)) != null) {
            ((FlashStorageItemSetting)flashSetting).setCollectByNode(collectInfo.getCollectConfInfo().isCollectByNodes());
        }
    }

    private void setItemSecondConfirm(DevNode devNode, CollectItemResponse item) {
        item.setSecondConfirm(SecondConfirmFactory.get(item.getId()).createSecondConfirmService().querySecondConfirm(devNode));
    }

    @Override
    protected ICollectInfo buildCollectInfo(DevNode devNode, CollectItemSaveSetting setting) throws InfoCollectException {
        List<FlashCollectNode> selectedNodes = this.getSelectedCollectNodes(devNode, setting);
        CollectParam collectParam = ((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)FlashCollectParam.builder().devNode(devNode)).selectedScene(setting.getSelectedScene())).selectedItems(this.getSelectedCollectItems(devNode, setting))).isCollectByNode(setting.isCollectByNode())).selectedControllerIds(this.getSelectedControllerIds(selectedNodes))).selectedExpansionModuleIds(this.getSmartIds(selectedNodes))).build();
        CollectInfoBuilder builder = new CollectInfoBuilder(collectParam);
        IntegrateCollectInfo collectInfo = builder.buildScenarioBasedCollect();
        CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        return collectInfo;
    }

    private List<String> getSmartIds(List<FlashCollectNode> selectedNodes) {
        return selectedNodes.stream().filter(node -> "smart".equals(node.getType())).map(CollectNode::getId).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getSelectedControllerIds(List<FlashCollectNode> selectedNodes) {
        return selectedNodes.stream().filter(node -> "controller".equals(node.getType())).map(CollectNode::getId).collect(Collectors.toList());
    }

    @NotNull
    private List<CollectItem> getSelectedCollectItems(DevNode devNode, CollectItemSaveSetting setting) {
        CollectConf collectConf = this.bizPackageService.getCollectConf(devNode);
        List<CollectModule> specifiedModules = collectConf.getSpecifiedModules(setting.getSelectedScene());
        return specifiedModules.stream().map(CollectModule::getItems).flatMap(Collection::stream).filter(item -> setting.getSelectedItemIds().contains(item.getId())).collect(Collectors.toList());
    }

    private List<FlashCollectNode> getSelectedCollectNodes(DevNode devNode, CollectItemSaveSetting setting) {
        SettingConfInfo settingConf;
        ArrayList<FlashCollectNode> selectedNodes = new ArrayList<FlashCollectNode>();
        if ((InfoCollectUtil.isSupportCollectedByScene(devNode) || InfoCollectUtil.isNewOceanStor9000(devNode)) && (settingConf = this.bizPackageService.getSettingConf(devNode)) != null) {
            return this.getFlashCollectNodes(setting, settingConf);
        }
        return selectedNodes;
    }

    private List<FlashCollectNode> getFlashCollectNodes(CollectItemSaveSetting setting, SettingConfInfo settingConf) {
        return ((List)settingConf.getParserList().stream().filter(conf -> StringUtils.equals((CharSequence)ResourceUtil.getString((String)"node.list"), (CharSequence)conf.getTitle())).map(SettingParserInfo::getNodesList).findFirst().orElse(new ArrayList())).stream().map(CollectNodeMapper.INSTANCE::toFlashCollectNode).filter(node -> setting.getSelectedNodeIds().contains(node.getId())).collect(Collectors.toList());
    }

    @Override
    protected void verifySetting(DevNode devNode, CollectItemSaveSetting setting) throws InfoCollectException {
        super.verifySetting(devNode, setting);
        if (setting.getSelectedItemIds().contains(SecondConfirmFactory.DISK_RUNNING_LOG.getNeedConfirmItemId()) && InfoCollectCache.getInstance().querySelectedDisk(devNode.getDeviceSerialNumber()).isEmpty()) {
            throw new InfoCollectException("disk_run_log_must_select_disk");
        }
    }

    @Override
    protected void afterSaveItemSetting(DevNode devNode, ICollectInfo collectInfo, CollectItemSaveSetting setting) {
        this.handleSelectDisk(devNode, setting);
    }

    private void handleSelectDisk(DevNode devNode, CollectItemSaveSetting setting) {
        if (!setting.getSelectedItemIds().contains(SecondConfirmFactory.DISK_RUNNING_LOG.getNeedConfirmItemId())) {
            this.cleanSelectDisk(devNode);
            return;
        }
        this.saveSelectedDisk(devNode);
    }

    private void cleanSelectDisk(DevNode devNode) {
        log.info("No normal disk log item is selected.");
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        CollectDataContext.getInstance().clearDiskCheckStatus(diskTreeMap);
    }

    private void saveSelectedDisk(DevNode devNode) {
        List<String> selectedDiskId = InfoCollectCache.getInstance().querySelectedDisk(devNode.getDeviceSerialNumber());
        log.info("select disk id: {}", selectedDiskId);
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        List<DiskLocation> selectedLocation = diskTreeMap.keySet().stream().filter(diskLocation -> selectedDiskId.contains(diskLocation.getDiskId())).collect(Collectors.toList());
        CollectDataContext.getInstance().updateDevSelectedDiskCheckStatus(devNode, selectedLocation);
    }
}

