/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.task.domain.service;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.task.domain.entity.CollectProgress;
import com.huawei.ism.tool.infocollect.rest.task.domain.entity.CollectSingleProgress;
import com.huawei.ism.tool.infocollect.rest.task.domain.mapper.CollectProgressMapper;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.ITaskService;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.impl.DstorageCollectTaskService;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.impl.FlashCollectTaskService;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectTaskService {
    private static final Logger log = LoggerFactory.getLogger(CollectTaskService.class);
    private final List<ITaskService> taskServices = Arrays.asList(new DstorageCollectTaskService(), new FlashCollectTaskService());

    public void startCollectTask(List<DevNode> devNodes) throws InfoCollectException {
        if (devNodes.isEmpty()) {
            throw new InfoCollectException("infocollect.remind.selectnodevice");
        }
        this.checkSupportDevice(devNodes);
        this.isCollecting(devNodes);
        this.checkDiskSize();
        for (ITaskService taskService : this.taskServices) {
            taskService.verifyCollectSetting(devNodes);
        }
        this.startTask(devNodes);
    }

    private void checkSupportDevice(List<DevNode> devNodes) throws InfoCollectException {
        Optional<DevNode> optional = this.getUnsupportDevNode(devNodes);
        if (!optional.isPresent()) {
            return;
        }
        DevNode devNode = optional.get();
        if (devNode.isMiniSystem()) {
            throw new InfoCollectException("infocollect.devtype.minisystem");
        }
        throw new InfoCollectException("infocollect.remind.unsupportproduct", devNode.getDeviceType().toString() + " " + devNode.getProductVersion());
    }

    private void startTask(List<DevNode> devNodes) {
        InfoCollectService collectService = InfoCollectService.getInstance();
        for (DevNode devNode : devNodes) {
            log.info("{} start collect", (Object)devNode);
            collectService.startCollect(devNode);
        }
    }

    private void isCollecting(List<DevNode> devices) throws InfoCollectException {
        for (DevNode device : devices) {
            boolean isCollecting = InfoCollectService.getInstance().isMainDevNodeCollecting(device);
            if (!isCollecting) continue;
            throw new InfoCollectException("infocollect.remind.itemiscollecting");
        }
    }

    private Optional<DevNode> getUnsupportDevNode(List<DevNode> devices) {
        BizPackageService service = new BizPackageService();
        for (DevNode device : devices) {
            CollectConf conf = service.getCollectConf(device);
            if (conf != null) continue;
            return Optional.of(device);
        }
        return Optional.empty();
    }

    private boolean checkDiskSize() throws InfoCollectException {
        String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
        String userPath = infoCollectDir != null && !"".equals(infoCollectDir) ? infoCollectDir.toString() : String.join((CharSequence)File.separator, FileUtils.getDefaultDirectory().getAbsolutePath(), "infoCollect", "data", "collect");
        long freeSpace = this.getFreeSpace(userPath);
        if (freeSpace < 2L) {
            throw new InfoCollectException("infocollect.remind.checkdisksize");
        }
        return true;
    }

    private long getFreeSpace(String userPath) {
        File selectLocal = new File(userPath);
        return selectLocal.getFreeSpace() / 0x40000000L;
    }

    public CollectProgress queryTaskProgress(DevNode devNode) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo == null || collectInfo.getCollectStatus() == CollectStatus.NOT_COLLECT) {
            return CollectProgress.builder().status(CollectStatus.NOT_COLLECT).build();
        }
        return CollectProgress.builder().status(collectInfo.getCollectStatus()).progress(collectInfo.getCurrentProgress()).detail(this.queryCollectDetail(collectInfo)).build();
    }

    private List<CollectSingleProgress> queryCollectDetail(ICollectInfo collectInfo) {
        return collectInfo.getExecuteResults().stream().map(CollectProgressMapper.INSTANCE::toCollectSingleProgress).filter(progress -> !StringUtils.equals((CharSequence)progress.getDescription(), (CharSequence)ResourceUtil.getString((String)"infocollect.detail.collectover"))).collect(Collectors.toList());
    }
}

