/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.task.domain.service.impl;

import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.ITaskService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DstorageCollectTaskService
implements ITaskService {
    private static final Logger log = LoggerFactory.getLogger(DstorageCollectTaskService.class);
    private static final String IP_SEPARATE = ", ";
    private static final String DOWN_FILE_SUCCESS = "true";

    @Override
    public void verifyCollectSetting(List<DevNode> devNodes) throws InfoCollectException {
        List<DevNode> dsNodes = devNodes.stream().filter(DevNode::isDsStorage).collect(Collectors.toList());
        this.verifyCollectSettingComplete(dsNodes);
    }

    private void verifyCollectSettingComplete(List<DevNode> dsNodes) throws InfoCollectException {
        String notCompletedIps = dsNodes.stream().filter(devNode -> !this.isComplete((DevNode)devNode)).map(DevNode::getIp).collect(Collectors.joining(IP_SEPARATE));
        if (StringUtils.isNotBlank((CharSequence)notCompletedIps)) {
            throw new InfoCollectException("collect.task.param.not.set", notCompletedIps);
        }
    }

    private boolean isComplete(DevNode devNode) {
        ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(devNode);
        return collectInfo != null && collectInfo.getCollectConfInfo() != null && collectInfo.getCollectConfInfo().isCompleteParamSetting();
    }
}

