/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.rest.task.domain.service.impl;

import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.ITaskService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FlashCollectTaskService
implements ITaskService {
    private static final String IP_SEPARATE = ", ";

    @Override
    public void verifyCollectSetting(List<DevNode> devNodes) throws InfoCollectException {
        this.verifyIsCompleteSetting(devNodes);
    }

    private void verifyIsCompleteSetting(List<DevNode> devNodes) throws InfoCollectException {
        String unableCollectIps = devNodes.stream().filter(dev -> InfoCollectUtil.isSupportCollectedByScene(dev) || InfoCollectUtil.isNewOceanStor9000(dev)).filter(dev -> !this.hasBeenSet((DevNode)dev)).map(DevNode::getIp).collect(Collectors.joining(IP_SEPARATE));
        if (!StringUtils.isNULLStr((String)unableCollectIps)) {
            throw new InfoCollectException("collect.task.param.not.set", unableCollectIps);
        }
    }

    private boolean hasBeenSet(DevNode devNode) {
        return Optional.ofNullable(InfoCollectService.getInstance().getCollectInfoInstance(devNode)).map(ICollectInfo::getCollectConfInfo).map(CollectConfInfo::isCompleteStorageParamSetting).orElse(false);
    }
}

