/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BizPackageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizPackageService.class);
    public static final String PACKAGE_PRODUCTS_DIR = BizPackageService.getPackagePath();
    private static final Logger logger = LoggerFactory.getLogger(BizPackageService.class);
    private static final String EXTEND_SYSCONF_FILENAME = "ExtendSysconf.xml";
    private static final String XQL_QUERY_PRODUCTS = "/products/product";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VERSION = "version";

    private static String getPackagePath() {
        return CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath();
    }

    public static boolean importBizPackage4Dstorage(DevNode devNode, File bizPackageFile) {
        if (!bizPackageFile.getName().endsWith(".zip") || !devNode.isDsStorage()) {
            return false;
        }
        File unzipedFile = null;
        PackageConf packageConfig = null;
        try {
            String dStoragePkgFolder = "Dstorage_" + devNode.getDeviceSerialNumber();
            String targetPath = PACKAGE_PRODUCTS_DIR + File.separator + dStoragePkgFolder;
            FileUtils.deleteAllInFolder((String)targetPath);
            ZipUtils.decompressFile((File)bizPackageFile, (String)targetPath);
            InfoConfiguration infoConfig = InfoConfiguration.getInstance();
            unzipedFile = new File(targetPath);
            if (unzipedFile.exists()) {
                packageConfig = infoConfig.parseBizPackage(unzipedFile);
                if (null != packageConfig) {
                    packageConfig.setName(packageConfig.getName() + devNode.getDeviceSerialNumber());
                    packageConfig.setFolder(dStoragePkgFolder);
                    infoConfig.addParseBizPackage(packageConfig);
                    return true;
                }
                LOGGER.error("Import package failed.");
                return false;
            }
        }
        catch (Exception e) {
            logger.error("import package error", (Throwable)e);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadExtendSysconf() {
        String path = ApplicationContext.getInstance().getWorkPath();
        String productsPath = BizPackageService.getProductPath();
        File productsFolder = new File(path, productsPath + File.separator + EXTEND_SYSCONF_FILENAME);
        Document doc = null;
        InputStream inputStream = null;
        try {
            inputStream = StreamUtils.createInputStream((File)productsFolder);
            doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("load Sysconf error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (null == doc) {
            logger.error("load Sysconf error.");
            return null;
        }
        HashMap<String, String> versionList = new HashMap<String, String>();
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_PRODUCTS);
        if (null == nodeList || nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element product = (Element)node;
            String name = XmlUtils.getAttribute((Element)product, (String)ATTR_NAME);
            String version = XmlUtils.getAttribute((Element)product, (String)ATTR_VERSION);
            if (StringUtils.isNULLStr((String)name) || StringUtils.isNULLStr((String)version)) continue;
            if (version.contains("+")) {
                version = version.replace("+", ResourceUtil.getString((String)"infocollect.selectdevice.later"));
            }
            versionList.put(name, version);
        }
        return versionList;
    }

    private static String getProductPath() {
        return String.join((CharSequence)File.separator, "packages", "collect", "products");
    }

    public Set<SupportVersionConf> getSupportVersionConfs() {
        Set<PackageConf> packageConfs = InfoConfiguration.getInstance().getPackageConfs();
        HashSet<SupportVersionConf> results = new HashSet<SupportVersionConf>();
        for (PackageConf packageConf : packageConfs) {
            results.addAll(packageConf.getVersionConfigs());
        }
        return results;
    }

    public Set<String> getExcludeProductsWitchVersion() {
        Set<PackageConf> packageConfs = InfoConfiguration.getInstance().getPackageConfs();
        HashSet<String> results = new HashSet<String>();
        for (PackageConf packageConf : packageConfs) {
            results.addAll(packageConf.getExcludeProductsVersion());
        }
        return results;
    }

    public Set<String> getSupportProductsWitchVersion() {
        Set<PackageConf> packageConfs = InfoConfiguration.getInstance().getPackageConfs();
        HashSet<String> results = new HashSet<String>();
        for (PackageConf packageConf : packageConfs) {
            results.addAll(packageConf.getSupportProductsVersion());
        }
        return results;
    }

    public CollectConf getCollectConf(DevNode devnode) {
        return InfoConfiguration.getInstance().getCollectConf(devnode);
    }

    public boolean isNeedDebug(DevNode devnode) {
        CollectConf conf = this.getCollectConf(devnode);
        if (conf == null) {
            return false;
        }
        return conf.getDebugMode().isEnableDebug() && StringUtils.isNULLStr((String)devnode.getDeveloperPwd());
    }

    public boolean isExistCollection(DevNode devnode, DevNode childNode) {
        ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(devnode);
        if (null == collectInfo) {
            throw new NullPointerException();
        }
        Collection<CollectInfo> collectInfoes = collectInfo.getCollectInfoes().values();
        for (CollectInfo curent : collectInfoes) {
            if (null == curent || !curent.getDevNode().equals((Object)childNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAdvancedOptions(DevNode devnode) {
        return InfoConfiguration.getInstance().hasAdvancedOptions(devnode);
    }

    public SettingConfInfo getSettingConf(DevNode devnode) {
        return InfoConfiguration.getInstance().getSettingConf(devnode);
    }

    public Map<DevNode, String> getNeedDebugDevNode(List<DevNode> devNodes, DevNode deviceNode) {
        HashMap<DevNode, String> debugPwds = new HashMap<DevNode, String>();
        for (DevNode currentDev : devNodes) {
            CollectConf conf = this.getCollectConf(currentDev);
            if (conf == null || !conf.getDebugMode().isEnableDebug()) continue;
            String debugPwd = deviceNode.getDeveloperPwd();
            String cDebugPwd = currentDev.getDeveloperPwd();
            currentDev.setDeveloperPwd(debugPwd);
            debugPwds.put(currentDev, cDebugPwd);
        }
        return debugPwds;
    }
}

