/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ftdsanalysis.analysis.iorecord.util.StringUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.util.ApplyRange;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.rest.query.NodePoolService;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONArray;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public final class CollectDeviceService {
    private static final Logger log = LoggerFactory.getLogger(CollectDeviceService.class);
    private static final CollectDeviceService INSTANCE = new CollectDeviceService();
    private static NodePoolService nodeService = new NodePoolService();
    private static final String ERROR_CODE = "errorCode";
    private static final String OPCODE = "opcode";
    private static final int INTLOGTYPE = 7;
    private static List<String> deviceHasDownResFile = Collections.synchronizedList(new ArrayList());
    private static List<String> deviceHasDownInspectResFile = Collections.synchronizedList(new ArrayList());

    private CollectDeviceService() {
    }

    public static CollectDeviceService getInstance() {
        return INSTANCE;
    }

    public static List<String> getDeviceHasDownResFile() {
        return deviceHasDownResFile;
    }

    public List<DevNode> getAllDevNode() {
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (InfoCollectUtil.isSupportA800Scene()) {
            log.info("current scene is A800 infoCollect");
            return this.getA800DevNodes(devs);
        }
        return devs;
    }

    List<DevNode> getA800DevNodes(List<DevNode> devs) {
        List<AiDevNode> aiDevNodes = CollectDeviceService.getAiDevNodes(devs);
        List<DmeNode> zoneNodes = this.getZoneNodes(aiDevNodes);
        List<DmeNode> omNodes = this.getOmNodes(aiDevNodes);
        return Stream.concat(zoneNodes.stream(), omNodes.stream()).collect(Collectors.toList());
    }

    private static List<AiDevNode> getAiDevNodes(List<DevNode> devs) {
        return devs.stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).collect(Collectors.toList());
    }

    private List<DmeNode> getOmNodes(List<AiDevNode> aiDevNodes) {
        List omNodes = aiDevNodes.stream().flatMap(dev -> dev.getOmNodes().stream()).filter(DmeNode::isSelect).filter(dev -> this.nonNullUser(dev.getLoginUser())).collect(Collectors.toList());
        if (Utils.isNullList(omNodes)) {
            return Collections.emptyList();
        }
        CollectDataContext.getInstance().setDataTurboNodeNumber(omNodes.size());
        return Collections.singletonList(omNodes.get(0));
    }

    private List<DmeNode> getZoneNodes(List<AiDevNode> aiDevNodes) {
        return aiDevNodes.stream().flatMap(dev -> dev.getA800Nodes().stream()).filter(DmeNode::isSelect).flatMap(node -> node.getZones().stream()).filter(dev -> this.nonNullUser(dev.getLoginUser())).collect(Collectors.toList());
    }

    private boolean nonNullUser(User user) {
        return Objects.nonNull(user) && !StringUtils.hasNULLStr((String[])new String[]{user.getUserName(), user.getPassword()});
    }

    public void putIntegratedDebug(List<DevNode> integratedNodes) {
        List devices = DeviceContext.getInstance().getModifyDevicesInfo();
        for (DevNode curNode : devices) {
            int index = integratedNodes.indexOf(curNode);
            if (-1 == index) continue;
            integratedNodes.get(index).setDeveloperPwd(curNode.getDeveloperPwd());
        }
    }

    public String getIntegrateScriptPath(DevNode devNode) {
        return InfoConfiguration.getInstance().getIntegrateScriptPath(devNode);
    }

    public List<DevNode> getIntegratedNodes(DevNode node) {
        ArrayList<DevNode> devices = new ArrayList<DevNode>();
        devices.add(node);
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(node);
        if (collectInfo == null) {
            return devices;
        }
        Set<DevNode> devNodes = collectInfo.getCollectInfoes().keySet();
        for (DevNode devNode : devNodes) {
            if (devNode.equals((Object)node)) continue;
            devices.add(devNode);
        }
        return devices;
    }

    public String getDateScriptPath(DevNode device) {
        return InfoConfiguration.getInstance().getDateScriptPath(device);
    }

    public ApplyRange getDevNodeApplyRange(DevNode devNode) {
        InfoConfiguration infoConfiguration = InfoConfiguration.getInstance();
        CollectConf conf = infoConfiguration.getCollectConf(devNode);
        if (conf == null) {
            log.info("getCollectConf return null");
            return null;
        }
        return conf.getApplyRange();
    }

    public boolean checkDevStatusIfHasRunningTask(DevNode devNode) {
        ResponseInfo resp = this.queryAllTasks(devNode);
        return this.analyzeQueryTasksData(resp);
    }

    private boolean analyzeQueryTasksData(ResponseInfo resp) {
        if (resp == null) {
            return true;
        }
        Map restContentMap = resp.getContentMap();
        Long errorCode = null;
        if (restContentMap.get(ERROR_CODE) instanceof Long) {
            errorCode = (Long)restContentMap.get(ERROR_CODE);
        }
        if (null != errorCode && 0L != errorCode) {
            log.error("Query all tasks failed, error code: {}", (Object)errorCode);
            return true;
        }
        JSONArray data = null;
        if (restContentMap.get("data") instanceof JSONArray) {
            data = (JSONArray)restContentMap.get("data");
        }
        if (data == null) {
            return true;
        }
        if (data.length() != 0) {
            for (int i = 0; i < data.length(); ++i) {
                if (data.getJSONObject(i).getInt(OPCODE) != 7) continue;
                log.info("device has tasks already, add task now may lead to wait long");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInfo queryAllTasks(DevNode devNode) {
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String getResourceFilesUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)devNode, (String)"").replaceFirst("/$", "");
            if (conn != null) {
                resp = conn.execGet(getResourceFilesUri);
            }
            ResponseInfo responseInfo = resp;
            return responseInfo;
        }
        catch (Throwable e) {
            log.error("Query all tasks exception", e);
            ResponseInfo responseInfo = null;
            return responseInfo;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private void clearTemp(String temp) {
        File file = new File(temp);
        FilesUtil.clearFolder((File)file);
        if (!file.delete()) {
            log.info("file delete error:{}", (Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResourceFileAndImportAsPackage(DevNode devNode) {
        if (devNode.isFusionCube()) {
            log.info("FusionCube device :{} do not download", (Object)devNode.getIp());
            return true;
        }
        String temp = ApplicationContext.getInstance().getWorkPath() + File.separator + "temp" + File.separator + "Dstorage" + File.separator + devNode.getDeviceSerialNumber();
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String getResourceFilesUri = RestUtil.getResourceUri((DevNode)devNode);
            HashMap<String, String> reqParam = new HashMap<String, String>();
            reqParam.put("resource_type", "collection");
            resp = conn.execGetFile(getResourceFilesUri, reqParam, temp);
        }
        catch (Throwable e) {
            log.error("Download info collect resource file exception:", e);
            boolean reqParam = false;
            return reqParam;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        Map restContentMap = resp.getContentMap();
        Long errorCode = (Long)restContentMap.get(ERROR_CODE);
        if (null != errorCode && 0L != errorCode) {
            log.error("Get info collect resource file failed, error code:" + errorCode);
            return false;
        }
        Iterator entryItr = restContentMap.entrySet().iterator();
        String resourceZipFileName = null;
        while (entryItr.hasNext()) {
            Map.Entry contentEntry = entryItr.next();
            String key = (String)contentEntry.getKey();
            if (null == key || !key.contains(".zip")) continue;
            resourceZipFileName = key;
        }
        log.info("resourceZipFileName={}", resourceZipFileName);
        if (null != resourceZipFileName) {
            if (BizPackageService.importBizPackage4Dstorage(devNode, new File(resourceZipFileName))) {
                deviceHasDownResFile.add(devNode.getDeviceSerialNumber());
                log.info("import dstorage package success.");
                this.clearTemp(temp);
                return true;
            }
            log.error("import dstorage package failed.");
        }
        this.clearTemp(temp);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInspectResourceFile(DevNode devNode) {
        if (deviceHasDownInspectResFile.contains(devNode.getDeviceSerialNumber())) {
            return true;
        }
        String temp = Stream.of(ApplicationContext.getInstance().getWorkPath(), "temp", "Dstorage", devNode.getDeviceSerialNumber(), "inspectResource").collect(Collectors.joining(File.separator));
        ResponseInfo resp = null;
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String getResourceFilesUri = RestUtil.getResourceUri((DevNode)devNode);
            HashMap<String, String> reqParam = new HashMap<String, String>();
            reqParam.put("resource_type", "inspection");
            resp = conn.execGetFile(getResourceFilesUri, reqParam, temp);
        }
        catch (ToolException e) {
            log.error("Download info inspect resource file exception:", (Throwable)e);
            boolean getResourceFilesUri = false;
            return getResourceFilesUri;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        Map restContentMap = resp.getContentMap();
        int errorCode = Integer.parseInt(restContentMap.getOrDefault(ERROR_CODE, "0").toString());
        if (errorCode != 0) {
            log.error("Get info inspect resource file failed, error code:" + errorCode);
            return false;
        }
        String resourceZipFileName = restContentMap.keySet().stream().filter(key -> key != null && key.contains(".zip")).findFirst().orElse(null);
        log.info("resourceZipFileName={}", (Object)resourceZipFileName);
        if (resourceZipFileName != null) {
            if (this.checkProductIniExist(devNode, new File(resourceZipFileName))) {
                deviceHasDownInspectResFile.add(devNode.getDeviceSerialNumber());
                log.info("download dstorage inspect resource file success.");
                this.clearTemp(temp);
                return true;
            }
            log.error("download dstorage inspect resource file failed.");
        }
        this.clearTemp(temp);
        return false;
    }

    private boolean checkProductIniExist(DevNode devNode, File bizPackageFile) {
        if (!bizPackageFile.getName().endsWith(".zip") || !devNode.isDsStorage()) {
            return false;
        }
        String dStoragePkgFolder = "Dstorage_" + devNode.getDeviceSerialNumber();
        String targetPath = Stream.of(CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath(), dStoragePkgFolder, "inspectResource").collect(Collectors.joining(File.separator));
        FileUtils.deleteAllInFolder((String)targetPath);
        try {
            ZipUtils.decompressFile((File)bizPackageFile, (String)targetPath);
        }
        catch (IOException e) {
            log.info("decompressFile failed.");
        }
        String packageIniFilename = targetPath + File.separator + "package.ini";
        File packageIniFile = new File(packageIniFilename);
        if (!packageIniFile.exists()) {
            log.info("The file : package.ini is not exists.");
            return false;
        }
        return true;
    }

    public boolean queryDstorageClusterNodes(DevNode devNode) {
        if (!devNode.isDsStorage() || devNode.getClusterNodes() != null && !devNode.getClusterNodes().isEmpty() && this.hasStoragePoolInfo(devNode)) {
            return true;
        }
        List nodes = devNode.getClusterNodes();
        if (nodes == null || nodes.isEmpty() || !this.hasStoragePoolInfo(devNode)) {
            TaskResult taskResult;
            if (devNode.isFusionCube()) {
                FusionCubeInfoQryServiceImpl fusionCubeInfoQryService = new FusionCubeInfoQryServiceImpl();
                taskResult = fusionCubeInfoQryService.queryNodeInfo(devNode, DeviceOpr.ADD);
            } else {
                DSstorageInfoQryServiceImpl restQueryService = new DSstorageInfoQryServiceImpl();
                taskResult = restQueryService.queryNodeInfo(devNode, DeviceOpr.ADD, null);
                CollectDeviceService.initStorgePoolInfo(devNode);
            }
            if (taskResult.getResult() != TaskResult.Result.SUCCESS) {
                log.error("Query cluster nodes failed.");
                return false;
            }
        }
        CollectDeviceService.initDefaultSelectNode(devNode);
        return true;
    }

    public boolean hasStoragePoolInfo(DevNode devNode) {
        return devNode.getClusterNodes().stream().anyMatch(clusterNode -> Objects.nonNull(clusterNode.getJoinedStoragePool()));
    }

    public static void initStorgePoolInfo(DevNode devNode) {
        HashMap storgePoolInfo = new HashMap();
        try {
            for (FusionStorStoragePool joinedStoragePool : nodeService.queryNodePool(devNode)) {
                CollectDeviceService.queryStoragePoolByPoolId(joinedStoragePool.getId(), devNode).forEach(nodeMgrIp -> storgePoolInfo.put(nodeMgrIp, joinedStoragePool));
            }
        }
        catch (ToolException e) {
            log.error("Query storage pool info failed", (Throwable)e);
        }
        devNode.getClusterNodes().forEach(clusterNode -> clusterNode.setJoinedStoragePool(storgePoolInfo.getOrDefault(clusterNode.getManagementIp(), new FusionStorStoragePool())));
    }

    public static List<String> queryStoragePoolByPoolId(String poolId, DevNode devNode) throws ToolException {
        if (StringUtil.isEmpty((String)poolId)) {
            return Collections.emptyList();
        }
        String nodeInfos = nodeService.getNodeDiskInfo(poolId, devNode, false);
        if (StringUtil.isEmpty((String)nodeInfos)) {
            return Collections.emptyList();
        }
        JSONArray nodeInfoList = new JSONArray(nodeInfos);
        return IntStream.range(0, nodeInfoList.length()).mapToObj(arg_0 -> ((JSONArray)nodeInfoList).getJSONObject(arg_0)).filter(jsonObject -> jsonObject.has("nodeMgrIp")).map(jsonObject -> jsonObject.getStringOrDefault("nodeMgrIp", "")).collect(Collectors.toList());
    }

    public static void initDefaultSelectNode(DevNode devNode) {
        if (devNode == null || !devNode.isDsStorage()) {
            return;
        }
        List nodes = devNode.getClusterNodes();
        if (nodes != null) {
            nodes.forEach(node -> node.setSelected(false));
            nodes.forEach(node -> node.setSelected(node.includedStorageService() || node.includeManagementRole()));
        }
    }

    public static void setNodeService(NodePoolService nodeService) {
        CollectDeviceService.nodeService = nodeService;
    }
}

