/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.common.bean.DeviceTypeIsm;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.HisTLVConnectionImpl;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.infocollect.service.HisUIObserver;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.util.StringUtils;
import com.huawei.sftp.AbstractSftp;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import com.huawei.xve.MainDialog;
import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.entity.TaskDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.ExportTaskFactory;
import com.huawei.xve.server.IExportTask;
import com.huawei.xve.server.IUIObserver;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.QuerInfo;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectHistoryPerformanceManager {
    private static final Logger log = LoggerFactory.getLogger(CollectHistoryPerformanceManager.class);
    private DevNode devNode;
    private String deviceId;
    private DeviceInfo deviceInfo;
    private String exportPath;
    private String taskResult;
    private String errMsg = "";
    private HisUIObserver obs;
    private UIProgressObserver progressObserver;
    private final String querySystemCmdTv1 = "showsys";
    private final String configPath = "config.hisPerfStat.common";
    private final Pattern timeFormatPattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}");

    public CollectHistoryPerformanceManager(DevNode devNode, String exportPath, UIProgressObserver progressObserver) {
        this.devNode = devNode;
        this.exportPath = exportPath;
        this.deviceId = devNode.getDeviceSerialNumber();
        this.progressObserver = progressObserver;
    }

    private void initEnv() {
        ConnectionManager.getInstance().registerConnectionClass(DeviceTypeIsm.C3.name(), HisTLVConnectionImpl.class);
        HisResourceManager.init();
        HisResourceManager.registerPropertyFile((String)"config.hisPerfStat.common", (ClassLoader)MainDialog.class.getClassLoader());
        this.initDevInfo(this.devNode);
        this.deviceInfo = ConnManager.getDeviceInfo((String)this.deviceId);
        this.initExportParam();
    }

    public Object doCollect() {
        this.initEnv();
        this.obs = new HisUIObserver(this.progressObserver);
        TaskEnv env = TaskEnv.builder().deviceInfo(this.deviceInfo).param(this.deviceInfo.getExportParam()).obs((IUIObserver)this.obs).build();
        IExportTask task = ExportTaskFactory.INS.getPerfExportTask(env);
        task.init();
        TaskDetail taskDetail = (TaskDetail)task.doExport();
        this.setTaskResult(taskDetail);
        return true;
    }

    private void setTaskResult(TaskDetail taskDetail) {
        this.taskResult = taskDetail.getStatus().toString();
        this.errMsg = taskDetail.getErrMsg() == null || "--".equals(taskDetail.getErrMsg()) ? this.errMsg : taskDetail.getErrMsg();
        log.info("task result:{}, msg: {}", (Object)this.taskResult, (Object)this.errMsg);
    }

    private void initExportParam() {
        long endTime = this.deviceInfo.getDeviceVersion().toString().startsWith("V100") ? this.getEndTimeTv1(this.deviceInfo) : this.getEndTime(this.deviceInfo);
        long startTime = endTime - 86400000L;
        ExportParam param = new ExportParam();
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setCompress(true);
        param.setResultDir(this.exportPath);
        this.deviceInfo.setExportParam(param);
        log.info("Dev {} export by default setting : {}", (Object)this.deviceInfo.getIp(), (Object)param);
    }

    private long getEndTime(DeviceInfo di) {
        long endTime;
        try {
            endTime = QuerInfo.querTime((DeviceInfo)di);
        }
        catch (IsmException e) {
            log.error("Failed to query the device time. Use the current system time to collect historical performance files.", (Throwable)e);
            endTime = System.currentTimeMillis();
        }
        return endTime;
    }

    private long getEndTimeTv1(DeviceInfo di) {
        long endTime;
        String result = QuerInfo.exCliBySSH((DeviceInfo)di, (String)"showsys");
        String[] lineList = result.split("\r\n");
        String matchTimeStr = "";
        for (String line : lineList) {
            Matcher matcher;
            if (!line.contains("Time") || !(matcher = this.timeFormatPattern.matcher(line)).find()) continue;
            matchTimeStr = matcher.group();
            break;
        }
        if (StringUtils.isNULLStr((String)matchTimeStr)) {
            return System.currentTimeMillis();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(matchTimeStr);
            endTime = date.getTime();
        }
        catch (ParseException e) {
            log.error("Time conversion format failed,use system time IP is:" + di.getIp(), (Throwable)e);
            endTime = System.currentTimeMillis();
        }
        return endTime;
    }

    private void initDevInfo(DevNode devNode) {
        DeviceInfo info = new DeviceInfo();
        info.setDevNode(devNode);
        String deviceID = devNode.getDeviceSerialNumber();
        String deviceName = devNode.getDeviceName();
        String userName = devNode.getLoginUser().getUserName();
        String pwd = devNode.getLoginUser().getPassword();
        String deviceVersion = devNode.getProductVersion();
        int devicePort = devNode.getPort();
        List innerIPs = devNode.getIpList();
        String deviceIP = devNode.getIp();
        if (CollectHistoryPerformanceManager.isEmpty(deviceIP) || CollectHistoryPerformanceManager.isEmpty(deviceID)) {
            log.error("initDevInfo failed. The deviceInfo is null or empty.");
            return;
        }
        info.setDeviceName("(" + deviceIP + ")" + deviceName);
        if (LocalHostUtil.isRunInSvp() && innerIPs != null && !innerIPs.isEmpty()) {
            deviceIP = CollectHistoryPerformanceManager.getCtlIp(innerIPs, devicePort);
            if ("V300R003C20".equals(deviceVersion)) {
                deviceVersion = deviceVersion + "SPC100";
            }
        }
        String devType = devNode.getDeviceType().toString();
        info.setDeviceVersion(DeviceVersion.getDeviceVersion((String)deviceVersion, (String)devType));
        info.setIp(deviceIP);
        log.info("The deviceID: {}, devType:{}", (Object)deviceID, (Object)devType);
        UserBehaviorUtil.initUserOpData((DeviceInfo)info);
        ConnManager.setDeviceInfo((DeviceInfo)info);
    }

    private static String getCtlIp(List<String> innerIP, int port) {
        String string;
        String ip = "";
        Iterator<String> var3 = innerIP.iterator();
        do {
            if (!var3.hasNext()) {
                if ("".equals(ip)) {
                    log.error("no inner ip can use.");
                    throw new IsmException("no inner ip can use.");
                }
                return ip;
            }
            ip = string = var3.next();
        } while (!AbstractSftp.isSftpCanConnected((String)string, (int)port, (int)1));
        return string;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public String getTaskResult() {
        return this.taskResult;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public HisUIObserver getObs() {
        return this.obs;
    }
}

