/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.infocollect.interf.DealFileHandler;
import com.huawei.ism.tool.infocollect.service.TmpDetail;
import com.huawei.ism.tool.infocollect.util.DefaultDealHandler;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class DealFileInCopressPackage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DealFileInCopressPackage.class);
    private String fileSuffix = System.currentTimeMillis() + "";
    private DealFileHandler handler;
    private String sevenzPath = FileAssistant.get7zPath();
    private String[] specialFileName;

    public DealFileInCopressPackage(DealFileHandler handler) {
        this.handler = handler;
    }

    public static void anonymizeCompressInFolder(String filePath, String ... fileNames) {
        DealFileInCopressPackage deal = new DealFileInCopressPackage(new DefaultDealHandler());
        deal.specialFileName = fileNames;
        LOGGER.info("anonymize specialFileName:{}", (Object)Arrays.toString(fileNames));
        deal.anonymizeSpecialFile(filePath);
    }

    private void dealFolder(File file) {
        LOGGER.info("start deal folder:{}", (Object)FilesUtil.getCanonicalPath((File)file));
        File[] listFiles = file.listFiles();
        if (listFiles != null && listFiles.length > 0) {
            for (File controllerTgz : listFiles) {
                this.dealFile(controllerTgz);
            }
        }
        LOGGER.info("finish deal folder:{}", (Object)FilesUtil.getCanonicalPath((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCompressType(File file) throws IOException {
        int readCount;
        byte[] data = new byte[16];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            readCount = ((InputStream)inputStream).read(data);
        }
        finally {
            this.closeStream(inputStream);
        }
        if (readCount < 5) {
            return null;
        }
        if (data[0] == 31 && data[1] == -117 && data[2] == 8 && data[3] == 0) {
            return "tar.gz";
        }
        if (data[0] == 66 && data[1] == 90 && data[2] == 104) {
            return "tar.bz2";
        }
        if (data[0] == 80 && data[1] == 75 && data[2] == 3 && data[3] == 4) {
            return "zip";
        }
        if (file.getName().endsWith("tar")) {
            return "tar";
        }
        return null;
    }

    private boolean compressAndDelete(TmpDetail tmpDetail) {
        switch (tmpDetail.getFileType()) {
            case "zip": {
                return this.compressAndDeleteZip(tmpDetail);
            }
            case "tar.gz": {
                return this.compressAndDeleteTarGz(tmpDetail);
            }
            case "tar.bz2": {
                return this.compressAndDeleteTarBz2(tmpDetail);
            }
        }
        this.deleteFolder(tmpDetail.getTmpFolder());
        return false;
    }

    private boolean compressAndDeleteZip(TmpDetail tmpDetail) {
        try {
            OSCmdUtils.executeCmd((String)("\"" + this.sevenzPath + "\" a -tzip \"" + tmpDetail.getTmpFolder().substring(0, tmpDetail.getTmpFolder().lastIndexOf(this.fileSuffix)) + "\" \"" + tmpDetail.getTmpFolder() + File.separator + "*\" -aoa"), (int)600);
            boolean bl = true;
            return bl;
        }
        finally {
            this.deleteFolder(tmpDetail.getTmpFolder());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compressAndDeleteTarGz(TmpDetail tmpDetail) {
        String tarPath = tmpDetail.getTmpFolder().substring(0, tmpDetail.getTmpFolder().lastIndexOf(this.fileSuffix));
        String mainTmpPath = new File(tarPath).getParent();
        String mainPath = mainTmpPath.substring(0, mainTmpPath.lastIndexOf(this.fileSuffix));
        try {
            OSCmdUtils.executeCmd((String)("\"" + this.sevenzPath + "\" a -ttar \"" + tarPath + "\" \"" + tmpDetail.getTmpFolder() + File.separator + "*\" -aoa"), (int)600);
            this.deleteFolder(tmpDetail.getTmpFolder());
            OSCmdUtils.executeCmd((String)("\"" + this.sevenzPath + "\" a -tgzip \"" + mainPath + "\" \"" + mainTmpPath + File.separator + "*\" -aoa"), (int)600);
            boolean bl = true;
            return bl;
        }
        finally {
            this.deleteFolder(mainTmpPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compressAndDeleteTarBz2(TmpDetail tmpDetail) {
        String tarPath = tmpDetail.getTmpFolder().substring(0, tmpDetail.getTmpFolder().lastIndexOf(this.fileSuffix));
        String mainTmpPath = new File(tarPath).getParent();
        String mainPath = mainTmpPath.substring(0, mainTmpPath.lastIndexOf(this.fileSuffix));
        try {
            OSCmdUtils.executeCmd((String)("\"" + this.sevenzPath + "\" a -ttar \"" + tarPath + "\" \"" + tmpDetail.getTmpFolder() + File.separator + "*\" -aoa"), (int)600);
            this.deleteFolder(tmpDetail.getTmpFolder());
            OSCmdUtils.executeCmd((String)("\"" + this.sevenzPath + "\" a -tbzip2 \"" + mainPath + "\" \"" + mainTmpPath + File.separator + "*\" -aoa"), (int)600);
            boolean bl = true;
            return bl;
        }
        finally {
            this.deleteFolder(mainTmpPath);
        }
    }

    public static void anonymizeCompressFile(String filePath) {
        DealFileInCopressPackage deal = new DealFileInCopressPackage(new DefaultDealHandler());
        File file = new File(filePath);
        if (file.isFile()) {
            deal.dealFile(file);
        } else if (file.isDirectory()) {
            deal.dealFolder(file);
        }
    }

    public static void anonymizeTV2(String filePath) {
        DealFileInCopressPackage.anonymizeCompressInFolder(filePath, "Config.txt", "config", "config.tgz", "config.tar.gz", "config.tar.bz2", "clicmd.txt");
    }

    private TmpDetail decompressTarGzorBz2(File file, String mark, String fileType) {
        boolean condition;
        String tarParent = this.decompress(file, "x", null);
        if (tarParent == null) {
            return null;
        }
        File[] tarList = new File(tarParent).listFiles();
        boolean bl = condition = tarList != null && tarList.length > 0;
        if (condition) {
            File tar = tarList[0];
            String type = mark == null ? "x" : "e";
            String tarTmp = this.decompress(tar, type, mark);
            return this.getDetailInfo(tarTmp, tarParent, fileType);
        }
        return null;
    }

    private TmpDetail getDetailInfo(String tarTmp, String tarParent, String fileType) {
        if (tarTmp == null) {
            this.deleteFolder(tarParent);
            return null;
        }
        return new TmpDetail(tarTmp, fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealFile(File file) {
        LOGGER.info("start deal file:{}", (Object)FilesUtil.getCanonicalPath((File)file));
        try {
            TmpDetail controllerDetail = this.decompress(file, null);
            File[] listFiles = this.getFiles(controllerDetail);
            if (listFiles == null) {
                return;
            }
            for (File controllerInner : listFiles) {
                TmpDetail controllerInnerDetail;
                if (!controllerInner.getName().toLowerCase(Locale.US).startsWith("log_controller") || (controllerInnerDetail = this.decompress(controllerInner, "config")) == null) continue;
                File configCompressOld = new File(controllerInnerDetail.getTmpFolder() + File.separator + "config.tgz");
                File configCompress = new File(controllerInnerDetail.getTmpFolder() + File.separator + "config" + File.separator + "config.tgz");
                if (!new File(controllerInnerDetail.getTmpFolder() + File.separator + "config").isDirectory() || !configCompressOld.isFile()) {
                    this.deleteFolder(controllerDetail.getTmpFolder());
                    return;
                }
                if (!configCompressOld.renameTo(configCompress)) {
                    this.deleteFolder(controllerDetail.getTmpFolder());
                    return;
                }
                TmpDetail configDetail = this.decompress(configCompress, null);
                if (configDetail == null) continue;
                LOGGER.info("find config txt file");
                File[] configTxtList = new File(configDetail.getTmpFolder()).listFiles();
                if (configTxtList != null && configTxtList.length > 0) {
                    for (File configTxt : configTxtList) {
                        this.handler.handle(configTxt);
                    }
                }
                this.compressAndDelete(configDetail);
                this.compressAndDelete(controllerInnerDetail);
            }
            this.compressAndDelete(controllerDetail);
        }
        catch (Exception e) {
            LOGGER.error("appear exception when deal file:" + FilesUtil.getCanonicalPath((File)file), (Throwable)e);
        }
        finally {
            this.deleteFolder(file.getAbsoluteFile() + this.fileSuffix);
        }
    }

    private File[] getFiles(TmpDetail controllerDetail) {
        if (controllerDetail == null) {
            return null;
        }
        File[] listFiles = new File(controllerDetail.getTmpFolder()).listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return null;
        }
        return listFiles;
    }

    private void deleteFolder(File file) {
        if (file.isFile() && !file.delete()) {
            LOGGER.error("apear exception when delete file: " + file);
        } else if (file.isDirectory()) {
            this.deleteRealFolder(file);
        }
    }

    private void deleteRealFolder(File folder) {
        File[] subFileList = folder.listFiles();
        if (subFileList != null) {
            for (File subFile : subFileList) {
                this.deleteFolder(subFile);
            }
            if (!folder.delete()) {
                LOGGER.error("apear exception when delete file: " + folder);
            }
        }
    }

    public static void anonymizeCompressInFolder(String filePath, String fileName) {
        DealFileInCopressPackage.anonymizeCompressInFolder(filePath, new String[]{fileName});
    }

    private boolean anonymizeSpecialFile(File file) {
        block3: {
            File[] fileList;
            block2: {
                if (!file.isFile()) break block2;
                for (String fileName : this.specialFileName) {
                    if (!file.getName().equalsIgnoreCase(fileName)) continue;
                    this.dealSingleFileOrCompress(file);
                }
                break block3;
            }
            if (!file.isDirectory() || (fileList = file.listFiles()) == null || fileList.length <= 0) break block3;
            for (File subFile : fileList) {
                this.anonymizeSpecialFile(subFile);
            }
        }
        return true;
    }

    public void deleteFolder(String filePath) {
        this.deleteFolder(new File(filePath));
    }

    public String decompress(File file, String decompressType, String decompressArg) {
        try {
            StringBuilder sb = new StringBuilder("\"" + this.sevenzPath);
            sb.append("\" ").append(decompressType).append(" \"").append(file.getCanonicalPath()).append("\" -o\"").append(file.getCanonicalPath()).append(this.fileSuffix).append('\"');
            if (decompressArg != null) {
                sb.append(' ').append(decompressArg);
            }
            sb.append(" -aoa");
            OSCmdUtils.executeCmd((String)sb.toString(), (int)600);
            return file.getCanonicalPath() + this.fileSuffix;
        }
        catch (Exception e) {
            LOGGER.error("appear exception when decompress file: " + file, (Throwable)e);
            try {
                this.deleteFolder(file.getCanonicalPath() + this.fileSuffix);
            }
            catch (IOException e2) {
                LOGGER.error("get path error.", (Throwable)e2);
            }
            return null;
        }
    }

    public TmpDetail decompress(File file, String mark) throws IOException {
        String fileType;
        switch (fileType = this.getCompressType(file)) {
            case "tar.gz": 
            case "tar.bz2": {
                return this.decompressTarGzorBz2(file, mark, fileType);
            }
            case "zip": {
                String type = mark == null ? "x" : "e";
                String zipTmp = this.decompress(file, type, mark);
                if (zipTmp == null) {
                    return null;
                }
                return new TmpDetail(zipTmp, fileType);
            }
        }
        return null;
    }

    public boolean anonymizeSpecialFile(String filePath) {
        LOGGER.info("anonymize file path:{}", (Object)filePath);
        return this.anonymizeSpecialFile(new File(filePath));
    }

    private void dealSingleFileOrCompress(File file) {
        try {
            String fileType = this.getCompressType(file);
            if (fileType == null) {
                this.handler.handle(file);
            } else {
                TmpDetail tmpDetail = this.decompress(file, null);
                if (tmpDetail == null) {
                    return;
                }
                this.anonymizeSpecialFile(tmpDetail.getTmpFolder());
                this.compressAndDelete(tmpDetail);
            }
        }
        catch (IOException e) {
            LOGGER.error("apear excpetion when get fileType from file: " + file, (Throwable)e);
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error("appear exception when close stream ", (Throwable)e);
            }
        }
    }
}

