/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.obase.connection.DefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionCreator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ExitHook
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExitHook.class);
    private DevNode devNode;
    private String scriptPath;
    private Map<DevNode, String> devsInfoMap;

    public ExitHook(DevNode devNode, String scriptPath, Map<DevNode, String> devsInfoMap) {
        this.devNode = devNode;
        this.scriptPath = scriptPath;
        this.devsInfoMap = devsInfoMap;
    }

    @Override
    public void run() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        LOGGER.info("start execute script");
        File script = new File(this.scriptPath);
        if (!script.exists()) {
            LOGGER.info("script is not exists!.");
            return;
        }
        File pyframe = new File(CollectDataContext.PYFRAMEPATH);
        ArrayList<File> pyClassPths = new ArrayList<File>();
        if (pyframe.exists()) {
            pyClassPths.add(pyframe);
        }
        try {
            pyClassPths.add(script.getParentFile());
            JythonExecuter executer = new JythonExecuter(pyClassPths);
            HashMap<String, Object> env = new HashMap<String, Object>();
            SshConnection ssh = new SshConnectionCreator(this.devNode, (ISshJudge)new DefaultSshJudge(), true, false).create();
            env.put("SSH", ssh);
            env.put("restMamager", RestConnectionManager.class);
            executer.compileScript(script);
            executer.invokeFunction("execute", env);
            LOGGER.info("executed script. script patch: {}", (Object)this.scriptPath);
        }
        catch (SignException e) {
            LOGGER.error("verify Script error!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("py file not found!script patch {}", (Object)script.getName());
        }
        catch (ToolException e) {
            LOGGER.error("Execute Py File error!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Execute Py Script error!", (Throwable)e);
        }
        finally {
            this.devsInfoMap.remove(this.devNode);
        }
    }
}

