/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.service.ExitHook;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;

public class ExitHookHelper
implements Callable<Boolean> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExitHookHelper.class);
    static ExecutorService executorService = Executors.newFixedThreadPool(10);
    private Map<DevNode, String> devsInfoMap;

    public ExitHookHelper(Map<DevNode, String> devsInfoMap) {
        this.devsInfoMap = devsInfoMap;
    }

    @Override
    public Boolean call() {
        LOGGER.info("start clean devices env.");
        if (!this.devsInfoMap.isEmpty()) {
            Set<Map.Entry<DevNode, String>> entrys = this.devsInfoMap.entrySet();
            for (Map.Entry<DevNode, String> entry : entrys) {
                executorService.execute(new ExitHook(entry.getKey(), entry.getValue(), this.devsInfoMap));
            }
        }
        int count = 0;
        while (count < 50 && !this.devsInfoMap.isEmpty()) {
            try {
                Thread.sleep(100L);
                ++count;
            }
            catch (InterruptedException e) {
                LOGGER.info("InterruptedException !");
            }
        }
        CollectDataContext.getInstance().getTempProtocols().clear();
        return true;
    }
}

