/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class InfoCollectNodeQuery
extends DefaultNodeTypeQuery {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InfoCollectNodeQuery.class);

    public InfoCollectNodeQuery(List<DeviceType> supportDevTypes, String ... queryInfoCmds) {
        super(supportDevTypes, queryInfoCmds);
    }

    public InfoCollectNodeQuery(List<DeviceType> supportDevTypes, INodeSupport nodeSupport, String ... queryInfoCmds) {
        super(supportDevTypes, nodeSupport, queryInfoCmds);
    }

    public InfoCollectNodeQuery() {
    }

    public void chkUnNormalStatus(DevNode devNode, ICliConnection con, TaskResult ret) {
        if (devNode.isMiniSystem()) {
            String loginMessage = ((SshConnection)con).getLoginMessage();
            this.dealMinSysInfo(devNode, loginMessage, con, ret);
        }
    }

    protected void chkSpcVersion(DevNode devNode, TaskResult ret, ICliConnection con) {
        if (devNode.isMiniSystem()) {
            return;
        }
        super.chkSpcVersion(devNode, ret, con);
    }

    public static String getInfoByNames(String cli, String ... names) {
        for (String name : names) {
            String ret = CliResolverUtils.getDeviceInfo((String)cli, (String)name);
            if (StringUtils.isNULLStr((String)ret)) continue;
            return ret.trim();
        }
        return "";
    }

    private String getNodeCfg(String cli) {
        try {
            String[] valuse;
            LOGGER.info("show system status CLI result:{}", (Object)cli);
            if (cli.contains("Double Or Single")) {
                return this.getTV1NodeNum(cli);
            }
            StringBuilder regexpBuilder = new StringBuilder();
            regexpBuilder.append(" *");
            regexpBuilder.append("node *cfg");
            regexpBuilder.append(" *(:|=)");
            regexpBuilder.append(" *");
            regexpBuilder.append("\\d*");
            Pattern pattern = Pattern.compile(regexpBuilder.toString());
            Matcher matcher = this.findMatchStr(cli, pattern);
            if (null != matcher && (valuse = matcher.group().split("[:|=]")).length >= 2) {
                return valuse[1].trim();
            }
        }
        catch (Throwable e) {
            LOGGER.error("search node cfg error !");
            return "0";
        }
        LOGGER.info("can not find node cfg value !");
        return "0";
    }

    private TaskResult dealMinSysInfo(DevNode devNode, String loginMessage, ICliConnection con, TaskResult ret) {
        try {
            String cliResult = con.execCmdWithTimout("showsysstatus", 30);
            String deviceNodeIds = this.getDeviceNodeId(cliResult);
            String deviceSerialNumber = InfoCollectNodeQuery.getInfoByNames(cliResult, "Device Serial Number", "Serial Number", "SN", "serial");
            String[] splitStr = loginMessage.split("\\|");
            String productVersion = splitStr[2].trim();
            devNode.getMiniSystemProperties().put("nodeCfg", this.getNodeCfg(cliResult));
            devNode.setDeviceName("--");
            devNode.setDeviceNodeIds(deviceNodeIds);
            devNode.setDeviceSerialNumber(deviceSerialNumber);
            devNode.setProductVersion(productVersion);
            DeviceType type = DeviceType.valueOf((String)"--");
            devNode.setDeviceType(type);
            if ("V1".equalsIgnoreCase(productVersion.substring(0, 2)) || "V2".equalsIgnoreCase(productVersion.substring(0, 2)) || "V3".equalsIgnoreCase(productVersion.substring(0, 2))) {
                ret.setResult(TaskResult.Result.SUCCESS);
                ret.setResultObject((Object)devNode);
                return ret;
            }
        }
        catch (Throwable e) {
            LOGGER.error("showsysstatus command error", e);
            ret.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
            ret.setResult(TaskResult.Result.FAILED);
        }
        return ret;
    }

    private Matcher findMatchStr(CharSequence source, Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(source);
        return matcher.find() ? matcher : null;
    }

    private String getTV1NodeNum(String cli) {
        String[] lines;
        for (String line : lines = cli.split("\n")) {
            if (!line.contains("Double Or Single")) continue;
            if (line.contains("double")) {
                return "2";
            }
            if (!line.contains("single")) continue;
            return "1";
        }
        return "1";
    }

    private String getDeviceNodeId(String cli) {
        StringBuilder nodeIds = new StringBuilder();
        String[] lines = cli.split("\n");
        int startline = 0;
        int endline = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.contains("--------------------")) {
                startline = i + 1;
            }
            if (!line.contains("exit")) continue;
            endline = i;
        }
        int count = endline - startline;
        for (int j = lines.length - 3; j > lines.length - 3 - count; --j) {
            String line = lines[j].trim();
            String[] kval = line.split("\\s{4,}");
            String id = kval[0];
            nodeIds.append(id);
            if (j <= 0) continue;
            nodeIds.append(",");
        }
        return nodeIds.toString();
    }
}

