/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectBackgroundThread;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.RunAddCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.DevDateTask;
import com.huawei.ism.tool.infocollect.service.logic.IntegrateTask;
import com.huawei.ism.tool.infocollect.service.logic.command.DescCommand;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.mails.MailConfigKeeper;
import com.huawei.ism.tool.obase.mails.MailInfo;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public final class InfoCollectService {
    private static final InfoCollectService INSTANCE = new InfoCollectService();

    private InfoCollectService() {
    }

    public static InfoCollectService getInstance() {
        return INSTANCE;
    }

    public boolean isDevNodeCollecting(DevNode devNode) {
        return CollectDataContext.getInstance().isCollecting(devNode);
    }

    public boolean isMainDevNodeCollecting(DevNode devNode) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo == null) {
            return false;
        }
        return collectInfo.isCollecting();
    }

    public void startCollectBackground(DevNode devNode) {
        SwingUtilities.invokeLater(new CollectBackgroundThread(devNode, INSTANCE));
    }

    public void startCollect(DevNode devNode) {
        LoggerFactory.getLogger(InfoCollectService.class).info("Collection start >> Device " + devNode.getIp() + " infoCollect begin][Success");
        ICollectInfo collectInfo = this.getCollectInfoInstance(devNode);
        if (null == collectInfo) {
            return;
        }
        collectInfo.resetProcessInfo();
        ICollectInfo target = collectInfo;
        ExecuteResult initResult = new DescCommand(ResourceUtil.getString((String)"infocollect.detail.perparecollect")).process();
        initResult.setDevNode(devNode);
        initResult.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        initResult.setResult(true);
        collectInfo.addExecuteResult(initResult);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(devNode);
        SwingUtilities.invokeLater(new RunAddCollectTask(target, devNode));
    }

    public boolean isSelectedNode(DevNode dev) {
        ICollectInfo collectInfo = this.getCollectInfoInstance(dev);
        String path = CollectDeviceService.getInstance().getIntegrateScriptPath(dev);
        if (!path.contains("real_integrate_find.py")) {
            return true;
        }
        if (null != collectInfo) {
            CollectConfInfo confInfo = collectInfo.getCollectConfInfo();
            return !confInfo.getSelectedIntegrateNode().isEmpty();
        }
        return true;
    }

    public ICollectInfo getCollectInfoInstance(DevNode devNode) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo == null) {
            collectInfo = this.createDefaultIntegrateCollectInfo(devNode);
            CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        }
        return collectInfo;
    }

    private CollectInfo createDefaultCollectInfo(DevNode devNode) {
        CollectConf conf = new BizPackageService().getCollectConf(devNode);
        if (conf == null) {
            return null;
        }
        CollectInfo collectInfo = new CollectInfo(devNode);
        collectInfo.setCollectConfInfo(CollectConfInfo.createDefaultInstance(conf, devNode));
        return collectInfo;
    }

    private IntegrateCollectInfo createDefaultIntegrateCollectInfo(DevNode devNode) {
        CollectInfo collectInfo = this.createDefaultCollectInfo(devNode);
        if (collectInfo == null) {
            return null;
        }
        IntegrateCollectInfo result = new IntegrateCollectInfo(devNode);
        HashMap<DevNode, CollectInfo> collectInfoes = new HashMap<DevNode, CollectInfo>();
        collectInfoes.put(devNode, collectInfo);
        result.initIntergrateCollectInfoes(collectInfoes);
        return result;
    }

    public List<String> getReceiveAddresses() {
        MailInfo mailInfo = MailConfigKeeper.getInstance().getMailInfo();
        return mailInfo.getAllReceiveAddresses();
    }

    public List<ExecuteResult> getExecuteResults(DevNode devNode) {
        ICollectInfo collectInfo;
        List<ExecuteResult> execResultList = new ArrayList<ExecuteResult>();
        if (null != devNode && null != (collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode))) {
            execResultList = collectInfo.getExecuteResults();
        }
        return execResultList;
    }

    public IntegrateCollectInfo constructIntegrateInfo(DevNode devNode) {
        ICollectInfo primaryCollectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        IntegrateCollectInfo collectInfo = null;
        if (primaryCollectInfo == null) {
            collectInfo = this.createDefaultIntegrateCollectInfo(devNode);
            if (collectInfo == null) {
                return null;
            }
        } else if (primaryCollectInfo instanceof IntegrateCollectInfo) {
            collectInfo = (IntegrateCollectInfo)primaryCollectInfo;
        } else if (primaryCollectInfo instanceof CollectInfo) {
            collectInfo = new IntegrateCollectInfo((CollectInfo)primaryCollectInfo);
        }
        CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        return collectInfo;
    }

    public String searchIntegrateInfo(IntegrateCollectInfo collectInfo, String scriptFilePath) {
        IntegrateTask task = new IntegrateTask(collectInfo, scriptFilePath);
        task.doTask();
        String xmlString = task.getIntegrateReturnXmlString();
        if (scriptFilePath.contains("real_integrate_find.py")) {
            return xmlString;
        }
        task.dealBatchXml();
        return "";
    }

    public String getDevCurDate(DevNode dev, String path) {
        DevDateTask task = new DevDateTask(dev, path);
        return task.getCurDate();
    }
}

