/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.infocollect.dpc.entity.ConfigParam;
import com.huawei.ism.tool.infocollect.dpc.entity.ConfigProgressResponse;
import com.huawei.ism.tool.infocollect.dpc.service.CollectException;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectConvertService;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ThreadUtils;

public class PackageA800ClusterTask
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(PackageA800ClusterTask.class);
    private final ProgressDialog progressDialog;
    private final List<DevNode> devices;
    private final String infoCollectDir;
    private DpcCollectConvertService convertService = DpcCollectConvertService.getInstance();
    private StringJoiner errorMsg = new StringJoiner(System.lineSeparator());

    @Override
    public Boolean call() throws Exception {
        try {
            this.collectConfig();
            Boolean bl = this.packageCluster();
            return bl;
        }
        finally {
            SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
        }
    }

    private boolean packageCluster() {
        this.devices.forEach(this::moveDir);
        File[] sourceFiles = new File(this.infoCollectDir).listFiles();
        if (Objects.isNull(sourceFiles)) {
            log.warn("{} is empty.", (Object)this.infoCollectDir);
            return false;
        }
        boolean isCompress = FileAssistant.compressFile7zByMX0((String)this.getResultsFileName(), (String[])new String[]{this.infoCollectDir + "\\*"});
        log.info("execute compress file result is:{}", (Object)isCompress);
        if (!isCompress) {
            log.error("Failed to compress the file({}).", (Object)this.infoCollectDir);
            return false;
        }
        this.clearTempDir();
        return true;
    }

    private String getResultsFileName() {
        return String.join((CharSequence)File.separator, InfoCollectDirPropertiesUtil.getProperty(), new File(this.infoCollectDir).getName() + ".7z");
    }

    private void clearTempDir() {
        log.info("Delete temporary files : {}", (Object)this.infoCollectDir);
        FileUtils.deleteFile((File)new File(this.infoCollectDir));
    }

    private void moveDir(DevNode devNode) {
        File saveDir = new File(InfoCollectUtil.getDevCollectDir(devNode));
        if (!saveDir.exists()) {
            log.warn("The folder({}) does not exist.", (Object)saveDir);
            return;
        }
        if (Objects.isNull(saveDir.listFiles())) {
            log.warn("The folder({}) is empty.", (Object)saveDir);
            return;
        }
        String tempDir = String.join((CharSequence)File.separator, this.infoCollectDir, InfoCollectUtil.isA800Om(devNode) ? "dataturbo" : "zone");
        if (!saveDir.renameTo(new File(String.join((CharSequence)File.separator, tempDir, saveDir.getName())))) {
            log.error("move {} to {} failed.", (Object)saveDir.getName(), (Object)tempDir);
        }
    }

    private void collectConfig() {
        Optional<AiDevNode> aiDevNodeOpt = DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).findFirst();
        if (!aiDevNodeOpt.isPresent()) {
            log.error("aiDevNode is null.");
            this.errorMsg.add(ResourceUtil.getString((String)"infocollect.collect.config.fail"));
            return;
        }
        AiDevNode aiDevNode = aiDevNodeOpt.get();
        if (Utils.isNullList((List)aiDevNode.getA800Nodes())) {
            log.error("No HyperScale cluster.");
            this.errorMsg.add(ResourceUtil.getString((String)"infocollect.collect.config.fail"));
            return;
        }
        String sn = ((A800Node)aiDevNode.getA800Nodes().get(0)).getDeviceSerialNumber();
        ConfigParam param = ConfigParam.builder().storageSn(sn).build();
        log.info("Start collect config. The SN of the A800 cluster is {}.", (Object)sn);
        try {
            this.convertService.packConfig(aiDevNode, param);
            if (this.pollingQueryTask(aiDevNode, param)) {
                this.convertService.downloadConfig(aiDevNode, param, this.infoCollectDir);
            }
        }
        catch (ToolException e) {
            log.error("Failed to export the config file of the A800 cluster({}).", (Object)sn, (Object)e);
            this.errorMsg.add(ResourceUtil.getString((String)"infocollect.collect.config.fail"));
        }
        catch (CollectException e) {
            log.error("Failed to export the config file.");
            this.errorMsg.add(ResourceUtil.getString((String)"infocollect.collect.config.fail"));
        }
    }

    private boolean pollingQueryTask(AiDevNode aiDevNode, ConfigParam param) throws ToolException, CollectException {
        ConfigProgressResponse response;
        long startTime = System.currentTimeMillis();
        do {
            ThreadUtils.sleepSeconds((long)30L);
            response = this.convertService.queryConfigTask(aiDevNode, param);
            if (response.getProgress() != 100) continue;
            log.info("The configuration file packing progress is 100.");
            return true;
        } while (System.currentTimeMillis() - startTime <= DataTurboUtil.CONFIG_TASK_OVERTIME_MILLS);
        log.error("Collect dpc performance files timed out. progress is {}.", (Object)response.getProgress());
        this.errorMsg.add(ResourceUtil.getString((String)"infocollect.collect.config.time.out"));
        return false;
    }

    public PackageA800ClusterTask(ProgressDialog progressDialog, List<DevNode> devices, String infoCollectDir) {
        this.progressDialog = progressDialog;
        this.devices = devices;
        this.infoCollectDir = infoCollectDir;
    }

    public StringJoiner getErrorMsg() {
        return this.errorMsg;
    }
}

