/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.PreCondition;
import com.huawei.ism.tool.infocollect.entity.PreParam;
import com.huawei.ism.tool.infocollect.entity.PreQueryDevNode;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.logic.PreExecuter;
import com.huawei.ism.tool.infocollect.ui.support.ShowPreResultDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreConditionServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreConditionServer.class);
    private static final PreConditionServer INSTANCE = new PreConditionServer();
    private List<PreQueryDevNode> queryNodes = new ArrayList<PreQueryDevNode>();
    private List<DevNode> unSelectNode = new ArrayList<DevNode>();
    private Map<DevNode, List<CollectItem>> unCollectItem = new HashMap<DevNode, List<CollectItem>>();

    private PreConditionServer() {
    }

    public static PreConditionServer getInstance() {
        return INSTANCE;
    }

    public void addPreCondition(DevNode devNode) {
        PreQueryDevNode curPreConditeion = this.combinPreCondition(devNode);
        if (null != curPreConditeion) {
            this.queryNodes.add(curPreConditeion);
        }
    }

    public void clearPreCondition() {
        this.queryNodes = new ArrayList<PreQueryDevNode>();
        this.unSelectNode = new ArrayList<DevNode>();
        this.unCollectItem = new HashMap<DevNode, List<CollectItem>>();
    }

    public PreQueryDevNode combinPreCondition(DevNode devNode) {
        List<PreCondition> allPreConditions = null;
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(devNode);
        if (conf != null) {
            allPreConditions = conf.getPreConditions();
        }
        if (null == allPreConditions || allPreConditions.isEmpty()) {
            return null;
        }
        String scriptFolder = InfoConfiguration.getInstance().getPackageScriptPath(devNode);
        PreQueryDevNode queryNode = new PreQueryDevNode();
        queryNode.setIp(devNode.getIp());
        queryNode.setDevNode(devNode);
        for (PreCondition preCondition : allPreConditions) {
            PreParam preParam = new PreParam();
            String scriptName = preCondition.getFileName();
            String scriptPath = scriptFolder + File.separator + scriptName;
            String referItemId = preCondition.getReferItemId();
            String method = preCondition.getMethod();
            preParam.setScriptPath(scriptPath);
            preParam.setMethod(method);
            if (!this.isSelectItem(devNode, referItemId)) continue;
            queryNode.getParams().add(preParam);
        }
        return queryNode;
    }

    private boolean isSelectItem(DevNode devNode, String referItemId) {
        ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(devNode);
        if (null == collectInfo) {
            throw new NullPointerException();
        }
        List<CollectItem> collectItems = collectInfo.getCollectConfInfo().getSelectItems();
        ArrayList<CollectItem> curUnCollectItem = new ArrayList<CollectItem>();
        for (CollectItem collectItem : collectItems) {
            String curId = collectItem.getId();
            if (!curId.equals(referItemId)) continue;
            curUnCollectItem.add(collectItem);
            this.unCollectItem.put(devNode, curUnCollectItem);
            return true;
        }
        return false;
    }

    public boolean isContinueCollect() {
        Map finalDeviceMap = null;
        if (!this.queryNodes.isEmpty()) {
            finalDeviceMap = (Map)AsyncExcutor.execute((Window)CollectUIContext.getInstance().getMainDialog(), (Callable[])new Callable[]{new PreConditionCallable()}).get(0);
        }
        if (null == finalDeviceMap || finalDeviceMap.isEmpty()) {
            return true;
        }
        ShowPreResultDialog showDialog = new ShowPreResultDialog(CollectUIContext.getInstance().getMainDialog(), finalDeviceMap);
        if (!showDialog.isKeep()) {
            return false;
        }
        this.unSelectNode = showDialog.getUnSelectNode();
        this.siftCollectItem();
        return true;
    }

    private void siftCollectItem() {
        for (DevNode devNode : this.unSelectNode) {
            List<CollectItem> curUnCollectItems = this.unCollectItem.get(devNode);
            ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(devNode);
            if (null == collectInfo) {
                throw new NullPointerException();
            }
            List<CollectItem> collectItems = collectInfo.getCollectConfInfo().getSelectItems();
            collectItems.removeAll(curUnCollectItems);
        }
    }

    public List<PreQueryDevNode> getQueryNodes() {
        return this.queryNodes;
    }

    public void setQueryNodes(List<PreQueryDevNode> queryNodes) {
        this.queryNodes = queryNodes;
    }

    public List<DevNode> getUnSelectNode() {
        return this.unSelectNode;
    }

    public void setUnSelectNode(List<DevNode> unSelectNode) {
        this.unSelectNode = unSelectNode;
    }

    class PreConditionCallable
    implements Callable<Map<DevNode, String>> {
        PreConditionCallable() {
        }

        @Override
        public Map<DevNode, String> call() {
            List finalQueryNode = PreConditionServer.this.queryNodes;
            try {
                PreExecuter excuter = new PreExecuter(finalQueryNode);
                return excuter.queryPreCondition();
            }
            catch (IllegalStateException e) {
                LOGGER.error("unreachable code exception", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                LOGGER.error("query preConditon exception", (Throwable)e);
                return null;
            }
        }
    }
}

