/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.fit.util.CollectResultUtil;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.backgroud.ProgressObserver;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskExecuteResult;
import com.huawei.ism.tool.infocollect.service.logic.CollectTask;
import com.huawei.ism.tool.infocollect.service.logic.FcvCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.command.GainExecuteScriptCommand;
import com.huawei.ism.tool.infocollect.util.FilesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.infocollect.util.PackageUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class ExecuteTask
extends TaskBase {
    public static final String PROGRESS_FILE = "Progress.xml";
    private static final ExecuteTask INSTANCE = new ExecuteTask();
    private static final int INIT_PROGRESS = 35;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExecuteTask.class);
    private static final String LOG_CUT_SCRIPT_PATH = "logCutProcess" + File.separator + "script";
    private static final String LOG_CUT_SCRIPT_NAME = "fileCutProcess.py";
    private static final String CONFIG_PATH = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath();
    private static final CollectDataContext CONTEXT = CollectDataContext.getInstance();
    private ProgressObserver progressObserver = null;
    private String status = "waiting";
    private int progress;
    private boolean isAllFinished = false;
    private TaskExecuteResult executResult = new TaskExecuteResult();
    private Map<String, DevNode> devNodeMap = new HashMap<String, DevNode>();
    private List<DevNode> devNodes = null;

    public ExecuteTask() {
    }

    public ExecuteTask(TaskParams params) {
        super.setParams(params);
    }

    public static ExecuteTask getInstance() {
        return INSTANCE;
    }

    public boolean isAllFinished() {
        return this.isAllFinished;
    }

    public void setAllFinished(boolean isAllFinish) {
        this.isAllFinished = isAllFinish;
    }

    public TaskExecuteResult getExecutResult() {
        return this.executResult;
    }

    @Override
    public void run() {
        this.setStatus("waiting");
        try {
            this.devNodes = this.parseJson2Node();
            this.queryDeviceInfo();
            this.prepare(this.devNodes);
            this.execute(this.devNodes);
        }
        catch (Exception e) {
            LOGGER.error("run execCollectTask error.", (Throwable)e);
            this.fillFailedProgressXmlSilence(this.devNodes);
        }
        finally {
            CollectDataContext.getInstance().setBackProcessRunning(false);
            LOGGER.error("Task finished, BACK_COUNT--");
            CollectDataContext.BACK_COUNT.decrementAndGet();
        }
    }

    private void fillFailedProgressXmlSilence(List<DevNode> currDevNodes) {
        for (DevNode devNode : currDevNodes) {
            SilentProcessData processData = new SilentProcessData(EntityUtils.toNewDev((DevNode)devNode), "failed", "finished", ResourceUtil.getString((String)"infocollect.collect.silence.failed"));
            CONTEXT.putSilentProgress(devNode, 100);
            CONTEXT.updateSilentResult(devNode, processData);
        }
    }

    private void queryDeviceInfo() {
        ArrayList<DevNode> devNodesTmp = new ArrayList<DevNode>();
        for (DevNode devNode : this.devNodes) {
            CollectDeviceService deviceService = CollectDeviceService.getInstance();
            List<DevNode> devNodeList = deviceService.getIntegratedNodes(devNode);
            if (devNode.isDsStorage()) {
                this.queryDStroageInfo(devNode, devNodesTmp);
                this.updateDStroageDevNode(devNode);
                continue;
            }
            devNodesTmp.addAll(devNodeList);
        }
        for (DevNode devNode : devNodesTmp) {
            this.devNodeMap.put(devNode.getIp(), devNode);
        }
        this.devNodes = devNodesTmp;
    }

    private void updateDStroageDevNode(DevNode devNode) {
        if (!this.getParams().getDevNode().equals((Object)devNode)) {
            return;
        }
        String nodes = this.getParams().getDevNodes();
        List clusterNodes = devNode.getClusterNodes();
        if (StringUtils.isNULLStr((String)nodes) || clusterNodes == null || clusterNodes.isEmpty()) {
            return;
        }
        String[] nodeList = nodes.split(",");
        if (nodeList.length == 0) {
            clusterNodes.forEach(clusterNode -> clusterNode.setSelected(clusterNode.includedStorageService() || clusterNode.includeManagementRole()));
            return;
        }
        for (ClusterNode clusterNode2 : clusterNodes) {
            clusterNode2.setSelected(false);
            for (String string : nodeList) {
                if (!string.equals(clusterNode2.getId() + "")) continue;
                clusterNode2.setSelected(true);
            }
        }
    }

    private void queryDStroageInfo(DevNode devNode, List<DevNode> devNodesTmp) {
        try {
            CollectDeviceService deviceService = CollectDeviceService.getInstance();
            if (deviceService.getResourceFileAndImportAsPackage(devNode) && deviceService.queryDstorageClusterNodes(devNode)) {
                devNodesTmp.add(devNode);
            } else {
                CollectResultUtil.collectError(devNode, ResourceUtil.getString((String)"infocollect.detail.initenv"), ResourceUtil.getString((String)"infocollect.error.infocollect.init.error1"));
                SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)devNode), "failed", "finished", devNode.getErrorDecs());
                data.setProcess(String.valueOf(100));
                CollectDataContext.getInstance().updateSilentResult(devNode, data);
            }
        }
        catch (Exception e) {
            LOGGER.info("query dstorage info error.", (Throwable)e);
            CollectResultUtil.collectError(devNode, ResourceUtil.getString((String)"infocollect.detail.initenv"), ResourceUtil.getString((String)"infocollect.error.infocollect.init.error1"));
            SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)devNode), "failed", "finished", ResourceUtil.getString((String)"infocollect.collect.silence.failed"));
            data.setProcess(String.valueOf(100));
            CollectDataContext.getInstance().updateSilentResult(devNode, data);
        }
    }

    public void prepare(List<DevNode> devs) {
        LOGGER.info("prepare devices and others...");
        try {
            InfoCollectDirPropertiesUtil.setProperty(this.getParams().getWorkPath());
            this.initCollectInfos();
            int allItemNum = this.calcAllCheckItemNum(devs);
            this.progressObserver = new ProgressObserver(allItemNum, ExecuteTask.getInstance());
        }
        catch (ToolException e) {
            LOGGER.error("Run execInspectTask task failed...", (Throwable)e);
        }
    }

    public void excludeUnsupportDevs(List<DevNode> devs) {
        Iterator<DevNode> iter = devs.iterator();
        while (iter.hasNext()) {
            DevNode dev = iter.next();
            boolean isSupport = InfoCollectUtil.isSupportDev(dev);
            if (isSupport) continue;
            iter.remove();
            LOGGER.info("Device [{}] is not support collection.", (Object)dev.getIp());
        }
    }

    public void execute(List<DevNode> devNodeList) {
        LOGGER.info("Begin to run execCollectTask task...");
        this.setStatus("running");
        for (DevNode devNode : devNodeList) {
            ICollectTask task;
            ICollectInfo collectInfo = this.getCollectInfoInstance(devNode);
            if (null == collectInfo) continue;
            if (devNode.isDsStorage()) {
                CollectInfo info = (CollectInfo)collectInfo;
                if ("bytime".equalsIgnoreCase(CollectDataContext.getInstance().getMode())) {
                    this.setCollectTimeParams(info);
                }
                task = new RestCollectTask(info, devNode, this.progressObserver);
            } else {
                task = InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode) ? new FcvCollectTask((CollectInfo)collectInfo, this.progressObserver) : new CollectTask((CollectInfo)collectInfo, devNode, this.progressObserver);
            }
            boolean initResut = task.init();
            LOGGER.info("init result for dev: {} is: {}", (Object)devNode.getDeviceSerialNumber(), (Object)initResut);
            task.run();
            this.doSplit(devNode, task);
            this.deleteTaskFile(this.getParams().getParamFile());
        }
        this.progressObserver.finishAll(100L, true);
    }

    private void doSplit(DevNode devNode, ICollectTask task) {
        String collectDir = InfoCollectUtil.getDevCollectDir(devNode);
        String sn = devNode.getDeviceSerialNumber();
        LOGGER.info(String.format(Locale.ROOT, "collect dir for dev: %s is:  %s", sn, collectDir));
        File resultDir = new File(collectDir);
        String exParams = System.getenv("exParams");
        if (!InfoCollectUtil.dealExParams(exParams, "noCompress", "true")) {
            CONTEXT.addSilentFileToDel(resultDir);
        }
        if (!CONTEXT.isSilentDevCollectSuccess(devNode)) {
            return;
        }
        if ("bytime".equalsIgnoreCase(CollectDataContext.getInstance().getMode())) {
            LOGGER.info(String.format(Locale.ROOT, "start to split log files for:%s ", sn));
            File collectFile = FilesUtil.getLastModiyFile(resultDir);
            String splitResult = "";
            if (devNode.isDsStorage()) {
                LOGGER.info("The device is DsStorage ,no need to split the log");
            } else if (null == collectFile || collectFile.isDirectory()) {
                LOGGER.error("get collect file for dev: " + devNode.getDeviceSerialNumber() + " error.");
            } else {
                splitResult = this.splitByTime(this.getParams().getStartTime(), this.getParams().getEndTime(), collectFile, devNode, INSTANCE, collectDir);
            }
            SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)devNode), splitResult.isEmpty() ? "success" : "failed", "finished", splitResult);
            CONTEXT.putSilentProgress(devNode, 100);
            CONTEXT.updateSilentResult(devNode, data);
        } else {
            SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)devNode), "success", "finished", task.getFailedMsg().length() == 0 ? "" : task.getFailedMsg().toString());
            CONTEXT.putSilentProgress(devNode, 100);
            CONTEXT.updateSilentResult(devNode, data);
        }
        this.saveFileToCompress(collectDir);
    }

    private String splitByTime(String startTime, String endTime, File file, DevNode devNode, ExecuteTask instance, String collectDir) {
        Date end;
        Date start;
        LOGGER.info("file to split: {}, save path: {}", (Object)utils.FilesUtil.getCanonicalPath((File)file), (Object)collectDir);
        String scriptFilePath = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath() + File.separator + LOG_CUT_SCRIPT_PATH + File.separator + LOG_CUT_SCRIPT_NAME;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            start = new Date(Long.parseLong(startTime));
            end = new Date(Long.parseLong(endTime));
        }
        catch (NumberFormatException e) {
            LOGGER.error("parse start time or end time error: " + e);
            return ResourceUtil.getString((String)"infocollect.collect.split.date.parse.error");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("fileSavePath", collectDir);
        paramMap.put("startTime", df.format(start));
        paramMap.put("endTime", df.format(end));
        paramMap.put("collectManagement", PackageUtils.class);
        paramMap.put("lang", this.getParams().getLang());
        paramMap.put("uiObserver", instance);
        paramMap.put("Logger", ToolLoggerFactory.getLogger(this.getClass()));
        paramMap.put("startMode", System.getenv("startMode"));
        String jthonFile = CONFIG_PATH + File.separator + LOG_CUT_SCRIPT_PATH;
        List resultList = null;
        try {
            paramMap.put("filePath", file.getCanonicalPath());
            JythonExecuter executer = new JythonExecuter(new File(jthonFile));
            executer.compileScript(new File(scriptFilePath));
            resultList = executer.invokeFunction("execute", paramMap);
        }
        catch (SignException e) {
            LOGGER.error("verify Script error!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("py file not found!jthonFile:{}", (Object)new File(jthonFile).getName());
        }
        catch (ToolException e) {
            LOGGER.error("Execute Py File error!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Execute Py Script error!", (Throwable)e);
        }
        String resultStr = this.checkResult(resultList, devNode);
        this.deleteTaskFile(collectDir);
        return resultStr;
    }

    private void saveFileToCompress(String filePath) {
        File[] retFiles = new File(filePath).listFiles();
        if (null != retFiles) {
            List<File> retFileList = Arrays.asList(retFiles);
            CONTEXT.addSilentFileToCompress(retFileList);
            LOGGER.info("add file to compress: {}", retFileList);
        }
    }

    private String checkResult(List<Object> resultList, DevNode devNode) {
        String reason;
        Boolean result;
        if (null == resultList || resultList.size() < 2) {
            result = false;
            reason = ResourceUtil.getString((String)"infocollect.collect.split.failed");
        } else {
            result = (Boolean)resultList.get(0);
            reason = (String)resultList.get(1);
        }
        return result != false ? "" : (null == reason || reason.isEmpty() ? ResourceUtil.getString((String)"infocollect.collect.split.failed") : reason);
    }

    public ICollectInfo getCollectInfoInstance(DevNode devNode) {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo == null) {
            collectInfo = this.createCollectInfoOfCollectItems(devNode, null);
            CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
        }
        return collectInfo;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProgress() {
        return String.valueOf(this.progress);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setCollectTimeParams(CollectInfo collectInfo) {
        Map<String, Object> settingInfo;
        String startTime = this.getParams().getStartTime();
        String endTime = this.getParams().getEndTime();
        if (StringUtils.isNULLStr((String)startTime) || StringUtils.isNULLStr((String)endTime)) {
            return;
        }
        SettingConfInfo settingConfInfo = collectInfo.getSettingConfInfo();
        if (settingConfInfo == null) {
            settingConfInfo = new SettingConfInfo();
            collectInfo.setSettingConfInfo(settingConfInfo);
        }
        if ((settingInfo = settingConfInfo.getSettingInfo()) == null) {
            settingInfo = new HashMap<String, Object>();
            settingConfInfo.setSettingInfo(settingInfo);
        }
        Date startDate = new Date(Long.parseLong(startTime));
        Date endDate = new Date(Long.parseLong(endTime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        settingInfo.put("startTime", sdf.format(startDate));
        settingInfo.put("endTime", sdf.format(endDate));
    }

    private void initCollectInfos() {
        LOGGER.info("init collect infos start...");
        if (!CollectionUtil.isEmpty(this.getParams().getItemIds())) {
            LOGGER.info("init collect infos itemid...");
            for (DevNode devNode : this.devNodes) {
                CollectConf conf = new BizPackageService().getCollectConf(devNode);
                if (conf == null) {
                    return;
                }
                CollectInfo collectInfo = new CollectInfo(devNode);
                collectInfo.setCollectConfInfo(CollectConfInfo.createDefaultInstance(conf, devNode, conf.getCollectItemsByItem(this.getParams().getItemIds().toArray(new String[0]))));
                CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
            }
            return;
        }
        File file = new File(this.getParams().getTaskFile());
        if (!file.exists()) {
            LOGGER.info("init collect infos task file...");
            for (DevNode devNode : this.devNodes) {
                CollectInfo collectInfo = this.createCollectInfo(devNode);
                if (null == collectInfo) {
                    return;
                }
                this.setCollectTimeParams(collectInfo);
                CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
            }
            LOGGER.info("No collection task file exist...");
            return;
        }
        try {
            LOGGER.info("init collect infos parse items...");
            SAXReader saxReader = XmlUtils.getSaxReader();
            Document doc = saxReader.read(file);
            Element root = doc.getRootElement();
            this.parseItems(root);
        }
        catch (Exception e) {
            LOGGER.error("Parse inspect task file error...", (Throwable)e);
        }
    }

    public void parseItems(Element ele) {
        Iterator itr = ele.elementIterator();
        while (itr.hasNext()) {
            Element deviceGroup = (Element)itr.next();
            List deviceList = deviceGroup.elements("device");
            for (int i = 0; i < deviceList.size(); ++i) {
                Element device = (Element)deviceList.get(i);
                List<CollectItem> collectItems = this.getSelectedCollectItems(device);
                DevNode devNode = this.devNodeMap.get(device.attributeValue("ip"));
                CollectInfo collectInfo = this.createCollectInfoOfCollectItems(devNode, collectItems);
                if (null == collectInfo) {
                    return;
                }
                CollectDataContext.getInstance().putCollectInfo(devNode, collectInfo);
            }
        }
    }

    private CollectInfo createCollectInfoOfCollectItems(DevNode devNode, List<CollectItem> collectItems) {
        CollectConf conf = new BizPackageService().getCollectConf(devNode);
        if (conf == null || null == collectItems) {
            return null;
        }
        CollectInfo collectInfo = new CollectInfo(devNode);
        collectInfo.setCollectConfInfo(CollectConfInfo.createDefaultInstance(conf, devNode, collectItems));
        return collectInfo;
    }

    private CollectInfo createCollectInfo(DevNode devNode) {
        CollectConf conf = new BizPackageService().getCollectConf(devNode);
        if (conf == null) {
            return null;
        }
        CollectInfo collectInfo = new CollectInfo(devNode);
        collectInfo.setCollectConfInfo(CollectConfInfo.createDefaultInstance(conf, devNode));
        return collectInfo;
    }

    public void createProgressFile(ExecuteTask exeTask) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("progress");
        root.addAttribute("status", "waiting");
        root.addAttribute("progress", String.valueOf(35));
        exeTask.setProgress(35);
        Date cal = Calendar.getInstance().getTime();
        String date = StringUtils.formatDate((Object)cal, (String)"yyyy-MM-dd HH:mm:ss");
        root.addAttribute("updateTime", date);
        this.writeFile2Path(doc, PROGRESS_FILE);
    }

    private List<CollectItem> getSelectedCollectItems(Element device) {
        ArrayList<CollectItem> collectItems = new ArrayList<CollectItem>();
        Iterator itr = device.elementIterator();
        while (itr.hasNext()) {
            Element itemGroup = (Element)itr.next();
            Iterator ite = itemGroup.elementIterator();
            while (ite.hasNext()) {
                Element item = (Element)ite.next();
                String itemName = item.attributeValue("name");
                String itemID = item.attributeValue("id");
                CollectItem collectItem = new CollectItem();
                collectItem.setNameKey(itemName);
                collectItem.setId(itemID);
                collectItems.add(collectItem);
            }
        }
        return collectItems;
    }

    private int calcAllCheckItemNum(List<DevNode> devNodeList) {
        int allCount = 0;
        for (DevNode devNode : devNodeList) {
            CollectInfo collectInfo = (CollectInfo)CollectDataContext.getInstance().getCollectInfo(devNode);
            if (null == collectInfo) {
                LOGGER.error("calcAllCheckItemNum error, collectInfo is null.");
                continue;
            }
            GainExecuteScriptCommand command = new GainExecuteScriptCommand(collectInfo);
            ExecuteResult result = command.process();
            if (result.isSuccess()) {
                List<ScriptItem> scriptItemList = command.getExecuteScripts();
                allCount += scriptItemList.size();
                continue;
            }
            LOGGER.error("calcAllCheckItemNum error!");
        }
        return allCount;
    }

    public ProgressObserver getProgressObserver() {
        return this.progressObserver;
    }

    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }
}

