/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.infocollect.service.backgroud.IUiObserver;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ProgressObserver
implements IUiObserver {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ProgressObserver.class);
    ExecuteTask exeTask = null;
    private int allItemNum = 0;
    private int executItemNum = 0;
    private Map<String, ExecuteResult> executeResult = new HashMap<String, ExecuteResult>();
    private final Object obj = new Object();

    public ProgressObserver(int allItemNum, ExecuteTask exeTask) {
        this.allItemNum = allItemNum;
        this.exeTask = exeTask;
    }

    @Override
    public void finishAll(long during, boolean success) {
        this.exeTask.setProgress((int)during);
        this.exeTask.setStatus("finished");
        this.exeTask.setAllFinished(true);
        this.exeTask.getExecutResult().setSuccess(success);
        LOGGER.info("All devices inspection finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Object object = this.obj;
        synchronized (object) {
            ++this.executItemNum;
            this.exeTask.setStatus("running");
            int pro = InfoCollectUtil.computeProgress(this.executItemNum, this.allItemNum);
            this.exeTask.setProgress(pro);
        }
    }

    @Override
    public Map<String, ExecuteResult> getExeresult() {
        return this.executeResult;
    }

    public ExecuteTask getExeTask() {
        return this.exeTask;
    }
}

