/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QueryItems
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QueryItems.class);
    private static final String OUTPUT_FILE_NAME = "collecItems.xml";

    public QueryItems() {
    }

    public QueryItems(TaskParams params) {
        super.setParams(params);
    }

    @Override
    public void run() {
        LOGGER.info("Begin to run QueryCollectItems task...");
        CollectDataContext.getInstance().setBackProcessRunning(true);
        List<DevNode> devNodes = this.parseJson2Node();
        try {
            Document doc = this.createReusultXML(devNodes);
            this.writeFile2Path(doc, OUTPUT_FILE_NAME);
            this.deleteTaskFile(this.getParams().getParamFile());
        }
        catch (Exception e) {
            LOGGER.error("Run query Collect items task failed...", (Throwable)e);
        }
        finally {
            this.pollFinishedTask();
            CollectDataContext.getInstance().setBackProcessRunning(false);
        }
    }

    public Document createReusultXML(List<DevNode> checkNodes) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("itemsConfig");
        CollectDeviceService deviceService = CollectDeviceService.getInstance();
        for (DevNode checkDevNode : checkNodes) {
            List<DevNode> devNodes = deviceService.getIntegratedNodes(checkDevNode);
            if (devNodes.size() > 1) {
                this.createIntergrationDeviceGroup(root, checkDevNode);
                continue;
            }
            this.createDeviceGroup(root, checkDevNode);
        }
        return doc;
    }

    private Element createIntergrationDeviceGroup(Element root, DevNode checkDevNode) {
        CollectDeviceService deviceService = CollectDeviceService.getInstance();
        Element deviceGroup = root.addElement("deviceGroup");
        deviceGroup.addAttribute("name", checkDevNode.getDeviceName());
        List<DevNode> intergrationNodes = deviceService.getIntegratedNodes(checkDevNode);
        for (DevNode subDevNode : intergrationNodes) {
            this.createDeviceGroup(deviceGroup, subDevNode);
        }
        return deviceGroup;
    }

    private Element createDeviceGroup(Element root, DevNode checkDevNode) {
        Element deviceGroup = root.addElement("deviceGroup");
        deviceGroup.addAttribute("name", checkDevNode.getDeviceName());
        Element device = deviceGroup.addElement("device");
        device.addAttribute("ip", checkDevNode.getIp());
        device.addAttribute("packageName", InfoConfiguration.getInstance().getPackageScriptPath(checkDevNode));
        this.createItemGroup(device, checkDevNode);
        return deviceGroup;
    }

    private Element createItemGroup(Element device, DevNode checkDevNode) {
        Element itemGroup = null;
        List<Object> collectModules = new ArrayList();
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(checkDevNode);
        if (conf != null) {
            collectModules = conf.getModules();
        } else {
            LOGGER.info("get collectconf is null ");
        }
        for (CollectModule collectModule : collectModules) {
            itemGroup = device.addElement("itemGroup");
            itemGroup.addAttribute("name", collectModule.getName());
            this.createItems(itemGroup, collectModule.getItems());
        }
        return itemGroup;
    }

    private Element createItems(Element itemGroup, List<CollectItem> items) {
        Element item = null;
        for (CollectItem checkItem : items) {
            item = itemGroup.addElement("item");
            item.addAttribute("name", checkItem.getNameKey());
            item.addAttribute("id", checkItem.getId());
        }
        return item;
    }
}

