/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QuerySupportDevList
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QuerySupportDevList.class);
    private static final String OUTPUT_FILE_NAME = "SupportDeviceList.xml";

    public QuerySupportDevList(TaskParams params) {
        super.setParams(params);
    }

    public QuerySupportDevList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("Begin to run QueryColectDevList task...");
        CollectDataContext.getInstance().setBackProcessRunning(true);
        boolean result = true;
        try {
            List<DevNode> devNodes = this.parseJson2Node();
            Document doc = this.createDeviceListFile(devNodes);
            result = this.writeFile2Path(doc, OUTPUT_FILE_NAME);
            if (!result) {
                LOGGER.info("BQueryColectDevList error.");
            }
            this.deleteTaskFile(this.getParams().getParamFile());
        }
        catch (Exception e) {
            LOGGER.error("Run query support devList task failed...", (Throwable)e);
        }
        finally {
            this.pollFinishedTask();
            CollectDataContext.getInstance().setBackProcessRunning(false);
        }
    }

    public Document createDeviceListFile(List<DevNode> devNodes) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("devices");
        for (DevNode dev : devNodes) {
            boolean isSupport = InfoCollectUtil.isSupportDev(dev);
            Element device = root.addElement("device");
            device.addAttribute("ip", dev.getIp());
            device.addAttribute("isSupport", String.valueOf(isSupport));
        }
        return doc;
    }
}

