/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QuerySupportVersionInfo
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QuerySupportVersionInfo.class);
    private static final String OUTPUT_FILE_NAME_OTHER = "AllSupportDevice.xml";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}";

    public QuerySupportVersionInfo() {
    }

    public QuerySupportVersionInfo(TaskParams params) {
        super.setParams(params);
    }

    @Override
    public void run() {
        LOGGER.info("Begin to run QuerySupportVersionInfo task...");
        CollectDataContext.getInstance().setBackProcessRunning(true);
        try {
            Document doc = this.createSupportDeviceDetailFile();
            this.writeFile2Path(doc, OUTPUT_FILE_NAME_OTHER);
            this.deleteTaskFile(this.getParams().getParamFile());
        }
        catch (Exception e) {
            LOGGER.error("Run query support versionInfo task failed...", (Throwable)e);
        }
        finally {
            this.pollFinishedTask();
            CollectDataContext.getInstance().setBackProcessRunning(false);
        }
    }

    public Document createSupportDeviceDetailFile() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("supportDevices");
        Set<String> modelVersions = new BizPackageService().getSupportProductsWitchVersion();
        Map<String, List<String>> modelVersionMap = this.splitModelVerion(modelVersions);
        for (Map.Entry<String, List<String>> entry : modelVersionMap.entrySet()) {
            String model = entry.getKey();
            Element device = root.addElement("supportDevice");
            device.addAttribute("type", model);
            this.createVersionDetail(device, model, modelVersionMap.get(model));
        }
        return doc;
    }

    private void createVersionDetail(Element device, String model, List<String> versions) {
        for (String ver : versions) {
            Element ele = device.addElement("version");
            ele.addAttribute("name", ver);
            this.fillSupportDetails(ele, model + " " + ver);
            this.fillUnsupportDetails(ele, model + " " + ver);
        }
    }

    private void fillSupportDetails(Element ele, String modelVersion) {
        Set<SupportVersionConf> configedDetail = new BizPackageService().getSupportVersionConfs();
        String des = "";
        for (SupportVersionConf detail : configedDetail) {
            if (!modelVersion.contains(detail.getModelVersion())) continue;
            des = detail.getDescZh();
            break;
        }
        ele.addAttribute("supportDetails", des);
    }

    private void fillUnsupportDetails(Element ele, String modelVersion) {
        Set<String> configedDetail = new BizPackageService().getExcludeProductsWitchVersion();
        ArrayList<String> list = new ArrayList<String>();
        for (String detail : configedDetail) {
            if (!detail.contains(modelVersion)) continue;
            list.add(detail);
        }
        Collections.sort(list);
        StringBuilder des = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != list.size() - 1) {
                des.append(((String)list.get(i)).split(" ")[1] + ";");
                continue;
            }
            des.append(((String)list.get(i)).split(" ")[1]);
        }
        ele.addAttribute("unsupportDetails", des.toString());
    }

    private Map<String, List<String>> splitModelVerion(Set<String> modelVers) {
        HashMap<String, List<String>> modelVersionMap = new HashMap<String, List<String>>();
        if (null == modelVers || modelVers.isEmpty()) {
            return modelVersionMap;
        }
        for (String ver : modelVers) {
            String matchStr;
            String version;
            String model = ver.replace(version = ver.substring(ver.indexOf(matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX, (int)0))).trim(), "").trim();
            if (modelVersionMap.containsKey(model)) {
                ((List)modelVersionMap.get(model)).add(version);
                continue;
            }
            ArrayList<String> verions = new ArrayList<String>();
            verions.add(version);
            modelVersionMap.put(model, verions);
        }
        return modelVersionMap;
    }
}

