/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.service.backgroud.RunExitHook;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCreateFactory;
import com.huawei.ism.tool.infocollect.util.CompressFile;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import utils.FilesUtil;

public final class TaskChecker
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskChecker.class);
    private static final String TASK_QUEUE_FILE_NAME = "taskQueue.xml";
    private static final String INSPECT_TOOL_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String TASK_TEMP_PATH = INSPECT_TOOL_PATH + File.separator + "taskQueue";
    private static final String ATT_PARAMS = "params";
    private static final String ATT_CONFIG = "config";
    private static final String ATT_ID = "id";
    private static final String ATT_VALUE = "value";
    private static final int MAGICNUMBER3000 = 3000;
    private static final String IS_VERIFY_CERTIFICATE = "isVerifyCertificate";
    private static final String WORK_PATH = "workPath";
    private static final String DEV_IP = "devIp";
    private static final String USER_NAME = "username";
    private static final String PASS_WORD = "password";
    private static final String DEVELOPER_PWD = "developerPwd";
    private static final String DEV_PORT = "port";
    private static final String DEV_VERSION = "devVersion";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String DEVICE_NAME = "deviceName";
    private static final String SERIAL_NO = "serialNo";
    private static final String DEVNODES = "devNodes";
    private static final String CSPRIKEY = "csPriKey";
    private static final String LANGUAGE = "language";
    private static final String MODE = "collectMode";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final CollectDataContext CONTEXT = CollectDataContext.getInstance();
    private static final String ENV_TOTALTASK = "totalTaskStep";
    private static final String ENV_CURRTASK = "currTaskStep";
    private static final int DEFAULT_TOTAL_PROGRESS = 100;
    private static final String FILE_FIX = "zip";
    private static final String IS_VERIFY_SSH_HOST_KEY = "isVerifySshHostKey";
    private static final String SSH_HOST_KEY = "sshHostKey";
    private static List<String> supportDstorageType = new ArrayList<String>();
    private SAXReader saxReader = new SAXReader();

    private void init() {
        int currTask;
        int totalTask;
        try {
            totalTask = Integer.valueOf(System.getenv(ENV_TOTALTASK));
            currTask = Integer.valueOf(System.getenv(ENV_CURRTASK));
        }
        catch (NumberFormatException e) {
            LOGGER.error("parse totalTask or currTask error, set total progress to 100.");
            currTask = 0;
            totalTask = 0;
        }
        LOGGER.info("total task num: {}, curr task: {}", (Object)totalTask, (Object)currTask);
        CONTEXT.setTotalSilentProgress(totalTask <= 0 || currTask <= 0 || totalTask < currTask ? 100 : 100 * currTask / totalTask);
        CONTEXT.isLastStep(totalTask == currTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block11: {
            List<TaskBase> taskList;
            boolean hasException;
            block10: {
                this.printDateTime();
                hasException = false;
                CollectDataContext.BACK_COUNT.set(0);
                this.init();
                taskList = this.getTaskFromQueue();
                if (null != taskList && !taskList.isEmpty()) break block10;
                LOGGER.error("taskList is null or empty.");
                this.exitSysAndSetExitcode(20);
                int exitCode = hasException && CONTEXT.getSilenceWorkPath().isEmpty() ? 20 : 0;
                this.exitSysAndSetExitcode(exitCode);
                return;
            }
            try {
                if ("hardDisk".equals(System.getenv("sence"))) {
                    CollectDataContext.getInstance().setMode("smart");
                }
                if ("distributedPerfstat".equals(System.getenv("sence"))) {
                    CollectDataContext.getInstance().setMode("perf");
                }
                String silenceWorkPath = taskList.get(0).getParams().getWorkPath();
                CONTEXT.setSilenceWorkPath(silenceWorkPath);
                LOGGER.info("set silent work path: {}", (Object)silenceWorkPath);
                this.silentResultDir(taskList);
                this.initSilentProgress();
                this.initSilentData(taskList);
                ExecutorService taskService = CONTEXT.getTaskExecutor();
                CONTEXT.setSilentStartTime(System.currentTimeMillis());
                for (TaskBase task : taskList) {
                    LOGGER.info("##offer one task.BACK_COUNT ++");
                    CollectDataContext.BACK_COUNT.getAndIncrement();
                    taskService.execute(task);
                }
                this.process(silenceWorkPath);
            }
            catch (RuntimeException e) {
                hasException = true;
                LOGGER.error("Unexpected error: ", (Throwable)e);
                CONTEXT.updateSilentResultExiting(true);
                int exitCode = hasException && CONTEXT.getSilenceWorkPath().isEmpty() ? 20 : 0;
                this.exitSysAndSetExitcode(exitCode);
                break block11;
            }
            catch (Exception e2) {
                hasException = true;
                LOGGER.error("Unexpected error: " + e2);
                CONTEXT.updateSilentResultExiting(true);
                int exitCode = hasException && CONTEXT.getSilenceWorkPath().isEmpty() ? 20 : 0;
                {
                    catch (Throwable throwable) {
                        int exitCode2 = hasException && CONTEXT.getSilenceWorkPath().isEmpty() ? 20 : 0;
                        this.exitSysAndSetExitcode(exitCode2);
                        throw throwable;
                    }
                }
                this.exitSysAndSetExitcode(exitCode);
            }
            int exitCode = hasException && CONTEXT.getSilenceWorkPath().isEmpty() ? 20 : 0;
            this.exitSysAndSetExitcode(exitCode);
        }
    }

    private void process(String silenceWorkPath) throws InterruptedException {
        do {
            Thread.sleep(3000L);
        } while (CollectDataContext.BACK_COUNT.get() != 0);
        String exParams = System.getenv("exParams");
        if (!InfoCollectUtil.dealExParams(exParams, "noCompress", "true")) {
            LOGGER.info("start to compress result.");
            String moveResult = CONTEXT.moveSilentFileToCompress();
            this.compressFile(silenceWorkPath + File.separator + CollectDataContext.getSilentResultDir(), moveResult);
        }
        LOGGER.info("CollectDataContext.BACK_COUNT==0 need exit");
        CONTEXT.updateSilentResultExiting(false);
    }

    private void silentResultDir(List<TaskBase> taskList) {
        boolean containStorage = false;
        boolean containDStorage = false;
        String date = new SimpleDateFormat("yyyyMMddkkmmss").format(new Date());
        String name = "CollectResult";
        if (taskList.isEmpty()) {
            CollectDataContext.setSilentResultDir(name + "_1_" + date);
            return;
        }
        for (TaskBase taskBase : taskList) {
            if (taskBase.getParams() == null) continue;
            if (taskBase.getParams().getDevNode().isDsStorage()) {
                containDStorage = true;
                continue;
            }
            containStorage = true;
        }
        if (containStorage && !containDStorage) {
            CollectDataContext.setSilentResultDir(name + "_1_" + date);
        } else if (!containStorage && containDStorage) {
            CollectDataContext.setSilentResultDir(name + "_2_" + date);
        } else if (containStorage && containDStorage) {
            CollectDataContext.setSilentResultDir(name + "_3_" + date);
        } else {
            CollectDataContext.setSilentResultDir(name + "_1_" + date);
        }
    }

    private void compressFile(String targetFile, String resultFile) {
        LOGGER.info("compressFile, targetFile: {}}, resultFile: {}", (Object)targetFile, (Object)resultFile);
        if (!CONTEXT.isLastStep() || resultFile == null) {
            return;
        }
        new CompressFile().compressFileTo7z(targetFile, resultFile, FILE_FIX).deleteFile(new File(resultFile));
    }

    private void initSilentProgress() {
        SilentProcessData data = new SilentProcessData();
        data.setStatus("running");
        SilentProcessToFile.createProgressData((SilentProcessData)data, (String)CONTEXT.getSilenceWorkPath());
    }

    private void initSilentData(List<TaskBase> tasks) {
        LinkedList<TaskBase> del = new LinkedList<TaskBase>();
        for (TaskBase task : tasks) {
            DevNode node = task.parseJson2Node().get(0);
            SilentProcessData processData = null;
            if (InfoCollectUtil.isSupportDev(node)) {
                processData = new SilentProcessData(EntityUtils.toNewDev((DevNode)node), "", "running", "");
                CONTEXT.putSilentProgress(node, 5);
            } else {
                processData = new SilentProcessData(EntityUtils.toNewDev((DevNode)node), "failed", "finished", ResourceUtil.getString((String)"infocollect.collect.silence.unsupport"));
                del.add(task);
                CONTEXT.putSilentProgress(node, 100);
                CONTEXT.setHasOneTaskFailed(true);
                LOGGER.info("unsupported dev: {}", (Object)node.getDeviceSerialNumber());
            }
            CollectDataContext.getInstance().updateSilentResult(node, processData);
        }
        for (TaskBase task : del) {
            tasks.remove(task);
        }
    }

    private void printDateTime() {
        Calendar cal = Calendar.getInstance();
        String date = StringUtils.formatDate((Object)cal.getTime(), (String)"yyyyMMddHHmmss");
        LOGGER.info("##Check task at time: {}", (Object)date);
    }

    private void exitSysAndSetExitcode(int exitcode) {
        LOGGER.info("All task finished, close background process.");
        CONTEXT.delSilentFileExiting();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(ToolThreadFactory.newDefaultThread((Runnable)new RunExitHook()));
        runtime.exit(exitcode);
    }

    public List<TaskBase> getTaskFromQueue() {
        File taskQueueFile = new File(TASK_TEMP_PATH, TASK_QUEUE_FILE_NAME);
        if (!taskQueueFile.exists()) {
            LOGGER.error("No task queue file exist...");
            return null;
        }
        List<TaskBase> tb = null;
        try {
            tb = this.executeParseTask(taskQueueFile);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return tb;
    }

    public Document parseXML2Doc(File xmlFile) {
        Document doc;
        try {
            doc = this.saxReader.read(xmlFile);
        }
        catch (Exception e) {
            LOGGER.error("Read task queue file failed...", (Throwable)e);
            doc = DocumentHelper.createDocument();
        }
        return doc;
    }

    public TaskParams parseTaskParams(String filePath) {
        LOGGER.info("Task file is: {}", (Object)filePath);
        TaskParams tp = new TaskParams();
        tp.setParamFile(filePath);
        File paramsFile = new File(filePath);
        Document doc = this.parseXML2Doc(paramsFile);
        Element root = doc.getRootElement();
        if (null == root || root.elements().isEmpty()) {
            LOGGER.info("no such task file: {}", (Object)filePath);
            return tp;
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element param = (Element)it.next();
            String id = param.attributeValue(ATT_ID);
            this.parse(tp, param, id);
        }
        LOGGER.info("devnode:{} forw: {}", (Object)tp.getDevNode(), (Object)(tp.getDevNode().getSshForwardList() == null ? "null" : tp.getDevNode().getSshForwardList().get(0)));
        DevNode node = tp.getDevNode();
        for (String supportType : supportDstorageType) {
            if (!supportType.equalsIgnoreCase(node.getDeviceType().toString())) continue;
            node.setItDeviceType(ItDeviceType.DStorage);
        }
        return tp;
    }

    private void parse(TaskParams tp, Element param, String id) {
        if (WORK_PATH.equals(id)) {
            tp.setWorkPath(param.attributeValue(ATT_VALUE));
        } else if (DEV_IP.equals(id)) {
            tp.setDevIP(param.attributeValue(ATT_VALUE));
        } else if (USER_NAME.equals(id)) {
            tp.setUserName(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE)));
        } else if (PASS_WORD.equals(id)) {
            tp.setPassWord(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE)));
        } else if (DEVELOPER_PWD.equals(id)) {
            tp.setDeveloperPWD(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE)));
        } else if (DEV_VERSION.equals(id)) {
            tp.setDevVersion(param.attributeValue(ATT_VALUE));
        } else if (DEVICE_TYPE.equals(id)) {
            tp.setDeviceType(param.attributeValue(ATT_VALUE));
        } else if (DEVICE_NAME.equals(id)) {
            tp.setDeviceName(param.attributeValue(ATT_VALUE));
        } else if (SERIAL_NO.equals(id)) {
            tp.setSerialNo(param.attributeValue(ATT_VALUE));
        } else if (DEVNODES.equals(id)) {
            tp.setDevNodes(param.attributeValue(ATT_VALUE));
        } else if (IS_VERIFY_CERTIFICATE.equals(id)) {
            tp.setVerifyCertificate(Boolean.parseBoolean(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE))));
        }
        this.parseHelper(tp, param, id);
        this.parseSshParams(tp, param, id);
    }

    private void parseSshParams(TaskParams tp, Element param, String id) {
        if (SSH_HOST_KEY.equals(id)) {
            tp.setSshHostKeyInfo(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE)));
        } else if (IS_VERIFY_SSH_HOST_KEY.equals(id)) {
            tp.setSshHostVerifyFlag(Boolean.valueOf(AESEncrypt.decrypt((String)param.attributeValue(ATT_VALUE))));
        }
    }

    private void parseHelper(TaskParams tp, Element param, String id) {
        if (LANGUAGE.equals(id)) {
            String lan = param.attributeValue(ATT_VALUE);
            tp.setLang(lan);
            this.setLanguageEnv(lan);
        } else if (CSPRIKEY.equals(id)) {
            PriKeyInfo pri = EntityUtils.jsonToPriKey((String)param.attributeValue(ATT_VALUE));
            if (null != pri) {
                pri.setKeyPwd(pri.getKeyPwd());
                tp.getDevNode().setPriKey(pri);
            }
        } else if ("sshForward".equals(id)) {
            String proxy = param.attributeValue(ATT_VALUE);
            tp.setSSHForward(proxy);
        } else if ("sock5".equals(id)) {
            String proxy = param.attributeValue(ATT_VALUE);
            tp.setSockesProxy(proxy);
        } else if ("priKey".equals(id)) {
            String privKey = param.attributeValue(ATT_VALUE);
            LOGGER.info("privKey is Blank:{}", (Object)org.apache.commons.lang3.StringUtils.isBlank((CharSequence)privKey));
            tp.getDevNode().setPriKey(EntityUtils.jsonToPriKey((String)privKey));
        } else if (MODE.equals(id)) {
            CollectDataContext.getInstance().setMode(param.attributeValue(ATT_VALUE));
        } else if (START_TIME.equals(id)) {
            tp.setStartTime(param.attributeValue(ATT_VALUE));
        } else if (END_TIME.equals(id)) {
            tp.setEndTime(param.attributeValue(ATT_VALUE));
        } else if (DEV_PORT.equals(id)) {
            tp.setPort(param.attributeValue(ATT_VALUE));
        }
    }

    public void setLanguageEnv(String lan) {
        Locale language = null;
        language = Locale.SIMPLIFIED_CHINESE.getLanguage().equals(lan) ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
        ApplicationContext.getInstance().setCurrentLanguage(language);
    }

    private List<TaskBase> executeParseTask(File queFile) {
        LinkedList<TaskBase> resultList = new LinkedList<TaskBase>();
        Document doc = this.parseXML2Doc(queFile);
        Element root = doc.getRootElement();
        LOGGER.info("Contents of taskQueue file is:\n {}", (Object)root.asXML());
        if (root.elements().isEmpty()) {
            LOGGER.info("No Task in taskQueue file.");
            return null;
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element taskEle = (Element)it.next();
            String paramfile = taskEle.attributeValue(ATT_PARAMS);
            if (null == paramfile || paramfile.isEmpty()) {
                LOGGER.error("parse paramfile error, the paramfile if null or empty.");
                continue;
            }
            TaskParams params = this.parseTaskParams(paramfile);
            String taskfile = taskEle.attributeValue(ATT_CONFIG);
            params.setTaskFile(taskfile);
            root.remove(taskEle);
            this.removeTask(doc, queFile);
            resultList.add(new TaskCreateFactory().createTask(params));
        }
        return resultList;
    }

    public void removeTask(Document doc, File file) {
        LOGGER.info("remove task from taskQueue file. file path : {}", (Object)FilesUtil.getCanonicalPath((File)file));
        TaskBase.writeFile2Path(doc, file);
    }

    static {
        ResourceBundle sysBundle = ResourceBundle.getBundle("config.infocollect");
        try {
            String[] supportTypes;
            String supportTypeStr = sysBundle.getString("supportdstoragetype");
            for (String supportType : supportTypes = supportTypeStr.split(",")) {
                supportDstorageType.add(supportType.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error("init ds support type error.", (Throwable)e);
        }
    }
}

