/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.backgroud;

import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskExecuteResult;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class UpdatesProgressThread
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpdatesProgressThread.class);
    private static final int SLEEP_TIME = 15000;
    private ExecuteTask exeTask;
    private boolean flag = false;

    public UpdatesProgressThread(ExecuteTask exeTask) {
        this.exeTask = exeTask;
    }

    @Override
    public void run() {
        this.exeTask.createProgressFile(this.exeTask);
        do {
            this.flag = this.runUpdate(30);
        } while (!this.flag);
    }

    private Boolean runUpdate(int process) {
        try {
            Thread.sleep(15000L);
            this.updateProgressInFile(process);
            if (this.exeTask.isAllFinished()) {
                LOGGER.info("collect finished update process...{}", (Object)this.exeTask.getProgress());
                this.updateProgressInFile(process);
                LOGGER.info("progress update thread exit...");
                return true;
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("progress update thread exit...");
            return true;
        }
        return false;
    }

    private void updateProgressInFile(int process) {
        Date dateTime = Calendar.getInstance().getTime();
        String time = StringUtils.formatDate((Object)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        File file = new File(this.exeTask.getParams().getWorkPath(), "Progress.xml");
        Document doc = null;
        try {
            SAXReader saxReader = XmlUtils.getSaxReader();
            doc = saxReader.read(file);
        }
        catch (Exception e) {
            LOGGER.error("Analysis progress File error...", (Throwable)e);
            return;
        }
        Element pro = doc.getRootElement();
        pro.addAttribute("status", this.exeTask.getStatus());
        int progress = this.getCurrentProgress() + process;
        LOGGER.info("current process is :{}", (Object)progress);
        pro.addAttribute("progress", String.valueOf(this.getCurrentProgress() + process));
        pro.addAttribute("updateTime", time);
        if (!this.flag && "finished".equals(this.exeTask.getStatus())) {
            this.updateResult(pro);
            this.flag = true;
        }
        this.exeTask.writeFile2Path(doc, "Progress.xml");
        LOGGER.info("Progress file update time: {}", (Object)Calendar.getInstance().getTime());
    }

    private void updateResult(Element pros) {
        Element result = pros.addElement("result");
        TaskExecuteResult executResult = this.exeTask.getExecutResult();
        boolean success = executResult.isSuccess();
        String resValue = success ? "success" : "fail";
        result.addAttribute("result", resValue);
        if (!success) {
            result.addAttribute("errMsgEn", executResult.getEnErrorMsg());
            result.addAttribute("errMsgZh", executResult.getZhErrorMsg());
        }
    }

    private int getCurrentProgress() {
        return Integer.parseInt(this.exeTask.getProgress());
    }
}

