/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.callback;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.callback.IProgressObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;

public class UIProgressObserver
implements IProgressObserver {
    private final DevNode node;

    public UIProgressObserver(DevNode node) {
        this.node = node;
    }

    @Override
    public void updateProgress(int progress, String remainTime) {
        if (CollectDataContext.getInstance().isBackground()) {
            return;
        }
        CollectDataContext.getInstance().getCollectInfo(this.node).updateLastExecuteResult(progress, remainTime);
    }

    @Override
    public void updateAnothorProgress(int progress, String remainTime) {
        if (CollectDataContext.getInstance().isBackground()) {
            return;
        }
        CollectDataContext.getInstance().getCollectInfo(this.node).updateExecuteResult(progress, remainTime);
    }

    @Override
    public void updateDepthCollectProgress(int progress, String remainTime) {
        if (CollectDataContext.getInstance().isBackground()) {
            return;
        }
        CollectDataContext.getInstance().getCollectInfo(this.node).updateDepthCollectExecuteResult(progress, remainTime);
    }

    @Override
    public void updateProgress(ExecuteResult result, int progress, String remainTime) {
        if (CollectDataContext.getInstance().isBackground()) {
            return;
        }
        this.updateProgress(result, progress, remainTime, "");
    }

    @Override
    public void updateProgress(ExecuteResult result, int progress, String remainTime, String info) {
        if (CollectDataContext.getInstance().isBackground()) {
            return;
        }
        if (null == result) {
            return;
        }
        if (progress > 0 && progress <= 100) {
            result.setSingleProgress(progress);
        }
        if (!StringUtils.isNULLStr((String)remainTime)) {
            result.setRemainTime(remainTime);
        }
        if (!StringUtils.isNULLStr((String)info)) {
            result.setProgressExtrasInfo(info);
        }
    }

    public int getCurrentProgress() {
        return CollectDataContext.getInstance().getCollectInfo(this.node).getLatestProgress();
    }

    public int getProgress() {
        return CollectDataContext.getInstance().getCollectInfo(this.node).getProgress();
    }

    public int getDepthCollectProgress() {
        return CollectDataContext.getInstance().getCollectInfo(this.node).getDepthCollectProgress();
    }
}

