/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectTask;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.service.logic.CollectTask;
import com.huawei.ism.tool.infocollect.service.logic.FcvCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectTask;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectSupport {
    private static final Logger log = LoggerFactory.getLogger(CollectSupport.class);
    private static final CollectSupport INSTANCE = new CollectSupport();
    private final ExecutorService executorService = ThreadPoolHelper.getFixedNumThreadPool((int)CollectDataContext.getInstance().getThreadPoolNumbers(), (String)"collect_tasks_pool", (thread, ex) -> log.error("collect task uncaught error occurred", ex));

    private CollectSupport() {
    }

    public static CollectSupport getInstance() {
        return INSTANCE;
    }

    public void addCollectTask(ICollectInfo collectInfo, DevNode devNode) {
        Collection<CollectInfo> collectInfoes = collectInfo.getCollectInfoes().values();
        for (CollectInfo current : collectInfoes) {
            if (current == null) continue;
            ICollectTask task = InfoCollectUtil.isA800Om(devNode) ? new DpcCollectTask(current, devNode) : (devNode.isDsStorage() ? new RestCollectTask(current, devNode) : (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode) ? new FcvCollectTask(current) : new CollectTask(current, devNode)));
            boolean result = task.init();
            if (result) {
                this.executorService.execute(task);
                continue;
            }
            LoggerFactory.getLogger(CollectSupport.class).info(devNode.getIp() + "start task failed!");
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

