/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.base.context.StartParamContext;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.devicemanager.utils.LicenseFeatureQueryUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectNodeType;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.CollectTimeType;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.SFTPProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptType;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectLock;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.backgroud.IUiObserver;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.infocollect.service.logic.ConcurrentCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.ExtendedSshConnectionQueue;
import com.huawei.ism.tool.infocollect.service.logic.command.CheckCollectingCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.ClearCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.DescCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.GainExecuteScriptCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.PythonCommand;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.support.DeviceSetupIcon;
import com.huawei.ism.tool.infocollect.ui.support.DeviceStopIcon;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class CollectTask
implements ICollectTask {
    private static final Logger log = LoggerFactory.getLogger(CollectTask.class);
    private static final String DISK_LOG_NORMAL = "normal_disklog";
    private static final String DURATION_START_TIME = "durationStartTime";
    private static final String RUNNING_DISK_LOG_RESLT = "RunningDisklogResult.txt";
    private static final String PRE_COLLECT = "pre_collect";
    private static final String LOG = "log";
    private static final String ITEM_ALL_LOG = "item_all_log";
    private static final String ITEM_MODEL_ID = "model_log";
    private static final String ITEM_METHOD = "collectAllLog";
    private static final String ONE_DAY_HIS_PERFORMANCE_KEY = "hisperformance";
    private static final int NUM_6 = 6;
    private static CollectDataContext context = CollectDataContext.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectTask.class);
    private CollectInfo collectInfo = null;
    private Map<String, Object> collectEnv = new HashMap<String, Object>();
    private DevNode devNode;
    private List<ScriptItem> executeScripts = new ArrayList<ScriptItem>();
    private String scriptPath = "";
    private CollectStatus nowStatus = CollectStatus.COLLECT_FAILED;
    private boolean allSucc = true;
    private IUiObserver progressObserver;
    private InfocollectUserOpData userOpData = null;
    private JSONObject failedMsg = new JSONObject();
    private ExtendedSshConnectionQueue queue;
    private boolean hasQueue = false;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Map<String, Future<Boolean>> concurrentResult = new HashMap<String, Future<Boolean>>();
    private List<String> collectNodes = new ArrayList<String>();
    private boolean isCollectSmartByQuicklyScene = false;

    public CollectTask(CollectInfo collectInfo, DevNode devNode) {
        this.collectInfo = collectInfo;
        this.devNode = devNode;
        this.scriptPath = InfoConfiguration.getInstance().getPackageScriptPath(collectInfo.getDevNode());
    }

    public CollectTask(CollectInfo collectInfo, DevNode devNode, IUiObserver progressObserver) {
        this(collectInfo, devNode);
        this.progressObserver = progressObserver;
    }

    public IUiObserver getProgressObserver() {
        return this.progressObserver;
    }

    public void setProgressObserver(IUiObserver progressObserver) {
        this.progressObserver = progressObserver;
    }

    @Override
    public final boolean init() {
        boolean isArchive;
        ExecuteResult result = this.getExecuteScript();
        boolean bl = isArchive = null != CollectDataContext.getInstance().getRetHandler();
        if (isArchive) {
            this.collectInfo.setCollecting();
            return true;
        }
        if (result.isSuccess()) {
            result = this.isCollecting();
        }
        return result.isSuccess();
    }

    private ExecuteResult createCollectEnv() {
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(this.collectInfo, false);
        this.observeExecuteResult(command.getProcessingResult());
        ExecuteResult result = command.process();
        if (!CollectDataContext.getInstance().isStartCollect()) {
            result.setResult(false);
            return result;
        }
        if (result.isSuccess()) {
            this.collectEnv = command.getCollectEnv();
        }
        this.observeExecuteResult(result);
        return result;
    }

    private ExecuteResult getExecuteScript() {
        GainExecuteScriptCommand command = new GainExecuteScriptCommand(this.collectInfo);
        ExecuteResult result = command.process();
        if (result.isSuccess()) {
            this.executeScripts = command.getExecuteScripts();
        }
        this.observeExecuteResult(result);
        return result;
    }

    private ExecuteResult isCollecting() {
        DevNode dev = this.collectInfo.getDevNode();
        CheckCollectingCommand command = new CheckCollectingCommand(dev);
        ExecuteResult result = command.process();
        if (result.isSuccess()) {
            this.collectInfo.setCollecting();
        } else {
            result.setProgress(100);
        }
        this.observeExecuteResult(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InfoCollectLock.getInstance().tryLock(this.devNode.getDeviceSerialNumber());
        boolean collectResult = true;
        boolean createCollectEnvResult = true;
        this.initDeviceUserData();
        try {
            CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(false);
            ExecuteResult result = this.createCollectEnv();
            if (!result.isSuccess()) {
                createCollectEnvResult = false;
                SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "failed", "finished", result.getDetail());
                context.putSilentProgress(this.devNode, 100);
                context.updateSilentResult(this.devNode, data);
                return;
            }
            if (!this.doCollectJob()) {
                collectResult = false;
                SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "failed", "finished", this.failedMsg.toString());
                context.putSilentProgress(this.devNode, 100);
                context.updateSilentResult(this.devNode, data);
                LOGGER.info("do collect job failed.");
                return;
            }
            this.decompress();
        }
        catch (Exception e) {
            LOGGER.error("execute collect error.", (Throwable)e);
            this.handleException();
        }
        finally {
            this.cleanResource(createCollectEnvResult, collectResult);
            InfoCollectLock.getInstance().unLock(this.devNode.getDeviceSerialNumber());
        }
    }

    private void cleanResource(boolean createCollectEnvResult, boolean collectResult) {
        this.doCleanJob(createCollectEnvResult, collectResult);
        if (CollectUIContext.getInstance().getMainDialog() != null) {
            CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
        }
        this.clearAllLogsItem();
        Context.INS.uninstallAutoImportPatch(this.devNode, DstoragePatchInfo.Type.COLLECT, null);
    }

    private void handleException() {
        ExecuteResult result = new ExecuteResult();
        result.setPyResult(true);
        result.setResult(false);
        result.setNowStatus(CollectStatus.COLLECT_FAILED);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.postCollect"));
        result.setDetail(ResourceUtil.getString((String)"infocollect.detail.postCollect.remind"));
        this.observeExecuteResult(result);
    }

    private void decompress() {
        if (InfoCollectUtil.isEosProducts(this.devNode)) {
            LOGGER.info("is eos products. go to old flow.");
            InfoCollectUtil.decompressThenCopyDirRecompressAndClear(this.collectEnv, this.devNode);
        }
        InfoCollectUtil.upload(this.devNode, this.collectEnv);
        SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "", "running", "");
        context.putSilentProgress(this.devNode, context.calcProgressCollecting(1, 1));
        context.updateSilentResult(this.devNode, data);
    }

    private void clearAllLogsItem() {
        if (!this.isCollectSmartByQuicklyScene) {
            return;
        }
        List<CollectItem> items = this.collectInfo.getCollectConfInfo().getSelectItems();
        items.remove(items.size() - 1);
    }

    private void initDeviceUserData() {
        List<InfocollectUserOpData> userOpList = CollectDataContext.getInstance().getUserOpList();
        this.userOpData = new InfocollectUserOpData();
        this.userOpData.setDevNode(EntityUtils.toNewDev((DevNode)this.devNode));
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(this.devNode);
        if (conf == null) {
            LOGGER.info("get collectConf is null,set userOpData failed!");
            return;
        }
        List<CollectItem> items = conf.getAllCollectItems();
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        if (items.size() > selectItems.size()) {
            this.userOpData.setCollectNodeType(CollectNodeType.NODE);
        }
        if (conf.isEnableDate()) {
            this.userOpData.setCollectTimeType(CollectTimeType.TIME);
        }
        userOpList.add(this.userOpData);
        InfoCollectUtil.clearTempTimeData(this.devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCollectJob() {
        long startTime = System.currentTimeMillis();
        this.collectEnv.put(DURATION_START_TIME, startTime);
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        this.checkItemAndChangeEnv();
        this.checkCollectSceneAndChangeEnv(selectItems);
        this.checkAllLogsItem(selectItems);
        this.mergeDepthCollectItems(selectItems);
        selectItems = this.mergeItems(selectItems);
        PythonCommand command = null;
        try {
            command = new PythonCommand(this.collectEnv, this.scriptPath);
            boolean result = this.collect(selectItems, command);
            LOGGER.info("check collect item return: {}", (Object)result);
            InfoCollectUtil.writeTime(startTime, ResourceUtil.getString((String)"infocollect.collect.task.all.item.collection.duration"), this.devNode.getDeviceSerialNumber());
            boolean bl = result;
            return bl;
        }
        finally {
            if (null != command) {
                command.clearUp();
            }
        }
    }

    private void mergeDepthCollectItems(List<CollectItem> selectItems) {
        if (!this.isDepthCollect()) {
            log.info("Not in-depth problem analysis scenarios.");
            return;
        }
        List<String> depthCollectItemsName = this.getDepthCollectItemsName(selectItems);
        if (depthCollectItemsName.size() <= 1) {
            log.info("In-depth problem analysis does not contain concurrent collection items.");
            return;
        }
        this.executeScripts = this.executeScripts.stream().flatMap(item -> this.handleScriptItem(depthCollectItemsName, (ScriptItem)item).stream()).collect(Collectors.toList());
        this.collectEnv.put("isConcurrentDepthCollect", true);
        this.collectEnv.put("depthCollectItemsName", depthCollectItemsName);
        this.collectEnv.put("resultInfoMap", this.getResultInfoMap(depthCollectItemsName));
    }

    private Map<String, Map<String, Object>> getResultInfoMap(List<String> depthCollectItemsName) {
        return depthCollectItemsName.stream().collect(Collectors.toMap(name -> name, name -> new HashMap()));
    }

    @NotNull
    private List<String> getDepthCollectItemsName(List<CollectItem> selectItems) {
        return selectItems.stream().map(CollectItem::getId).filter(id -> !Objects.equals(id, "cli")).collect(Collectors.toList());
    }

    private List<ScriptItem> handleScriptItem(List<String> depthCollectItemsName, ScriptItem scriptItem) {
        log.info("The scriptItem step is : {}", (Object)scriptItem.getStep());
        ArrayList<ScriptItem> newScriptItems = new ArrayList<ScriptItem>();
        if (Objects.equals(scriptItem.getStep(), PRE_COLLECT)) {
            newScriptItems.add(scriptItem);
            newScriptItems.add(this.getNewScriptItem(depthCollectItemsName));
            return newScriptItems;
        }
        if (TaskCons.ALL_DEPTH_COLLECT_CONCURRENT_ITEM.contains(scriptItem.getStep())) {
            return newScriptItems;
        }
        newScriptItems.add(scriptItem);
        return newScriptItems;
    }

    private ScriptItem getNewScriptItem(List<String> depthCollectItemsName) {
        ScriptItem item = new ScriptItem();
        item.setConcurrentDepthCollect(true);
        item.setDepthCollectConcurrentItemsName(depthCollectItemsName);
        item.setKeepOn(true);
        item.setScriptFileName(String.join((CharSequence)File.separator, this.scriptPath, "depth_concurrent_items_collect.py"));
        item.setMainMethod("depth_concurrent_collect");
        item.setStep("depth_concurrent");
        item.setDescriptionKey(ResourceUtil.getString((String)"depth.collect.item.description"));
        item.setType(ScriptType.DATA_COLLECT);
        return item;
    }

    private boolean isDepthCollect() {
        return this.collectInfo.getCollectConfInfo().isDepthCollect() && this.canConcurrentDepthCollectVersionAndModel();
    }

    private boolean canConcurrentDepthCollectVersionAndModel() {
        String version;
        String model = this.devNode.getDeviceType().toString();
        return this.isConcurrentDepthCollectDoradoDev(model, version = this.devNode.getProductVersion()) || this.isConcurrentDepthCollectMicroDev(model, version) || this.isConcurrentDepthCollectOceanProtectDev(model, version);
    }

    private boolean isConcurrentDepthCollectOceanProtectDev(String model, String version) {
        return Products.isOceanProtectDev((String)model) && Products.compareVersion((String)version, (String)"1.5.RC1") >= 0;
    }

    private boolean isConcurrentDepthCollectMicroDev(String model, String version) {
        return Products.isOceanStorMicroDev((String)model) && Products.compareVersion((String)version, (String)"1.2.RC1") >= 0;
    }

    private boolean isConcurrentDepthCollectDoradoDev(String model, String version) {
        return TaskCons.DORADO_AND_NEW_DORADO_MODEL.contains(model) && Products.compareVersion((String)version, (String)"6.1.7RC1") >= 0;
    }

    private List<CollectItem> mergeItems(List<CollectItem> selectItems) {
        if (!InfoCollectUtil.isNewOceanStor9000(this.devNode) || !CollectDataContext.getInstance().isForeground()) {
            log.info("Not the specified OceanStor 9000 device.");
            return selectItems;
        }
        ArrayList<CollectItem> newSelectItems = new ArrayList<CollectItem>();
        ArrayList<String> modesList = new ArrayList<String>();
        this.mergeSelectItems(selectItems, newSelectItems, modesList);
        this.mergeExecuteScripts();
        this.saveSettingInfo(modesList);
        return newSelectItems;
    }

    private void saveSettingInfo(List<String> modesList) {
        List<String> nodeIds = this.getCollectNodesIds(this.collectInfo.getCollectConfInfo().getSelectNodes());
        Map settingInfo = (Map)this.collectEnv.get("SettingInfo");
        settingInfo.put("nodeid", String.join((CharSequence)",", nodeIds));
        settingInfo.put("modeList", new JList<String>(modesList.toArray(new String[0])).getModel());
        this.collectEnv.put("SettingInfo", settingInfo);
    }

    private void mergeSelectItems(List<CollectItem> selectItems, List<CollectItem> newSelectItems, List<String> modesList) {
        for (CollectItem item : selectItems) {
            if (!this.is9000Moudle(item)) {
                newSelectItems.add(item);
                continue;
            }
            modesList.add(item.getNameKey());
            if (!newSelectItems.stream().noneMatch(this::is9000Moudle)) continue;
            newSelectItems.add(item);
        }
        log.info("modesList is {}", modesList);
    }

    private boolean is9000Moudle(CollectItem item) {
        return TaskCons.OCEAN_STOR_9000_ALL_MODULES.contains(item.getNameKey());
    }

    private void mergeExecuteScripts() {
        ArrayList<ScriptItem> newExecuteScripts = new ArrayList<ScriptItem>();
        String description = ResourceUtil.getString((String)"collect_fault_scenarios.desc");
        for (ScriptItem scriptItem : this.executeScripts) {
            if (!scriptItem.getDescriptionKey().equals(description)) {
                newExecuteScripts.add(scriptItem);
                continue;
            }
            if (!newExecuteScripts.stream().noneMatch(item -> item.getDescriptionKey().equals(description))) continue;
            newExecuteScripts.add(scriptItem);
        }
        this.executeScripts.clear();
        this.executeScripts.addAll(newExecuteScripts);
    }

    private void checkAllLogsItem(List<CollectItem> selectItems) {
        if (selectItems.stream().noneMatch(item -> item.getId().equals("all_logs"))) {
            return;
        }
        this.collectEnv.put("collectAllLogs", true);
    }

    private void checkCollectSceneAndChangeEnv(List<CollectItem> selectItems) {
        CollectConfInfo info = this.collectInfo.getCollectConfInfo();
        if (!InfoCollectUtil.isSupportCollectedByScene(this.devNode) || !info.isCollectByNodes()) {
            return;
        }
        if (info.isQuicklyCollect() && !Utils.isNullList(info.getSelectedExpansionModuleIds())) {
            this.isCollectSmartByQuicklyScene = true;
            this.collectEnv.put("collectSmartByQuicklyScene", true);
            this.createAllLogItem(selectItems);
        }
        this.collectEnv.put("collectByNodes", true);
        this.collectEnv.put("modulesIds", String.join((CharSequence)",", info.getSelectedExpansionModuleIds()));
        this.collectEnv.put("controllerIds", String.join((CharSequence)",", info.getSelectedControllerNodeIds()));
    }

    @NotNull
    private List<String> getCollectNodesIds(List<TableRow> nodes) {
        return nodes.stream().map(node -> {
            if (node.getValueAt(0) instanceof String) {
                return (String)node.getValueAt(0);
            }
            return "";
        }).collect(Collectors.toList());
    }

    private void createAllLogItem(List<CollectItem> selectItems) {
        this.creatAllLogsScriptItem();
        this.creatAllLogsCollectItem(selectItems);
    }

    private void creatAllLogsCollectItem(List<CollectItem> selectItems) {
        CollectItem collectItem = new CollectItem("all_log");
        collectItem.setModuleId(ITEM_MODEL_ID);
        collectItem.setNameKey(ResourceUtil.getString((String)ITEM_ALL_LOG));
        collectItem.setEnNameKey(ITEM_ALL_LOG);
        int size = selectItems.size();
        selectItems.add(size, collectItem);
    }

    private void creatAllLogsScriptItem() {
        int index = this.executeScripts.indexOf(this.executeScripts.stream().filter(i -> i.getStep().equals(LOG)).findFirst().get());
        ScriptItem allLogItem = new ScriptItem();
        allLogItem.setMainMethod(ITEM_METHOD);
        allLogItem.setScriptFileName(this.executeScripts.get(index).getScriptFileName());
        allLogItem.setDescriptionKey(ResourceUtil.getString((String)"collect.smart.disk.enclosure.desc"));
        allLogItem.setType(ScriptType.DATA_COLLECT);
        allLogItem.setStep("all_log");
        allLogItem.setKeepOn(true);
        this.executeScripts.add(index + 1, allLogItem);
    }

    private void checkItemAndChangeEnv() {
        if (this.executeScripts.stream().anyMatch(item -> item.getStep().equals("container_log") || item.getStep().equals("container_event")) && LicenseFeatureQueryUtil.hasCloudBackupFeature((DevNode)this.devNode)) {
            this.collectEnv.put("license", "cloudBackup");
        }
    }

    private List<ScriptItem> getexecuteConcurrentScripts() {
        ArrayList<ScriptItem> executeConcurrentScripts = new ArrayList<ScriptItem>();
        for (ScriptItem item : this.executeScripts) {
            if (!item.isConcurrent()) continue;
            executeConcurrentScripts.add(item);
        }
        return executeConcurrentScripts;
    }

    private void checkAndChangeItemConcurrentFlag(List<CollectItem> selectItems) {
        selectItems.stream().filter(item -> item.isConcurrent()).forEach(item -> this.changeScriptItemNeedConcurrent(item.getId()));
    }

    private void changeScriptItemNeedConcurrent(String item) {
        this.executeScripts.stream().filter(scriptitem -> scriptitem.getStep().equals(item)).forEach(scriptitem -> scriptitem.setConcurrent(true));
    }

    private boolean collect(List<CollectItem> selectItems, PythonCommand command) {
        boolean preResult = true;
        String preStepId = "";
        this.checkAndChangeItemConcurrentFlag(selectItems);
        List<ScriptItem> executeConcurrentScripts = this.getexecuteConcurrentScripts();
        AtomicInteger failedDataItemCount = new AtomicInteger(0);
        int dataItemCount = this.countDataItemNum();
        int length = this.executeScripts.size();
        for (int index = 0; index < length; ++index) {
            ScriptItem item = this.executeScripts.get(index);
            if (item.isConcurrent()) continue;
            InfocollectUserOpData.Item4UserData item4UserData = this.userOpData.newItem();
            CollectItem collectItem = this.findCollectItem(selectItems, item);
            item4UserData.setItem(collectItem);
            item4UserData.setItemType(item.getType());
            if (this.breakItemCheck(item, dataItemCount, failedDataItemCount.intValue())) {
                return false;
            }
            if (this.continueItemCheck(preResult, item, preStepId)) continue;
            if (item.isNeedCheck()) {
                this.waitConcurrentTaskFinish();
                this.recollect(executeConcurrentScripts, command, failedDataItemCount);
            }
            Long startTime = System.currentTimeMillis();
            ExecuteResult result = this.collectAndRecordTime(command, item);
            item4UserData.setExecuteSuccess(result.isSuccess());
            item4UserData.setCostTime(System.currentTimeMillis() - startTime);
            this.updatePro();
            if (!this.postItemHandle(result, item, failedDataItemCount)) {
                return false;
            }
            this.recordItemUserData(item4UserData);
            preStepId = item.getStep();
            preResult = result.isSuccess();
            if (!preStepId.equals(PRE_COLLECT) || !preResult || executeConcurrentScripts.isEmpty()) continue;
            this.startConcurrentTasks(executeConcurrentScripts, command, length);
        }
        this.userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        this.nowStatus = this.checkResultStatus(failedDataItemCount.intValue(), dataItemCount, preResult);
        String collectRet = this.collectEnv.get("collectRetDir") + File.separator + this.collectEnv.get("collectRetFileName");
        this.addDescResult(ResourceUtil.getStringWithParams((String)"infocollect.detail.collectcommandfinish", (Object[])new Object[]{collectRet}));
        InfoCollectCache.getInstance().saveCollectResultFile(this.devNode.getDeviceSerialNumber(), collectRet);
        LOGGER.info("collect job success.");
        return true;
    }

    private void recollect(List<ScriptItem> executeConcurrentScripts, PythonCommand command, AtomicInteger failedDataItemCount) {
        if (this.executeScripts.stream().anyMatch(item -> item.isConnectSshFail())) {
            for (ScriptItem item2 : executeConcurrentScripts) {
                ExecuteResult result = this.collectAndRecordTime(command, item2);
                this.postItemHandle(result, item2, failedDataItemCount);
            }
        }
    }

    private void waitConcurrentTaskFinish() {
        for (Map.Entry<String, Future<Boolean>> entry : this.concurrentResult.entrySet()) {
            try {
                Boolean result2 = entry.getValue().get();
                LOGGER.info("{} task result is : {}", (Object)entry.getKey(), (Object)result2);
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("get concurrent task result error", (Throwable)e);
            }
        }
        if (this.hasQueue && this.queue.getNowSshConSize() != 0) {
            this.queue.clean();
        }
        if (this.collectInfo.getExecuteResults().stream().anyMatch(result -> !result.isCollectAllInfo())) {
            this.allSucc = false;
        }
    }

    private void startConcurrentTasks(List<ScriptItem> executeConcurrentScripts, PythonCommand command, int size) {
        int resultCount = InfoCollectService.getInstance().getExecuteResults(this.devNode).size();
        this.queue = new ExtendedSshConnectionQueue(this.devNode);
        this.hasQueue = true;
        for (ScriptItem concurrentItem : executeConcurrentScripts) {
            concurrentItem.setSize(size);
            ConcurrentCollectTask task = new ConcurrentCollectTask(concurrentItem, command, this.devNode, this.collectInfo, this.userOpData, this.queue);
            this.concurrentResult.put(concurrentItem.getDescriptionKey(), this.executorService.submit(task));
        }
        while (InfoCollectService.getInstance().getExecuteResults(this.devNode).size() < resultCount + executeConcurrentScripts.size()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("wait concurrent task start error.", (Throwable)e);
            }
            if (this.executeScripts.stream().filter(item -> item.isConnectSshFail()).count() <= 0L) continue;
            break;
        }
    }

    private int countDataItemNum() {
        int count = 0;
        String preStep = "";
        for (ScriptItem item : this.executeScripts) {
            if (!ScriptType.DATA_COLLECT.equals((Object)item.getType()) || preStep.equals(item.getStep())) continue;
            ++count;
            preStep = item.getStep();
        }
        return count;
    }

    private ExecuteResult collectAndRecordTime(PythonCommand command, ScriptItem item) {
        long startTime = System.currentTimeMillis();
        ExecuteResult result = this.collecting(command, item);
        InfoCollectUtil.writeTime(startTime, item.getStep(), this.devNode.getIp());
        return result;
    }

    private ExecuteResult collecting(PythonCommand command, ScriptItem item) {
        boolean isHostInfoCollectItem;
        int progress = item.getStep().equals("cli") && !this.concurrentResult.isEmpty() ? InfoCollectUtil.computeProgress(this.executeScripts.size() - 1, this.executeScripts.size()) : InfoCollectUtil.computeProgress(this.executeScripts.indexOf(item) + 2, this.executeScripts.size());
        if (Objects.nonNull(this.devNode.getPriKey()) && item.getStep().equals(ONE_DAY_HIS_PERFORMANCE_KEY)) {
            return this.createNoSupportResult(progress, item);
        }
        command.setScriptItem(item);
        command.setProgress(progress);
        ExecuteResult processingResult = command.newProcessingResult();
        boolean isRunningDiskLogItem = DISK_LOG_NORMAL.equals(item.getStep());
        if (isRunningDiskLogItem) {
            this.switchDiskLogStopAndSetupHyperLink(command, true, processingResult);
        }
        processingResult.setItem(item);
        this.observeExecuteResult(processingResult);
        ExecuteResult result = command.process();
        if (isRunningDiskLogItem) {
            this.switchDiskLogStopAndSetupHyperLink(command, false, result);
            processingResult.setNowStatus(CollectStatus.COLLECT_STOPPED);
            this.recordDiskLogCltResult();
        }
        if (isHostInfoCollectItem = "host_info".equals(item.getStep())) {
            this.handleHostInfoCollectUserData();
        }
        return result;
    }

    ExecuteResult createNoSupportResult(int progress, ScriptItem item) {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(progress);
        result.setDescription(item.getDescriptionKey());
        result.setItem(item);
        result.setResult(false);
        result.setDetail(ResourceUtil.getString((String)"infocollect.hisperformance.not.support.publicKey"));
        return result;
    }

    private void handleHostInfoCollectUserData() {
        Map hostInfoResultMap = this.collectEnv.getOrDefault("result_dict", Collections.emptyMap());
        if (hostInfoResultMap.isEmpty()) {
            return;
        }
        Integer successCollectedHostNum = hostInfoResultMap.getOrDefault("success", Collections.emptyList()).size();
        Integer supportCollectedHostNum = hostInfoResultMap.getOrDefault("should_collect_host_num", 0);
        if (0 != successCollectedHostNum) {
            this.userOpData.setSuccessHostNum(successCollectedHostNum);
        }
        if (0 != supportCollectedHostNum) {
            this.userOpData.setSupportCollectHostNum(supportCollectedHostNum);
        }
    }

    private void recordItemUserData(InfocollectUserOpData.Item4UserData item) {
        Object obj;
        if (!ScriptType.DATA_COLLECT.equals((Object)item.getItemType())) {
            return;
        }
        CollectItem collectItem = item.getItem();
        if (!this.userOpData.getCollectItems().contains(collectItem.getNameKey())) {
            this.userOpData.setCollectItems(this.userOpData.getCollectItems() + collectItem.getNameKey() + ";");
        }
        if (!item.isExecuteSuccess()) {
            this.userOpData.setFailedItems(collectItem);
        }
        Map dynamicAttr = this.userOpData.getDynamicAttr();
        String enNameKey = collectItem.getEnNameKey();
        Long time = item.getCostTime();
        if (dynamicAttr.containsKey(enNameKey) && (obj = dynamicAttr.get(enNameKey)) instanceof Long) {
            time = (Long)obj + time;
        }
        dynamicAttr.put(enNameKey, time);
    }

    private CollectItem findCollectItem(List<CollectItem> collectItems, ScriptItem item) {
        String id = item.getStep();
        for (CollectItem collectItem : collectItems) {
            if (!id.equals(collectItem.getId())) continue;
            return collectItem;
        }
        return new CollectItem();
    }

    private boolean postItemHandle(ExecuteResult result, ScriptItem item, AtomicInteger failedDataItemCount) {
        if (!result.isCollectAllInfo()) {
            this.allSucc = false;
        }
        this.observeExecuteResult(result);
        context.putSilentProgress(this.devNode, context.calcProgressCollecting(this.executeScripts.indexOf(item) + 1, this.executeScripts.size()));
        context.updateSilentResult(this.devNode, new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "", "running", ""));
        this.checkConnection();
        if (result.isSuccess()) {
            return true;
        }
        this.failedMsg.put(result.getDescription(), (Object)result.getDetail());
        if (!ScriptType.DATA_COLLECT.equals((Object)item.getType())) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            LOGGER.info(String.format(Locale.ROOT, "collect failed, mark2, item: %s", item.getStep()));
            return false;
        }
        failedDataItemCount.set(failedDataItemCount.intValue() + 1);
        return true;
    }

    private boolean continueItemCheck(boolean preResult, ScriptItem item, String stepId) {
        if (!ScriptType.DATA_COLLECT.equals((Object)item.getType())) {
            return false;
        }
        if (preResult) {
            return false;
        }
        if (item.getStep().equals(stepId)) {
            return true;
        }
        return !item.isKeepOn();
    }

    private boolean breakItemCheck(ScriptItem item, int dataItemCount, int failedDataItemCount) {
        if (!CollectDataContext.getInstance().isStartCollect()) {
            LOGGER.info("is start collect: false.");
            return true;
        }
        if (!ScriptType.DATA_COLLECT.equals((Object)item.getType()) && dataItemCount != 0 && failedDataItemCount == dataItemCount) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            LOGGER.info(String.format(Locale.ROOT, "collect failed, mark1, item: %s", item.getStep()));
            return true;
        }
        return false;
    }

    private void switchDiskLogStopAndSetupHyperLink(PythonCommand command, boolean isDiskLogItemStart, ExecuteResult processingResult) {
        String identifier = this.devNode.getDeviceSerialNumber() + this.devNode.getDeviceType();
        TableRow devRow = CollectUIContext.getInstance().getMainDialog().getInfoCollectMainLayout().getDeviceTableModel().getTableRowBy((Object)identifier);
        InfoCollectMainDialog mainDialog = CollectUIContext.getInstance().getMainDialog();
        Map<String, Object> pyJavaEnv = command.getEnv();
        IsmTableCell.HyperlinkCell functionHyperLinkCell = null;
        functionHyperLinkCell = isDiskLogItemStart ? new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infocollect.stop"), new DeviceStopIcon(this.devNode, mainDialog, pyJavaEnv, processingResult).getAction()) : new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infocollect.setup"), new DeviceSetupIcon(this.devNode, mainDialog).getAction());
        if (StartParamContext.isWeb()) {
            return;
        }
        if (null != devRow) {
            devRow.setValueAt(6, (Object)functionHyperLinkCell);
        }
        CollectUIContext.getInstance().getMainDialog().getInfoCollectMainLayout().getDeviceTableModel().updateRow(new TableRow[]{devRow});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordDiskLogCltResult() {
        RandomAccessFile ranFile = null;
        try {
            String localPath = (String)this.collectEnv.get("collectRetDir");
            File normlDiskClctResult = new File(localPath);
            File nmlDiskLgResult = FileAssistant.recursivelyGet1stTargetFile((File)normlDiskClctResult, (String)RUNNING_DISK_LOG_RESLT);
            if (nmlDiskLgResult == null) {
                return;
            }
            HashMap<String, String> normlDiskRecord = new HashMap<String, String>();
            try {
                ranFile = new RandomAccessFile(nmlDiskLgResult, "r");
                String recordLine = null;
                while ((recordLine = ranFile.readLine()) != null) {
                    String[] currntRecord = recordLine.split("=");
                    if (currntRecord == null || currntRecord.length < 1) continue;
                    normlDiskRecord.put(currntRecord[0].trim(), currntRecord[1].trim());
                }
            }
            catch (Exception e) {
                LOGGER.info("exception occurred while parsing running disk log ", (Throwable)e);
            }
            this.userOpData.setAllDiskNum((String)normlDiskRecord.get("allDiskNum"));
            this.userOpData.setSelectedDiskLogNum((String)normlDiskRecord.get("selectedDisk"));
            this.userOpData.setSucceedDiskLogNum((String)normlDiskRecord.get("success"));
            this.userOpData.setPartlySuccDiskLgNum((String)normlDiskRecord.get("partly success"));
            this.userOpData.setFailedDiskLogNum((String)normlDiskRecord.get("failed"));
            this.userOpData.setUnsupportedDiskLogNum((String)normlDiskRecord.get("unsupported"));
        }
        catch (Exception e) {
            LOGGER.error("error occurred while parsing user operation data");
            return;
        }
        finally {
            try {
                if (null != ranFile) {
                    ranFile.close();
                }
            }
            catch (IOException e) {
                LOGGER.info(" IO exception", (Throwable)e);
            }
        }
    }

    private void updatePro() {
        if (null != this.progressObserver) {
            this.progressObserver.update();
        }
    }

    private CollectStatus checkResultStatus(int failedItems, int collectItems, boolean preResult) {
        if (failedItems != 0 && failedItems < collectItems) {
            this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
            return CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        if (!preResult) {
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            return CollectStatus.COLLECT_FAILED;
        }
        this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        return CollectStatus.COLLECT_FINISHED;
    }

    private void checkConnection() {
        if (!CollectDataContext.getInstance().isStartCollect()) {
            return;
        }
        try {
            Object sshObject = this.collectEnv.get("SSH");
            Object sftpObject = this.collectEnv.get("SFTP");
            if (null != sshObject) {
                this.checkSshConnection(sshObject, sftpObject);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).info("recont error. ", (Object)e.getMessage());
        }
    }

    private void checkSshConnection(Object sshObject, Object sftpObject) throws ToolException {
        SshConnection conn = (SshConnection)sshObject;
        boolean isConnect = conn.isConnected();
        LoggerFactory.getLogger(this.getClass()).info("Check connection : isConnected = " + isConnect);
        if (!isConnect) {
            conn.reConnect();
            CollectDataContext.getInstance().getTempProtocols().addProtocol(this.devNode, conn);
            if (null != sftpObject) {
                SftpTransporter sftp = (SftpTransporter)sftpObject;
                sftp.close();
                CollectDataContext.getInstance().getTempProtocols().addProtocol(this.devNode, this.createSftpConn(conn, this.devNode));
            }
        }
    }

    protected Object createSftpConn(SshConnection conn, DevNode devNode) {
        SFTPProtocolItem protocolItem = new SFTPProtocolItem();
        protocolItem.setConnection(conn);
        Object newSftp = protocolItem.createProtocolObject(devNode);
        this.collectEnv.put("SFTP", newSftp);
        return newSftp;
    }

    private void addDescResult(String msg) {
        DescCommand collectOverCommand = new DescCommand(msg, true);
        ExecuteResult result = collectOverCommand.process();
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result.setProgress(92);
        this.observeExecuteResult(result);
    }

    private void doCleanJob(boolean createCollectEnvResult, boolean collectResult) {
        String collectRet = this.collectEnv.get("collectRetDir") + File.separator + this.collectEnv.get("collectRetFileName");
        this.collectInfo.setCollectRetFilePath(collectRet);
        if (collectResult) {
            FileUtils.setFilePermissions((File)new File(collectRet));
        }
        if (!CollectDataContext.getInstance().isStartCollect()) {
            return;
        }
        ClearCollectEnvCommand command = new ClearCollectEnvCommand(this.collectInfo.getDevNode(), this.collectInfo);
        ExecuteResult result = command.process();
        this.observeExecuteResult(result);
        boolean programResult = createCollectEnvResult && collectResult;
        DescCommand descCommand = new DescCommand(this.getCollectOverDesc(), programResult, this.collectInfo, Color.RED);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result = descCommand.process();
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        if (CollectStatus.COLLECT_FINISHED.equals((Object)this.nowStatus) && !this.allSucc) {
            this.nowStatus = CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        result.setNowStatus(this.nowStatus);
        if (!createCollectEnvResult || !collectResult) {
            CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(true);
        }
        this.observeExecuteResult(result);
    }

    String getCollectOverDesc() {
        String deviceType = this.devNode.getDeviceType().toString();
        if (TaskCons.DEVICES_MODEL_WITHOUT_SPLIT_PROMPTS.contains(deviceType)) {
            log.info("Device type is {}. no split prompt description...", (Object)deviceType);
            return ResourceUtil.getString((String)"lld.collect.finished");
        }
        if (InfoCollectUtil.isSupportA800Scene()) {
            log.info("The current scenario is the A800 scenario. no split prompt description...");
            return ResourceUtil.getString((String)"lld.collect.finished");
        }
        return ResourceUtil.getString((String)"infocollect.detail.collectover");
    }

    private void observeExecuteResult(ExecuteResult result) {
        if (result == null) {
            return;
        }
        result.setDevNode(this.collectInfo.getDevNode());
        CollectDataContext.getInstance().getCollectInfo(this.devNode).addExecuteResult(result);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(this.devNode);
    }

    @Override
    public JSONObject getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(JSONObject failedMsg) {
        this.failedMsg = failedMsg;
    }
}

