/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.SFTPProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.logic.ConcurrentCollect;
import com.huawei.ism.tool.infocollect.service.logic.ExtendedSshConnectionQueue;
import com.huawei.ism.tool.infocollect.service.logic.command.PythonCommand;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.json.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectTask
implements ConcurrentCollect {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentCollectTask.class);
    private static CollectDataContext context = CollectDataContext.getInstance();
    private ScriptItem item;
    private PythonCommand command;
    private DevNode devNode;
    private ExtendedSshConnectionQueue queue;
    private CollectInfo collectInfo;
    private InfocollectUserOpData userOpData;
    private Map<String, Object> env = new HashMap<String, Object>();
    private JSONObject failedMsg = new JSONObject();

    public ConcurrentCollectTask(ScriptItem item, PythonCommand command, DevNode devNode, CollectInfo collectInfo, InfocollectUserOpData userOpData, ExtendedSshConnectionQueue queue) {
        String scriptPath = InfoConfiguration.getInstance().getPackageScriptPath(collectInfo.getDevNode());
        this.env.putAll(command.getEnv());
        PythonCommand concurrentCommand = new PythonCommand(this.env, scriptPath);
        this.item = item;
        this.command = concurrentCommand;
        this.devNode = devNode;
        this.collectInfo = collectInfo;
        this.userOpData = userOpData;
        this.queue = queue;
    }

    @Override
    public Boolean call() {
        Thread.currentThread().setName("Concurrent-Thread-" + this.devNode.getIp());
        this.setOnlyRunningMode(false);
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        InfocollectUserOpData.Item4UserData item4UserData = this.userOpData.newItem();
        CollectItem collectItem = this.findCollectItem(selectItems, this.item);
        item4UserData.setItem(collectItem);
        item4UserData.setItemType(this.item.getType());
        Long startTime = System.currentTimeMillis();
        ExecuteResult result = this.collecting(this.item);
        InfoCollectUtil.writeTime(startTime, this.item.getStep(), this.devNode.getIp());
        if (result == null) {
            log.warn("The result is null.");
            return false;
        }
        this.postItemHandle(result, this.item);
        this.refreshUiTaskResult(result);
        item4UserData.setExecuteSuccess(result.isSuccess());
        item4UserData.setCostTime(System.currentTimeMillis() - startTime);
        this.recordItemUserData(item4UserData);
        this.queue.putSshConnToQueue((SshConnection)this.command.getEnv().get("SSH"));
        SftpTransporter sftp = (SftpTransporter)this.command.getEnv().get("SFTP");
        if (sftp != null) {
            sftp.close();
        }
        this.setOnlyRunningMode(true);
        this.command.clearUp();
        return result.getResult();
    }

    private void refreshUiTaskResult(ExecuteResult result) {
        log.info("{} collect finished. result: {}", (Object)result.getItem().getDescriptionKey(), (Object)result.getResult());
        List<ExecuteResult> executeResults = CollectDataContext.getInstance().getCollectInfo(this.devNode).getExecuteResults();
        Optional<ExecuteResult> needUpdate = executeResults.stream().filter(res -> StringUtils.equals((CharSequence)res.getDescription(), (CharSequence)result.getItem().getDescriptionKey())).findFirst();
        needUpdate.ifPresent(executeResult -> executeResult.setResult(result.getResult()));
    }

    public void setOnlyRunningMode(boolean onlyRunningMode) {
        this.collectInfo.setOnlyRunningMode(onlyRunningMode);
    }

    private boolean postItemHandle(ExecuteResult result, ScriptItem item) {
        this.observeExecuteResult(result);
        context.putSilentProgress(this.devNode, context.calcProgressCollecting(2, item.getSize()));
        if (result.isSuccess()) {
            return true;
        }
        this.failedMsg.put(result.getDescription(), (Object)result.getDetail());
        return true;
    }

    private void recordItemUserData(InfocollectUserOpData.Item4UserData item) {
        Object obj;
        CollectItem collectItem = item.getItem();
        if (!this.userOpData.getCollectItems().contains(collectItem.getNameKey())) {
            this.userOpData.setCollectItems(this.userOpData.getCollectItems() + collectItem.getNameKey() + ";");
        }
        if (!item.isExecuteSuccess()) {
            this.userOpData.setFailedItems(collectItem);
        }
        Map dynamicAttr = this.userOpData.getDynamicAttr();
        String enNameKey = collectItem.getEnNameKey();
        Long time = item.getCostTime();
        if (dynamicAttr.containsKey(enNameKey) && (obj = dynamicAttr.get(enNameKey)) instanceof Long) {
            time = (Long)obj + time;
        }
        dynamicAttr.put(enNameKey, time);
    }

    private CollectItem findCollectItem(List<CollectItem> collectItems, ScriptItem item) {
        String id = item.getStep();
        for (CollectItem collectItem : collectItems) {
            if (!id.equals(collectItem.getId())) continue;
            return collectItem;
        }
        return new CollectItem();
    }

    private ExecuteResult collecting(ScriptItem item) {
        this.command.setScriptItem(item);
        SshConnection ssh = this.getSshConn();
        if (ssh == null) {
            item.setConnectSshFail(true);
            log.warn("Failed to establish the SSH connection. Item step is:" + item.getStep());
            return null;
        }
        this.initPythonEnv(this.command, ssh);
        ExecuteResult processingResult = this.command.newProcessingResult();
        processingResult.setItem(item);
        this.observeExecuteResult(processingResult);
        return this.command.process();
    }

    private void initPythonEnv(PythonCommand command, SshConnection ssh) {
        SFTPProtocolItem protocolItem = new SFTPProtocolItem();
        protocolItem.setConnection(ssh);
        Object sftp = protocolItem.createProtocolObject(this.devNode);
        command.getEnv().put("SFTP", sftp);
        command.getEnv().put("SSH", ssh);
        command.getEnv().put("concurrent", true);
        int progress = InfoCollectUtil.computeProgress(2, this.item.getSize());
        command.setProgress(progress);
    }

    private void observeExecuteResult(ExecuteResult result) {
        if (result == null) {
            return;
        }
        result.setDevNode(this.collectInfo.getDevNode());
        CollectDataContext.getInstance().getCollectInfo(this.devNode).addExecuteResult(result);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(this.devNode);
    }

    private SshConnection getSshConn() {
        try {
            return this.queue.getSshQueueConnection();
        }
        catch (ToolException | InterruptedException exception) {
            log.error("Put into Connection queue error.", exception);
            return null;
        }
    }
}

