/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectSubTask;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import java.util.Map;

public class DStorageModuleCollectTask {
    private String moduleId;
    private ExecuteResult moduleResult;
    private String moduleTaskId;
    private int opcode;
    private volatile int taskProgress;
    private boolean taskFailed = false;
    private int subTaskNum;
    private Map<Integer, RestCollectSubTask> subTaskMap = new KeyOrderedHashMap();
    private boolean hasDownNodeFile = false;

    public DStorageModuleCollectTask(String moduleId, ExecuteResult moduleResult, String moduleTaskId) {
        this.moduleId = moduleId;
        this.moduleResult = moduleResult;
        this.moduleTaskId = moduleTaskId;
    }

    public boolean isHasDownNodeFile() {
        return this.hasDownNodeFile;
    }

    public void setHasDownNodeFile(boolean hasDownNodeFile) {
        this.hasDownNodeFile = hasDownNodeFile;
    }

    public int getSubTaskNum() {
        return this.subTaskNum;
    }

    public void setSubTaskNum(int subTaskNum) {
        this.subTaskNum = subTaskNum;
    }

    public int getTaskProgress() {
        return this.taskProgress;
    }

    public void setTaskProgress(int taskProgress) {
        this.taskProgress = taskProgress;
    }

    public boolean isTaskFailed() {
        return this.taskFailed;
    }

    public void setTaskFailed(boolean taskFailed) {
        this.taskFailed = taskFailed;
    }

    public boolean isModuleCollectFinished() {
        if (this.subTaskNum == 0) {
            return false;
        }
        for (int subTaskId : this.subTaskMap.keySet()) {
            if (this.subTaskMap.get(subTaskId).isFinished()) continue;
            return false;
        }
        return true;
    }

    public boolean atLeastOneNodeSuccess() {
        if (this.subTaskMap.isEmpty()) {
            return false;
        }
        for (int subTaskId : this.subTaskMap.keySet()) {
            RestCollectSubTask subTask = this.subTaskMap.get(subTaskId);
            if (subTask.isFailed()) {
                return false;
            }
            if (!subTask.atLeastOneNodeSuccess()) continue;
            return true;
        }
        return false;
    }

    public boolean atLeastOneNodeFailed() {
        if (this.subTaskMap.isEmpty()) {
            return false;
        }
        for (int subTaskId : this.subTaskMap.keySet()) {
            RestCollectSubTask subTask = this.subTaskMap.get(subTaskId);
            if (subTask.isFailed()) {
                return true;
            }
            if (!this.subTaskMap.get(subTaskId).atLeastOneNodeFailed()) continue;
            return true;
        }
        return false;
    }

    public void updateModuleResult() {
        if (this.subTaskNum == 0) {
            this.moduleResult.setNowStatus(CollectStatus.COLLECTING);
            return;
        }
        if (!this.isModuleCollectFinished()) {
            this.moduleResult.setNowStatus(CollectStatus.COLLECTING);
            return;
        }
        if (this.atLeastOneNodeSuccess() && this.atLeastOneNodeFailed()) {
            this.moduleResult.setNowStatus(CollectStatus.COLLECT_FINISHED_NOTALL);
            this.moduleResult.setCollectAllInfo(false);
            return;
        }
        if (this.atLeastOneNodeSuccess() && !this.atLeastOneNodeFailed()) {
            this.moduleResult.setNowStatus(CollectStatus.COLLECT_FINISHED);
            this.moduleResult.setCollectAllInfo(true);
            return;
        }
        if (!this.atLeastOneNodeSuccess()) {
            this.moduleResult.setNowStatus(CollectStatus.COLLECT_FAILED);
            this.moduleResult.setCollectAllInfo(false);
        }
    }

    public boolean isModuleAllCollectSuccess() {
        if (this.subTaskMap.isEmpty()) {
            return false;
        }
        return !this.atLeastOneNodeFailed();
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public ExecuteResult getModuleResult() {
        return this.moduleResult;
    }

    public void setModuleResult(ExecuteResult moduleResult) {
        this.moduleResult = moduleResult;
    }

    public String getModuleTaskId() {
        return this.moduleTaskId;
    }

    public void setModuleTaskId(String moduleTaskId) {
        this.moduleTaskId = moduleTaskId;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public Map<Integer, RestCollectSubTask> getSubTaskMap() {
        return this.subTaskMap;
    }

    public void setSubTaskMap(Map<Integer, RestCollectSubTask> subTaskMap) {
        this.subTaskMap = subTaskMap;
    }

    public String toString() {
        return this.getModuleId() + ";" + this.getModuleResult().toString();
    }
}

