/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.util.HashMap;
import org.slf4j.LoggerFactory;

public class DevDateTask {
    private static final String DATE_BACK = "date_back";
    private DevNode dev;
    private String scriptPath;

    public DevDateTask(DevNode dev, String scriptPath) {
        this.dev = dev;
        this.scriptPath = scriptPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurDate() {
        JythonExecuter executer = new JythonExecuter(new File(this.scriptPath).getParentFile());
        String date = "";
        SshConnection sshcon = null;
        try {
            sshcon = (SshConnection)SshConnectionManager.getSshConnection((DevNode)this.getStorageDevNode(), null, (boolean)true, (boolean)false);
            HashMap<String, SshConnection> env = new HashMap<String, SshConnection>();
            env.put("SSH", sshcon);
            executer.compileScript(new File(this.scriptPath));
            executer.invokeFunction("execute", env);
            if (null != env.get(DATE_BACK)) {
                date = (String)env.get(DATE_BACK);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DevDateTask.class).error("get device curdate failed.", (Throwable)e);
        }
        finally {
            if (null != sshcon) {
                sshcon.close();
            }
            executer.cleanup();
        }
        return date;
    }

    private DevNode getStorageDevNode() {
        return InfoCollectUtil.isComputeStorageDevLoginThroughFcv(this.dev) ? (DevNode)EntityUtils.convertComputeStorageToOldDevNode((DevNode)this.dev).get(0) : this.dev;
    }
}

