/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.service.logic.DownloadNodeObserver;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.DownFileObserver;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownOneNode
implements Callable<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownOneNode.class);
    private DevNode devNode = null;
    private RestCollectTask task = null;
    private Map<String, Object> reqPara = null;
    private String localPath = null;
    private String nodeIp;
    private List<String> downErrorNodeIpList;
    private DownFileObserver downFileObserver;
    private DownloadNodeObserver downloadNodeObserver;

    public DownOneNode(DevNode devNode, RestCollectTask task, Map<String, Object> reqPara, String localPath, String nodeIp, List<String> downErrorNodeIpList, DownFileObserver downFileObserver, DownloadNodeObserver downloadNodeObserver) {
        this.devNode = devNode;
        this.task = task;
        this.reqPara = reqPara;
        this.localPath = localPath;
        this.nodeIp = nodeIp;
        this.downErrorNodeIpList = downErrorNodeIpList;
        this.downFileObserver = downFileObserver;
        this.downloadNodeObserver = downloadNodeObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() {
        ResponseInfo resp;
        RestConnection conn;
        block8: {
            block7: {
                long statusCode;
                conn = null;
                String infoCollectSubTaskUri = RestUtil.getSubTaskResultFileUri((DevNode)this.devNode);
                conn = this.task.getExtendedConnectionQueue().getRestConnection();
                resp = conn.execGetFile(infoCollectSubTaskUri, this.reqPara, this.localPath, null, this.downFileObserver);
                if (this.task.needReConnResponseCode(conn, resp)) {
                    resp = conn.execGetFile(infoCollectSubTaskUri, this.reqPara, this.localPath, null, this.downFileObserver);
                }
                if (200L == (statusCode = (long)resp.getStatusLine().getStatusCode())) break block7;
                LOGGER.error("query tasks:   failed, and status code is: {}", (Object)statusCode);
                this.downErrorNodeIpList.add(this.nodeIp);
                String string = this.nodeIp;
                this.task.getExtendedConnectionQueue().putConnToQueue(conn);
                this.downloadNodeObserver.oneNodeFinshed(this.downFileObserver);
                return string;
            }
            if (RestCollectTask.downloadFileExist(resp)) break block8;
            LOGGER.error("Result file not exist.");
            this.downErrorNodeIpList.add(this.nodeIp);
            String string = this.nodeIp;
            this.task.getExtendedConnectionQueue().putConnToQueue(conn);
            this.downloadNodeObserver.oneNodeFinshed(this.downFileObserver);
            return string;
        }
        try {
            String filePath = (String)resp.getContentMap().get("filePath");
            this.rename(filePath, this.localPath, this.nodeIp);
            this.task.getExtendedConnectionQueue().putConnToQueue(conn);
            this.downloadNodeObserver.oneNodeFinshed(this.downFileObserver);
        }
        catch (Throwable e) {
            try {
                LOGGER.error("", e);
                this.downErrorNodeIpList.add(this.nodeIp);
                String string = this.nodeIp;
                this.task.getExtendedConnectionQueue().putConnToQueue(conn);
                this.downloadNodeObserver.oneNodeFinshed(this.downFileObserver);
                return string;
            }
            catch (Throwable throwable) {
                this.task.getExtendedConnectionQueue().putConnToQueue(conn);
                this.downloadNodeObserver.oneNodeFinshed(this.downFileObserver);
                throw throwable;
            }
        }
        return "";
    }

    private void rename(String filePath, String localPath, String nodeIP) {
        File file = new File(filePath);
        String newFilePath = localPath + File.separator + this.adaptationIPV6(nodeIP) + "_" + this.getdate() + ".tar.gz";
        file.renameTo(new File(newFilePath));
    }

    private String getdate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    private String adaptationIPV6(String ip) {
        return ip.replace(":", "_");
    }
}

