/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.DownFileObserver;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadNodeObserver
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadNodeObserver.class);
    private static final double D1024 = 1024.0;
    private static final double D1000 = 1000.0;
    private static final int INTERVAL = 1;
    private volatile List<DownFileObserver> downFileObserverList = new ArrayList<DownFileObserver>();
    private UIProgressObserver ui;
    private ExecuteResult downFileTaskResult;
    private volatile boolean taskFinish = false;
    private volatile int downloadNodesNum = 0;
    private long selectnodesNub;
    private long lastSize;
    private final Object lock = new Object();
    private DecimalFormat decimalFormat = new DecimalFormat("#.00");

    public DownloadNodeObserver(UIProgressObserver ui, ExecuteResult downFileTaskResult, long selectnodesNub) {
        this.ui = ui;
        this.downFileTaskResult = downFileTaskResult;
        this.selectnodesNub = selectnodesNub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownFileObserver(DownFileObserver downFileObserver) {
        Object object = this.lock;
        synchronized (object) {
            this.downFileObserverList.add(downFileObserver);
        }
    }

    public void clearDownFileObserverList() {
        this.downFileObserverList = new ArrayList<DownFileObserver>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtaskFinished() {
        Object object = this.lock;
        synchronized (object) {
            this.downFileObserverList = new ArrayList<DownFileObserver>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneNodeFinshed(DownFileObserver downFileObserver) {
        Object object = this.lock;
        synchronized (object) {
            downFileObserver.setFinished(true);
            ++this.downloadNodesNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskFinish(boolean taskFinish) {
        Object object = this.lock;
        synchronized (object) {
            this.taskFinish = taskFinish;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread sleep error");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.taskFinish) {
                    return;
                }
                if (this.downFileObserverList.isEmpty()) {
                    continue;
                }
                long nowDowSize = this.getNowDowSize();
                String info = ResourceUtil.getStringWithParams((String)"completed.nodes.and.download.speed", (Object[])new Object[]{this.downloadNodesNum + "/" + this.selectnodesNub, this.getSpeed(nowDowSize)});
                this.lastSize = nowDowSize;
                this.ui.updateProgress(this.downFileTaskResult, this.getProgress(), "", info);
                long alreadyDownSize = this.downFileObserverList.stream().filter(DownFileObserver::isFinished).mapToLong(DownFileObserver::getFileSize).sum();
                this.lastSize = Math.max(this.lastSize - alreadyDownSize, 0L);
                this.downFileObserverList.removeAll(this.downFileObserverList.stream().filter(DownFileObserver::isFinished).collect(Collectors.toList()));
            }
        }
    }

    private int getProgress() {
        double block = 100.0 / (double)this.selectnodesNub;
        double baseProgress = (double)this.downloadNodesNum * block;
        long fileSize = this.getFileSize();
        if (fileSize == 0L) {
            return (int)baseProgress;
        }
        int progress = (int)(baseProgress + this.downFileObserverList.stream().mapToDouble(downFileObserver -> this.getOneDownloadTaskProgress((DownFileObserver)downFileObserver, block)).sum());
        if (progress >= 100) {
            return 99;
        }
        return progress;
    }

    private double getOneDownloadTaskProgress(DownFileObserver downFileObserver, double block) {
        if (downFileObserver.getFileSize() > 0L) {
            return (double)this.getTaskNowDowSize(downFileObserver) * block / (double)downFileObserver.getFileSize();
        }
        return 0.0;
    }

    private long getNowDowSize() {
        return this.downFileObserverList.stream().mapToLong(downFileObserver -> this.getTaskNowDowSize((DownFileObserver)downFileObserver)).sum();
    }

    private long getTaskNowDowSize(DownFileObserver downFileObserver) {
        if (downFileObserver.getNowDowSize() > downFileObserver.getFileSize()) {
            return downFileObserver.getFileSize();
        }
        return downFileObserver.getNowDowSize();
    }

    private long getFileSize() {
        return this.downFileObserverList.stream().mapToLong(DownFileObserver::getFileSize).sum();
    }

    private String getSpeed(long nowDowSize) {
        double size = (double)nowDowSize - (double)this.lastSize;
        if (size < 1048576.0) {
            return this.formatDouble(size / 1024.0 / 1.0) + "KB/S";
        }
        return this.formatDouble(size / 1024.0 / 1024.0 / 1.0) + "MB/S";
    }

    private String formatDouble(double size) {
        return this.decimalFormat.format(size <= 0.0 ? 0.0 : size);
    }
}

