/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.service.logic.DStorageConfig;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedConnectionQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedConnectionQueue.class);
    private ArrayBlockingQueue<RestConnection> queue = new ArrayBlockingQueue(DStorageConfig.getExtendedConnectionQueueSize());
    private volatile int nowRestConSize = 0;
    private DevNode devNode = null;
    private final Object lock = new Object();

    public ExtendedConnectionQueue(DevNode devNode) {
        this.devNode = devNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestConnection getRestConnection() throws InterruptedException, ToolException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nowRestConSize < DStorageConfig.getExtendedConnectionQueueSize()) {
                RestConnection restCon = new RestConnection(this.devNode, this.devNode.isDsStorage());
                ++this.nowRestConSize;
                this.queue.put(restCon);
            }
        }
        RestConnection restCon = this.queue.take();
        if (!restCon.isLogin()) {
            restCon.login();
        }
        return restCon;
    }

    public void putConnToQueue(RestConnection restCon) {
        try {
            this.queue.put(restCon);
        }
        catch (InterruptedException e) {
            LOGGER.error("Put into restConnection queue eror.", (Throwable)e);
        }
    }

    public void clean() {
        try {
            while (this.queue.size() > 0) {
                RestConnection restCon = this.queue.take();
                restCon.closeSession();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Gut restConnection from queue eror.", (Throwable)e);
        }
        this.nowRestConSize = 0;
    }
}

