/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.service.logic.StorageConfig;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.IpScaleOutSshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedSshConnectionQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedSshConnectionQueue.class);
    private ArrayBlockingQueue<SshConnection> queue = new ArrayBlockingQueue(StorageConfig.getExtendedConnectionQueueSize());
    private volatile int nowSshConSize = 0;
    private DevNode devNode = null;
    private final Object lock = new Object();

    public ExtendedSshConnectionQueue(DevNode devNode) {
        this.devNode = devNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshConnection getSshQueueConnection() throws InterruptedException, ToolException {
        this.devNode.setSshqueue(true);
        Object object = this.lock;
        synchronized (object) {
            if (this.nowSshConSize < StorageConfig.getExtendedConnectionQueueSize() && !this.establishSshConnection() && this.nowSshConSize == 0) {
                LOGGER.info("There is no connection in the queue and failed to create the SSH connection.");
                return null;
            }
        }
        this.devNode.setSshqueue(false);
        SshConnection sshCon = null;
        try {
            sshCon = this.queue.poll(30L, TimeUnit.MINUTES);
            if (sshCon == null) {
                LOGGER.info("Obtaining the SSH connection from the queue timed out.");
            }
        }
        catch (InterruptedException exception) {
            LOGGER.error("Failed to obtain the SSH connection from the queue.");
        }
        if (sshCon != null && !sshCon.isConnected()) {
            try {
                sshCon.connect();
            }
            catch (ToolException exception) {
                LOGGER.error("Failed to connect to SSH.", (Throwable)exception);
            }
        }
        return sshCon;
    }

    private boolean establishSshConnection() {
        boolean isConnected = true;
        try {
            ICliConnection sshCon = SshConnectionManager.getSshConnection((DevNode)this.devNode, (ISshJudge)new IpScaleOutSshJudge(), (boolean)true, (boolean)false);
            ++this.nowSshConSize;
            this.queue.put((SshConnection)sshCon);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to create the SSH connection.", (Throwable)exception);
            isConnected = false;
        }
        return isConnected;
    }

    public void putSshConnToQueue(SshConnection sshCon) {
        try {
            this.queue.put(sshCon);
        }
        catch (InterruptedException e) {
            LOGGER.error("Put into sshConnection queue eror.", (Throwable)e);
        }
    }

    public void clean() {
        try {
            while (this.queue.size() > 0) {
                SshConnection sshCon = this.queue.take();
                SshConnectionManager.releaseConnection((ICliConnection)sshCon);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Gut sshConnection from queue eror.", (Throwable)e);
        }
        this.nowSshConSize = 0;
    }

    public int getNowSshConSize() {
        return this.nowSshConSize;
    }
}

