/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectNodeType;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptType;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectLock;
import com.huawei.ism.tool.infocollect.service.backgroud.IUiObserver;
import com.huawei.ism.tool.infocollect.service.logic.command.CheckCollectingCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.ClearFcvCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateFcvCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.DescCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.GainFcvExecuteScriptCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.PythonCommand;
import com.huawei.ism.tool.infocollect.util.IPUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcvCollectTask
implements ICollectTask {
    private static final Logger log = LoggerFactory.getLogger(FcvCollectTask.class);
    private static CollectDataContext context = CollectDataContext.getInstance();
    private static final String DURATION_START_TIME = "durationStartTime";
    private CollectInfo collectInfo;
    private DevNode devNode;
    private IUiObserver progressObserver;
    private String scriptPath;
    private List<ScriptItem> executeScripts = new ArrayList<ScriptItem>();
    private JSONObject failedMsg = new JSONObject();
    private InfocollectUserOpData userOpData;
    private Map<String, Object> collectEnv = new HashMap<String, Object>();
    private CollectStatus nowStatus = CollectStatus.COLLECT_FAILED;
    private boolean isAllSuccess = true;

    public FcvCollectTask(CollectInfo collectInfo) {
        this.collectInfo = collectInfo;
        this.devNode = collectInfo.getDevNode();
        this.scriptPath = InfoConfiguration.getInstance().getPackageScriptPath(this.devNode);
    }

    public FcvCollectTask(CollectInfo collectInfo, IUiObserver progressObserver) {
        this(collectInfo);
        this.progressObserver = progressObserver;
    }

    @Override
    public boolean init() {
        ExecuteResult result = this.getExecuteScript();
        if (result.isSuccess()) {
            result = this.isCollecting();
        }
        return result.isSuccess();
    }

    private ExecuteResult getExecuteScript() {
        GainFcvExecuteScriptCommand command = new GainFcvExecuteScriptCommand(this.collectInfo);
        ExecuteResult result = command.process();
        if (result.isSuccess()) {
            this.executeScripts = command.getExecuteScripts();
        }
        this.observeExecuteResult(result);
        return result;
    }

    private ExecuteResult isCollecting() {
        CheckCollectingCommand command = new CheckCollectingCommand(this.devNode);
        ExecuteResult result = command.process();
        if (result.isSuccess()) {
            this.collectInfo.setCollecting();
        } else {
            result.setProgress(100);
        }
        this.observeExecuteResult(result);
        return result;
    }

    private void observeExecuteResult(ExecuteResult result) {
        if (result == null) {
            log.error("the result is null !!!");
            return;
        }
        result.setDevNode(this.devNode);
        CollectDataContext.getInstance().getCollectInfo(this.devNode).addExecuteResult(result);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(this.devNode);
    }

    @Override
    public JSONObject getFailedMsg() {
        return this.failedMsg;
    }

    @Override
    public void run() {
        InfoCollectLock.getInstance().tryLock(this.devNode.getDeviceSerialNumber());
        try {
            this.clearTempTimeData();
            this.initDeviceUserData();
            this.collectComputeStorageInfo();
        }
        finally {
            InfoCollectLock.getInstance().unLock(this.devNode.getDeviceSerialNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectComputeStorageInfo() {
        PythonCommand command;
        boolean isCreateFcvCollectEnvResultSuc;
        boolean isCollectResultSuc;
        block11: {
            block10: {
                isCollectResultSuc = true;
                isCreateFcvCollectEnvResultSuc = true;
                this.initUserData();
                CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(false);
                command = null;
                try {
                    ExecuteResult result = this.createFcvCollectEnv();
                    if (!result.isSuccess()) {
                        isCreateFcvCollectEnvResultSuc = false;
                        this.updateResult(result.getDetail());
                        this.clearFcvCollectEnv(isCollectResultSuc, isCreateFcvCollectEnvResultSuc, command);
                        if (CollectUIContext.getInstance().getMainDialog() == null) return;
                        CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
                        return;
                    }
                    command = new PythonCommand(this.collectEnv, this.scriptPath);
                    if (!this.collectInfoThroughFcv(command)) {
                        isCollectResultSuc = false;
                        this.updateResult(this.failedMsg.toString());
                        this.clearFcvCollectEnv(isCollectResultSuc, isCreateFcvCollectEnvResultSuc, command);
                        break block10;
                    }
                    InfoCollectUtil.upload(this.devNode, this.collectEnv);
                    this.updateResultSuccess();
                    this.clearFcvCollectEnv(isCollectResultSuc, isCreateFcvCollectEnvResultSuc, command);
                    break block11;
                }
                catch (Exception exception) {
                    log.error("collect info through fcv error. ", (Throwable)exception);
                    this.createErrResult();
                    return;
                }
            }
            if (CollectUIContext.getInstance().getMainDialog() == null) return;
            CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
            return;
        }
        if (CollectUIContext.getInstance().getMainDialog() == null) return;
        CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
        return;
        finally {
            this.clearFcvCollectEnv(isCollectResultSuc, isCreateFcvCollectEnvResultSuc, command);
            if (CollectUIContext.getInstance().getMainDialog() != null) {
                CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
            }
        }
    }

    private void initUserData() {
        List<InfocollectUserOpData> userOpList = CollectDataContext.getInstance().getUserOpList();
        this.userOpData = new InfocollectUserOpData();
        this.userOpData.setDevNode(EntityUtils.toNewDev((DevNode)this.devNode));
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        this.userOpData.setCollectNodeType(CollectNodeType.NODE);
        userOpList.add(this.userOpData);
    }

    private void createErrResult() {
        ExecuteResult result = new ExecuteResult();
        result.setDetail(ResourceUtil.getString((String)"infocollect.detail.postCollect.remind"));
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.postCollect"));
        result.setPyResult(true);
        result.setResult(false);
        result.setNowStatus(CollectStatus.COLLECT_FAILED);
        this.observeExecuteResult(result);
    }

    private void updateResultSuccess() {
        SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "", "running", "");
        context.putSilentProgress(this.devNode, context.calcProgressCollecting(1, 1));
        context.updateSilentResult(this.devNode, data);
    }

    private boolean collectInfoThroughFcv(PythonCommand command) {
        long startTime = System.currentTimeMillis();
        this.collectEnv.put(DURATION_START_TIME, startTime);
        boolean isSuccess = this.collectFcvItems(command);
        log.info("collect item result is: {}", (Object)isSuccess);
        return isSuccess;
    }

    private boolean collectFcvItems(PythonCommand command) {
        int dataItemCount = this.getCountDataItemNum();
        if (dataItemCount == 0) {
            log.error("The quantity of data items is 0.");
            return false;
        }
        log.info("start collect fcv items.");
        boolean isSucPreResult = true;
        String preStepId = "";
        AtomicInteger failedDataItemCount = new AtomicInteger(0);
        for (ScriptItem item : this.executeScripts) {
            if (this.isTerminateCollect(item, failedDataItemCount.intValue(), dataItemCount)) {
                return false;
            }
            this.collectEnv.put("currentItem", item);
            ExecuteResult result = this.collectAndRecordTime(command, item);
            this.updatePro();
            isSucPreResult = result.isSuccess();
            log.info("the item {} result is : {}", (Object)item.getStep(), (Object)isSucPreResult);
            if (this.postItemHandle(result, item, failedDataItemCount)) continue;
            return false;
        }
        this.postCollectProcess(failedDataItemCount, dataItemCount);
        log.info("collect fcv items finish");
        return true;
    }

    private boolean postItemHandle(ExecuteResult result, ScriptItem item, AtomicInteger failedDataItemCount) {
        this.saveItemResultAndRefresh(result, item);
        if (result.isSuccess()) {
            return true;
        }
        this.failedMsg.put(result.getDescription(), (Object)result.getDetail());
        if (ScriptType.FCV_COMMON.equals((Object)item.getType())) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            log.info("Failed to collect common collection items. Terminate Collection. The Terminate item is {}", (Object)item.getStep());
            return false;
        }
        failedDataItemCount.set(failedDataItemCount.intValue() + 1);
        return true;
    }

    private void saveItemResultAndRefresh(ExecuteResult result, ScriptItem item) {
        if (!result.isCollectAllInfo()) {
            this.isAllSuccess = false;
        }
        this.observeExecuteResult(result);
        context.putSilentProgress(this.devNode, context.calcProgressCollecting(this.executeScripts.indexOf(item) + 1, this.executeScripts.size()));
        context.updateSilentResult(this.devNode, new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "", "running", ""));
    }

    private boolean isTerminateCollect(ScriptItem item, int failedDataItemCount, int dataItemCount) {
        if (!CollectDataContext.getInstance().isStartCollect()) {
            log.info("is start collect: false.");
            return true;
        }
        if (ScriptType.FCV_COMMON.equals((Object)item.getType()) && failedDataItemCount == dataItemCount) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            log.info("All data collection failed. Terminate Collection. The Terminate item is {}", (Object)item.getStep());
            return true;
        }
        return false;
    }

    private ExecuteResult collectAndRecordTime(PythonCommand command, ScriptItem item) {
        long startTime = System.currentTimeMillis();
        ExecuteResult result = this.collecting(command, item);
        InfoCollectUtil.writeTime(startTime, item.getStep(), this.devNode.getIp());
        return result;
    }

    private ExecuteResult collecting(PythonCommand command, ScriptItem item) {
        int progress = InfoCollectUtil.computeProgress(this.executeScripts.indexOf(item) + 1, this.executeScripts.size());
        command.setScriptItem(item);
        command.setProgress(progress);
        ExecuteResult processingResult = command.newProcessingResult();
        processingResult.setItem(item);
        this.observeExecuteResult(processingResult);
        return command.process();
    }

    private void updatePro() {
        if (Objects.nonNull(this.progressObserver)) {
            this.progressObserver.update();
        }
    }

    private void postCollectProcess(AtomicInteger failedDataItemCount, int dataItemCount) {
        this.userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        this.nowStatus = this.checkResultStatus(failedDataItemCount.intValue(), dataItemCount);
        this.createCollectFinishResult();
    }

    private CollectStatus checkResultStatus(int failedDataItem, int dataItemCount) {
        if (failedDataItem > 0 && failedDataItem < dataItemCount) {
            this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
            return CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        return CollectStatus.COLLECT_FINISHED;
    }

    private void createCollectFinishResult() {
        String resultFilepath = this.collectEnv.get("collectRetDir") + File.separator + this.collectEnv.get("collectRetFileName");
        String resultSaveDes = ResourceUtil.getStringWithParams((String)"infocollect.detail.collectcommandfinish", (Object[])new Object[]{resultFilepath});
        DescCommand collectOverCommand = new DescCommand(resultSaveDes, true);
        ExecuteResult result = collectOverCommand.process();
        result.setProgress(92);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        InfoCollectCache.getInstance().saveCollectResultFile(this.devNode.getDeviceSerialNumber(), resultFilepath);
        this.observeExecuteResult(result);
    }

    private int getCountDataItemNum() {
        int count = 0;
        String preStep = "";
        for (ScriptItem item : this.executeScripts) {
            if (!ScriptType.FCV_DATA_COLLECT.equals((Object)item.getType()) || preStep.equals(item.getStep())) continue;
            ++count;
            preStep = item.getStep();
        }
        return count;
    }

    private void updateResult(String errMsg) {
        context.putSilentProgress(this.devNode, 100);
        SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "failed", "finished", errMsg);
        context.updateSilentResult(this.devNode, data);
    }

    private ExecuteResult createFcvCollectEnv() {
        CreateFcvCollectEnvCommand command = new CreateFcvCollectEnvCommand(this.devNode);
        this.observeExecuteResult(command.getCreateFcvEnvInitResult());
        ExecuteResult result = command.process();
        if (!CollectDataContext.getInstance().isStartCollect()) {
            log.error("The device still exits the collection mode.");
            result.setResult(false);
            return result;
        }
        if (result.isSuccess()) {
            this.collectEnv = command.getCollectEnv();
        }
        this.observeExecuteResult(result);
        return result;
    }

    private void clearFcvCollectEnv(boolean isCollectResultSuc, boolean isCreateFcvCollectEnvResultSuc, PythonCommand pythonCommand) {
        this.clearCommand(pythonCommand);
        this.setFilePermission(isCollectResultSuc);
        if (!CollectDataContext.getInstance().isStartCollect()) {
            log.error("The device still exits the collection mode.");
            return;
        }
        this.clearFcvCollectEnvCommand();
        this.createResultAndRefreshStatus(isCollectResultSuc, isCreateFcvCollectEnvResultSuc);
    }

    private void clearFcvCollectEnvCommand() {
        ClearFcvCollectEnvCommand clearFcvCollectEnvCommand = new ClearFcvCollectEnvCommand(this.devNode);
        ExecuteResult result = clearFcvCollectEnvCommand.process();
        this.observeExecuteResult(result);
    }

    private void createResultAndRefreshStatus(boolean isCollectResultSuc, boolean isCreateFcvCollectEnvResultSuc) {
        this.refreshStatus(isCollectResultSuc, isCreateFcvCollectEnvResultSuc);
        this.createEndResult(isCollectResultSuc, isCreateFcvCollectEnvResultSuc);
    }

    private void createEndResult(boolean isCollectResultSuc, boolean isCreateFcvCollectEnvResultSuc) {
        DescCommand descCommand = new DescCommand(ResourceUtil.getString((String)"infocollect.detail.fcv.collectover"), isCreateFcvCollectEnvResultSuc && isCollectResultSuc, this.collectInfo, Color.RED);
        ExecuteResult result = descCommand.process();
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result.setNowStatus(this.nowStatus);
        result.setProgress(100);
        this.observeExecuteResult(result);
    }

    private void refreshStatus(boolean isCollectResultSuc, boolean isCreateFcvCollectEnvResultSuc) {
        if (CollectStatus.COLLECT_FINISHED.equals((Object)this.nowStatus) && !this.isAllSuccess) {
            this.nowStatus = CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        if (!isCreateFcvCollectEnvResultSuc || !isCollectResultSuc) {
            CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(true);
        }
    }

    private void setFilePermission(boolean isCollectResultSuc) {
        String collectRet = this.collectEnv.get("collectRetDir") + File.separator + this.collectEnv.get("collectRetFileName");
        this.collectInfo.setCollectRetFilePath(collectRet);
        if (isCollectResultSuc) {
            com.huawei.ism.tool.base.utils.FileUtils.setFilePermissions((File)new File(collectRet));
        }
    }

    private void clearCommand(PythonCommand command) {
        if (command == null) {
            return;
        }
        command.clearUp();
    }

    private void initDeviceUserData() {
        this.userOpData = new InfocollectUserOpData();
        this.userOpData.setDevNode(EntityUtils.toNewDev((DevNode)this.devNode));
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(this.devNode);
        if (conf == null) {
            log.info("get collectConf is null, set userOpData failed!");
            return;
        }
        this.userOpData.setCollectNodeType(CollectNodeType.NODE);
        List<InfocollectUserOpData> userOpList = CollectDataContext.getInstance().getUserOpList();
        userOpList.add(this.userOpData);
    }

    private void clearTempTimeData() {
        String timeRecordFilePath = String.join((CharSequence)File.separator, InfoCollectUtil.TEMP_DIR_PATH, IPUtil.ipV6ToPeriod(this.devNode.getIp()));
        File timeDateFile = new File(timeRecordFilePath);
        if (timeDateFile.exists()) {
            FileUtils.deleteFile((File)timeDateFile);
        }
    }
}

