/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.config.IntegrateParser;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.logic.DoSetIntegrateNodesThread;
import com.huawei.ism.tool.infocollect.service.logic.command.ClearCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.PythonCommand;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class IntegrateTask {
    private IntegrateCollectInfo collectInfo;
    private String integrateScriptPath;
    private Map<String, Object> integrateEnv = new HashMap<String, Object>();
    private volatile List<DevNode> devNodes = new ArrayList<DevNode>();
    private String intergrateXmlString = "";
    private boolean hasResult = false;

    public IntegrateTask(IntegrateCollectInfo collectInfo, String integrateScriptPath) {
        this.collectInfo = collectInfo;
        this.integrateScriptPath = integrateScriptPath;
    }

    public String getIntegrateReturnXmlString() {
        return this.intergrateXmlString;
    }

    public IntegrateCollectInfo getCollectInfo() {
        return this.collectInfo;
    }

    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    public void doTask() {
        this.hasResult = this.isGetIntegrateEnv();
        try {
            if (!this.hasResult) {
                return;
            }
            ScriptItem integrateItem = this.createScriptItem();
            this.hasResult = this.processIntegrateCommand(integrateItem);
        }
        finally {
            this.doCleanJob();
        }
    }

    private void doCleanJob() {
        ClearCollectEnvCommand command = new ClearCollectEnvCommand(this.collectInfo.getDevNode(), this.collectInfo);
        command.process();
    }

    private ScriptItem createScriptItem() {
        ScriptItem item = new ScriptItem();
        item.setMainMethod("execute");
        item.setScriptFileName(this.integrateScriptPath);
        return item;
    }

    private boolean isGetIntegrateEnv() {
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(this.collectInfo, true);
        ExecuteResult result = command.process();
        if (result.isSuccess()) {
            this.integrateEnv = command.getCollectEnv();
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processIntegrateCommand(ScriptItem scriptItem) {
        PythonCommand command = null;
        try {
            command = new PythonCommand(this.integrateEnv, this.integrateScriptPath);
            command.setScriptItem(scriptItem);
            command.setProgress(100);
            ExecuteResult result = command.process();
            Object object = this.integrateEnv.get("integrate_back");
            if (object == null) {
                boolean bl = false;
                return bl;
            }
            this.intergrateXmlString = object.toString();
            boolean bl = result.isSuccess();
            return bl;
        }
        finally {
            if (null != command) {
                command.clearUp();
            }
        }
    }

    public void dealBatchXml() {
        try {
            if (!this.hasResult) {
                return;
            }
            IntegrateParser parser = new IntegrateParser(this.collectInfo.getDevNode());
            this.hasResult = parser.init(this.intergrateXmlString);
            if (this.hasResult) {
                this.devNodes = parser.getIntegrateInfoes();
                CollectDeviceService.getInstance().putIntegratedDebug(this.devNodes);
            }
        }
        finally {
            this.setBatchNodes(this.hasResult);
        }
    }

    private void setBatchNodes(boolean result) {
        SwingUtilities.invokeLater(new DoSetIntegrateNodesThread(result, this));
    }
}

