/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;

class NodeCollectStatus {
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private int serverId;
    private String serverTaskStatus = "waiting";
    private String nodeIp = "";
    private boolean downloadResult = false;

    public NodeCollectStatus(int serverId, String serverTaskStatus, String nodeIp) {
        this.serverId = serverId;
        this.serverTaskStatus = serverTaskStatus;
        this.nodeIp = nodeIp;
    }

    public String getServerTaskStatus() {
        return this.serverTaskStatus;
    }

    public void setServerTaskStatus(String serverTaskStatus) {
        this.serverTaskStatus = serverTaskStatus;
    }

    public boolean isNodeCollectSuccess() {
        return SUCCESS.equalsIgnoreCase(this.serverTaskStatus);
    }

    public boolean isNodeCollectFailed() {
        return FAILURE.equalsIgnoreCase(this.serverTaskStatus);
    }

    public boolean isNodeCollectFinished() {
        return SUCCESS.equalsIgnoreCase(this.serverTaskStatus) || FAILURE.equalsIgnoreCase(this.serverTaskStatus);
    }

    public String toString() {
        return ResourceUtil.getStringWithParams((String)"rest.collect.detail.server", (Object[])new Object[]{this.nodeIp, this.serverTaskStatus});
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getNodeIp() {
        return this.nodeIp;
    }

    public boolean isDownloadResult() {
        return this.downloadResult;
    }

    public void setDownloadResult(boolean downloadResult) {
        this.downloadResult = downloadResult;
    }

    public boolean needDownResult(List<String> downloadedNodeIpList) {
        return SUCCESS.equalsIgnoreCase(this.getServerTaskStatus()) && !downloadedNodeIpList.contains(this.getNodeIp());
    }
}

