/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResultUtils;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.DStorageConfig;
import com.huawei.ism.tool.infocollect.service.logic.DownOneNode;
import com.huawei.ism.tool.infocollect.service.logic.DownloadNodeObserver;
import com.huawei.ism.tool.infocollect.service.logic.NodeCollectStatus;
import com.huawei.ism.tool.infocollect.service.logic.PollTypeCollectBySubTask;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectTask;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.DownFileObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollTypeCollectByNodes
extends PollTypeCollectBySubTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollTypeCollectByNodes.class);
    private DownloadNodeObserver downloadNodeObserver;
    private ExecuteResult downFileTaskResult;
    private List<String> downloadedNodeIpList = new ArrayList<String>(5);
    private ExecutorService downExecutorService;
    private List<Future<String>> subTaskDownResultList = new ArrayList<Future<String>>();
    private List<String> subTaskdownErrorNodeIpList = new ArrayList<String>(5);
    private StringBuffer downloadErrorInfo = new StringBuffer();

    public PollTypeCollectByNodes(CollectModule cm, RestCollectTask task, DevNode devNode, UIProgressObserver ui) {
        super(cm, task, devNode, ui);
        task.setOnlyRunningMode(false);
        this.downExecutorService = Executors.newFixedThreadPool(DStorageConfig.getPollTypeCollectMaxConcurrent());
    }

    @Override
    public Map<String, Object> getCreateCollectTaskParm(List<CollectItem> selectItems) {
        Map<String, Object> reqParam = super.getCreateCollectTaskParm(selectItems);
        reqParam.put("info_pack", false);
        return reqParam;
    }

    @Override
    public boolean executeSubTaskDown(int subTaskProgress, boolean isSubTaskHasFile) {
        Map<Integer, NodeCollectStatus> subTaskNodeStatusMap = this.subTask.getNodesCollectStatusMap();
        this.downTaskResult(this.subTaskId, subTaskNodeStatusMap);
        if (subTaskProgress == 100) {
            this.postSubTaskCollect(this.subTaskId, subTaskNodeStatusMap);
            return false;
        }
        return true;
    }

    private void initDownFileTaskResult(int moduleStartProgress) {
        if (this.downFileTaskResult == null) {
            String exeItemDes = ResourceUtil.getString((String)"ds.storage.collect.download") + this.cm.getNameKey();
            this.downFileTaskResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, exeItemDes);
            this.task.observeExecuteResult(this.downFileTaskResult);
        }
    }

    private void initDownloadNodeObserver() {
        if (this.downloadNodeObserver == null) {
            this.downloadNodeObserver = new DownloadNodeObserver(this.ui, this.downFileTaskResult, this.devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).count());
            this.downloadNodeObserver.start();
        }
    }

    private void downTaskResult(int subTaskId, Map<Integer, NodeCollectStatus> subTaskNodeStatusMap) {
        subTaskNodeStatusMap.values().stream().filter(nodeStatus -> nodeStatus.needDownResult(this.downloadedNodeIpList)).peek(nodeStatus -> {
            this.initDownFileTaskResult(0);
            this.initDownloadNodeObserver();
        }).forEach(nodeStatus -> this.buildDownLoadTask(subTaskId, (NodeCollectStatus)nodeStatus));
    }

    private void buildDownLoadTask(int subTaskId, NodeCollectStatus nodeStatus) {
        DownFileObserver downFileObserver = new DownFileObserver();
        this.downloadNodeObserver.addDownFileObserver(downFileObserver);
        String nodeIp = nodeStatus.getNodeIp();
        this.downloadedNodeIpList.add(nodeIp);
        Future<String> result = this.downExecutorService.submit(new DownOneNode(this.devNode, this.task, this.buildDownParm(this.moduleTaskId, subTaskId, nodeStatus.getServerId()), this.localPath, nodeIp, this.subTaskdownErrorNodeIpList, downFileObserver, this.downloadNodeObserver));
        this.subTaskDownResultList.add(result);
    }

    private void postSubTaskCollect(int subTaskId, Map<Integer, NodeCollectStatus> subTaskNodeStatusMap) {
        this.witeNodeTasksFinished();
        this.setSubTaskErroInfo(subTaskId);
        this.cleanSubTaskAttribute();
        this.subTask.setDownloadFinish(true);
    }

    private void setSubTaskErroInfo(int subTaskId) {
        if (!this.subTaskdownErrorNodeIpList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.subTaskdownErrorNodeIpList.forEach(ip -> sb.append((String)ip).append(','));
            String errorNodes = sb.toString();
            this.downloadErrorInfo.append(ResourceUtil.getStringWithParams((String)"download.sub.task.result.failed", (Object[])new Object[]{this.moduleTaskId, subTaskId, errorNodes})).append("\r\n");
        }
    }

    private void witeNodeTasksFinished() {
        for (Future<String> result : this.subTaskDownResultList) {
            String re = null;
            try {
                re = result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("One node download error. ", (Throwable)e);
            }
            if (StringUtils.isNULLStr((String)re)) continue;
            this.subTaskdownErrorNodeIpList.add(re);
        }
    }

    private void cleanSubTaskAttribute() {
        if (this.downloadNodeObserver != null) {
            this.downloadNodeObserver.subtaskFinished();
        }
        this.subTaskDownResultList = new ArrayList<Future<String>>();
        this.subTaskdownErrorNodeIpList = new ArrayList<String>(5);
    }

    private Map<String, Object> buildDownParm(String moduleTaskId, int subTaskId, int nodeId) {
        HashMap<String, Object> reqPara = new HashMap<String, Object>();
        reqPara.put("task_id", moduleTaskId);
        reqPara.put("sub_task_id", subTaskId);
        reqPara.put("node_id", nodeId);
        return reqPara;
    }

    @Override
    public void post() {
        this.ui.updateProgress(this.downFileTaskResult, 99, "", ResourceUtil.getString((String)"ds.storage.collect.summarizing.information"));
    }

    @Override
    public void clean() {
        this.task.setOnlyRunningMode(true);
        if (this.downloadNodeObserver != null) {
            this.downloadNodeObserver.setTaskFinish(true);
        }
        this.downExecutorService.shutdown();
        String detail = this.downloadErrorInfo.toString();
        if (!StringUtils.isNULLStr((String)detail)) {
            this.downFileTaskResult.setResult(false);
            this.downFileTaskResult.setDetail(detail);
            this.dmcr.setHasDownNodeFile(true);
            this.task.observeExecuteResult(this.downFileTaskResult);
            this.task.updateRestCollectionTaskProgress(this.cm);
        } else if (this.downFileTaskResult != null) {
            this.downFileTaskResult.setResult(true);
        }
    }
}

