/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.DStorageModuleCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.PollTypeCollect;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectSubTask;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectTask;
import com.huawei.ism.tool.infocollect.util.ProgressUpdateByDow;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollTypeCollectBySubTask
implements PollTypeCollect {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollTypeCollectBySubTask.class);
    protected CollectModule cm;
    protected RestCollectTask task = null;
    protected DStorageModuleCollectTask dmcr;
    protected String moduleTaskId;
    protected DevNode devNode = null;
    protected UIProgressObserver ui = null;
    protected ExecuteResult executeTaskResult;
    protected String localPath;
    protected RestCollectSubTask subTask;
    protected int subTaskId;

    public PollTypeCollectBySubTask(CollectModule cm, RestCollectTask task, DevNode devNode, UIProgressObserver ui) {
        this.devNode = devNode;
        this.task = task;
        this.cm = cm;
        this.ui = ui;
    }

    @Override
    public Map<String, Object> getCreateCollectTaskParm(List<CollectItem> selectItems) {
        String collectType = this.cm.getModuleId();
        Map<String, Set<String>> microSrvIdListMap = this.constructMicroCompItemsPara(selectItems);
        List<Integer> clusterIds = this.getSelectedNodes();
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("type", collectType);
        if (collectType.equalsIgnoreCase("destroy")) {
            return reqParam;
        }
        reqParam.put("micro_comp", microSrvIdListMap);
        reqParam.put("nodes", clusterIds);
        if (!collectType.equalsIgnoreCase("config")) {
            long end;
            long start = (Long)this.task.getSelectedTime("start", "seconds");
            if (start != 0L) {
                reqParam.put("begin_time", start);
            }
            if ((end = ((Long)this.task.getSelectedTime("end", "seconds")).longValue()) != 0L) {
                reqParam.put("end_time", end);
            }
        }
        return reqParam;
    }

    @Override
    public boolean executeSubTaskDown(int subTaskProgress, boolean isSubTaskHasFile) {
        if (subTaskProgress == 100) {
            if (!isSubTaskHasFile) {
                this.task.setSubTaskFailed(this.cm, this.subTaskId, ResourceUtil.getString((String)"query.module.collect.task.failed"));
                return false;
            }
            return this.subTaskDownResult(this.subTaskId);
        }
        return true;
    }

    @Override
    public void initSubTask(int subTaskId, String moduleTaskId, DStorageModuleCollectTask dmcr) {
        this.subTaskId = subTaskId;
        this.moduleTaskId = moduleTaskId;
        this.dmcr = dmcr;
        this.executeTaskResult = dmcr.getModuleResult();
        this.localPath = this.task.getLocalPath(dmcr.getModuleId());
        this.subTask = dmcr.getSubTaskMap().get(subTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean subTaskDownResult(int subTaskId) {
        int progressPieceLength = 50 / this.task.getCurrentItemTaskIdAmount();
        int progressLast = (this.task.getItemTaskIdNum() - 1) * progressPieceLength * 2 + progressPieceLength;
        this.ui.updateProgress(progressLast, "");
        ProgressUpdateByDow progress = this.task.creatProgressUpdateByDow(this.ui, progressLast, progressPieceLength, false);
        try {
            progress.start();
            this.downResult(subTaskId);
            LOGGER.info("Sub task finished, and sub task result file download finished.");
            boolean bl = false;
            return bl;
        }
        finally {
            progress.setTaskFinish(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downResult(int subTaskId) {
        Map<String, Object> reqPara = this.buildDownParm(subTaskId);
        try {
            File localPathFile = new File(this.localPath);
            if (!localPathFile.exists() && !localPathFile.mkdirs()) {
                LOGGER.error("create local dir failed. dir : {}", (Object)this.localPath);
                throw new ToolException("Create dir failed.", false);
            }
            this.down(reqPara, this.localPath);
        }
        catch (Throwable t) {
            LOGGER.error("download module task: {} sub task id: {} result file exception.", new Object[]{this.moduleTaskId, subTaskId, t});
            this.buildErroMsg(subTaskId, this.subTask.getNodesString());
            boolean bl = false;
            return bl;
        }
        finally {
            this.subTask.setDownloadFinish(true);
        }
        return true;
    }

    private Map<String, Object> buildDownParm(int subTaskId) {
        HashMap<String, Object> reqPara = new HashMap<String, Object>();
        reqPara.put("task_id", this.moduleTaskId);
        reqPara.put("sub_task_id", subTaskId);
        return reqPara;
    }

    private void buildErroMsg(int subTaskId, String errorNodes) {
        this.task.setSubTaskFailed(this.cm, subTaskId, ResourceUtil.getStringWithParams((String)"download.sub.task.result.failed", (Object[])new Object[]{this.moduleTaskId, subTaskId, errorNodes}));
    }

    private void down(Map<String, Object> reqPara, String localPath) throws ToolException {
        long statusCode;
        ResponseInfo resp;
        String infoCollectSubTaskUri = RestUtil.getSubTaskResultFileUri((DevNode)this.devNode);
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
        if (this.task.needReConnResponseCode(conn, resp = conn.execGetFile(infoCollectSubTaskUri, reqPara, localPath))) {
            resp = conn.execGetFile(infoCollectSubTaskUri, reqPara, localPath);
        }
        if (200L != (statusCode = (long)resp.getStatusLine().getStatusCode())) {
            LOGGER.error("query tasks: {}  failed, and status code is: {}", (Object)this.moduleTaskId, (Object)statusCode);
            throw new ToolException("Http status is not ok.", false);
        }
        if (!RestCollectTask.downloadFileExist(resp)) {
            throw new ToolException("Result file not exist.");
        }
    }

    private Map<String, Set<String>> constructMicroCompItemsPara(List<CollectItem> selectItems) {
        HashMap<String, Set<String>> microSrvIdListMap = new HashMap<String, Set<String>>();
        List<CollectItem> moduleItems = this.cm.getItems();
        for (CollectItem ci : selectItems) {
            String microSrvId = ci.getMicroServiceId();
            String itemId = ci.getId();
            if (!moduleItems.contains(ci)) continue;
            Set itemSet = microSrvIdListMap.getOrDefault(microSrvId, new HashSet());
            itemSet.add(itemId);
            microSrvIdListMap.put(microSrvId, itemSet);
        }
        return microSrvIdListMap;
    }

    private List<Integer> getSelectedNodes() {
        ArrayList<Integer> clusterIds = new ArrayList<Integer>();
        for (ClusterNode cn : this.devNode.getClusterNodes()) {
            if (!cn.isSelected()) continue;
            clusterIds.add(cn.getId());
        }
        return clusterIds;
    }

    @Override
    public void clean() {
    }

    @Override
    public void post() {
    }
}

