/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.entity.PreParam;
import com.huawei.ism.tool.infocollect.entity.PreQueryDevNode;
import com.huawei.ism.tool.infocollect.entity.PreQueryResult;
import com.huawei.ism.tool.infocollect.service.logic.PreExecuterCaller;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreExecuter.class);
    private List<PreQueryDevNode> handleDevNodes;

    public PreExecuter(List<PreQueryDevNode> handleDevNodes) {
        this.handleDevNodes = handleDevNodes;
    }

    public Map<DevNode, String> queryPreCondition() {
        ArrayList<PreExecuterCaller> allCallers = new ArrayList<PreExecuterCaller>();
        for (PreQueryDevNode handleDevNode : this.handleDevNodes) {
            List<PreParam> params = handleDevNode.getParams();
            for (PreParam param : params) {
                PreExecuterCaller call = new PreExecuterCaller(param);
                call.setQueryNode(handleDevNode);
                call.rmThreadName();
                allCallers.add(call);
            }
        }
        return this.executeQuery(allCallers);
    }

    private Map<DevNode, String> executeQuery(List<PreExecuterCaller> allCallers) {
        ExecutorService taskExecutor = ThreadPoolHelper.getFixedNumThreadPool((int)10, (String)"pre_collect_query");
        ArrayList<Future<PreQueryResult>> fus = new ArrayList<Future<PreQueryResult>>();
        HashMap<DevNode, String> results = new HashMap<DevNode, String>();
        for (PreExecuterCaller preExecuterCaller : allCallers) {
            Future<PreQueryResult> f = taskExecutor.submit(preExecuterCaller);
            fus.add(f);
        }
        try {
            for (Future future : fus) {
                PreQueryResult result = (PreQueryResult)future.get();
                if (!result.isShow()) continue;
                results.put(result.getDevNode(), result.getRemind());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("executeQuery InterruptedException", (Object)e.getMessage());
            return null;
        }
        catch (ExecutionException e) {
            LOGGER.error("executeQuery ExecutionException", (Object)e.getMessage());
            return null;
        }
        return results;
    }
}

